/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filmeLaden.importieren;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import mediathek.controller.filmeLaden.importieren.DatenUrlFilmliste;

public class ListeDownloadUrlsFilmlisten
extends LinkedList<DatenUrlFilmliste> {
    public boolean addWithCheck(DatenUrlFilmliste film) {
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            if (!((DatenUrlFilmliste)it.next()).arr[1].equals(film.arr[1])) continue;
            return false;
        }
        return this.add(film);
    }

    public void sort() {
        int nr = 0;
        Collections.sort(this);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            String str = String.valueOf(nr++);
            while (str.length() < 3) {
                str = "0" + str;
            }
            ((DatenUrlFilmliste)it.next()).arr[0] = str;
        }
    }

    public String[][] getTableObjectData() {
        ListIterator iterator = this.listIterator();
        String[][] object = new String[this.size()][5];
        int i = 0;
        while (iterator.hasNext()) {
            DatenUrlFilmliste filmUpdate = (DatenUrlFilmliste)iterator.next();
            object[i] = filmUpdate.arr;
            ++i;
        }
        return object;
    }

    public int getNr(String url) {
        int nr = 0;
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext() && !((DatenUrlFilmliste)iterator.next()).arr[1].equals(url)) {
            ++nr;
        }
        if (nr >= this.size()) {
            nr = 0;
        }
        return nr;
    }

    public DatenUrlFilmliste getDatenUrlFilmliste(String url) {
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext()) {
            DatenUrlFilmliste update = (DatenUrlFilmliste)iterator.next();
            if (!update.arr[1].equals(url)) continue;
            return update;
        }
        return null;
    }

    public String getRand(ArrayList<String> bereitsGebraucht, int errcount) {
        int MAXMINUTEN = 50;
        int minCount = 3;
        if (errcount > 0) {
            minCount = 3 + 2 * errcount;
        }
        String ret = "";
        if (!this.isEmpty()) {
            DatenUrlFilmliste filmUpdate2;
            LinkedList<DatenUrlFilmliste> listeZeit = new LinkedList<DatenUrlFilmliste>();
            LinkedList<DatenUrlFilmliste> listePrio = new LinkedList<DatenUrlFilmliste>();
            Iterator it = this.iterator();
            Date today = new Date(System.currentTimeMillis());
            int minuten = 200;
            int count = 0;
            while (it.hasNext()) {
                filmUpdate2 = (DatenUrlFilmliste)it.next();
                if (bereitsGebraucht != null && bereitsGebraucht.contains(filmUpdate2.arr[1])) continue;
                String date = filmUpdate2.arr[2] + " " + filmUpdate2.arr[3];
                try {
                    Date d = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse(date);
                    minuten = Math.round((today.getTime() - d.getTime()) / 60000L);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                if (minuten < 50) {
                    listeZeit.add(filmUpdate2);
                    ++count;
                    continue;
                }
                if (count >= minCount) continue;
                listeZeit.add(filmUpdate2);
                ++count;
            }
            for (DatenUrlFilmliste filmUpdate2 : listeZeit) {
                if (filmUpdate2.arr[4].equals("1")) {
                    listePrio.add(filmUpdate2);
                    continue;
                }
                listePrio.add(filmUpdate2);
                listePrio.add(filmUpdate2);
            }
            if (listePrio.size() > 0) {
                int nr = new Random().nextInt(listePrio.size());
                filmUpdate2 = (DatenUrlFilmliste)listePrio.get(nr);
            } else {
                int nr = new Random().nextInt(this.size());
                filmUpdate2 = (DatenUrlFilmliste)this.get(nr);
            }
            ret = filmUpdate2.arr[1];
        }
        return ret;
    }
}

