/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.io.InputStream;
import java.security.CodeSource;
import javax.swing.JOptionPane;
import mediathek.Daten;
import mediathek.Main;
import mediathek.controller.io.IoXmlLesen;
import mediathek.daten.DDaten;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.dialog.DialogOk;
import mediathek.gui.dialogEinstellungen.DialogImportPset;
import mediathek.gui.dialogEinstellungen.PanelProgrammPfade;
import mediathek.gui.dialogEinstellungen.PanelPsetImport;

public class GuiFunktionenProgramme {
    public static String getPathJar() {
        String pFilePath = "pFile";
        File propFile = new File(pFilePath);
        if (!propFile.exists()) {
            try {
                CodeSource cS = Main.class.getProtectionDomain().getCodeSource();
                File jarFile = new File(cS.getLocation().toURI().getPath());
                String jarDir = jarFile.getParentFile().getPath();
                propFile = new File(jarDir + File.separator + pFilePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return propFile.getAbsolutePath().replace(pFilePath, "");
    }

    private static String getWindowsMplayerPath() {
        String PFAD_WIN_DEFAULT = "C:\\Program Files\\SMPlayer\\mplayer\\mplayer.exe";
        String PFAD_WIN = "\\SMPlayer\\mplayer\\mplayer.exe";
        String vlcPfad = "";
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows") && System.getenv("ProgramFiles") != null && new File(vlcPfad = System.getenv("ProgramFiles") + "\\SMPlayer\\mplayer\\mplayer.exe").exists()) {
                return vlcPfad;
            }
            if (System.getenv("ProgramFiles(x86)") != null && new File(vlcPfad = System.getenv("ProgramFiles(x86)") + "\\SMPlayer\\mplayer\\mplayer.exe").exists()) {
                return vlcPfad;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "C:\\Program Files\\SMPlayer\\mplayer\\mplayer.exe";
    }

    private static String getWindowsVlcPath() {
        String PFAD_WIN_DEFAULT = "C:\\Programme\\VideoLAN\\VLC\\vlc.exe";
        String PFAD_WIN = "\\VideoLAN\\VLC\\vlc.exe";
        String vlcPfad = "";
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows") && System.getenv("ProgramFiles") != null && new File(vlcPfad = System.getenv("ProgramFiles") + "\\VideoLAN\\VLC\\vlc.exe").exists()) {
                return vlcPfad;
            }
            if (System.getenv("ProgramFiles(x86)") != null && new File(vlcPfad = System.getenv("ProgramFiles(x86)") + "\\VideoLAN\\VLC\\vlc.exe").exists()) {
                return vlcPfad;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "C:\\Programme\\VideoLAN\\VLC\\vlc.exe";
    }

    public static String getMusterPfadMplayer() {
        String PFAD_LINUX = "/usr/bin/mplayer";
        String PFAD_MAC = "/Applications/VLC.app/Contents/MacOS/VLC";
        String pfad = "";
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            pfad = GuiFunktionenProgramme.getWindowsMplayerPath();
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            pfad = "/usr/bin/mplayer";
        } else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            pfad = "/Applications/VLC.app/Contents/MacOS/VLC";
        }
        if (new File(pfad).exists()) {
            return pfad;
        }
        return "";
    }

    public static String getMusterPfadVlc() {
        String PFAD_LINUX_VLC = "/usr/bin/vlc";
        String PFAD_MAC_VLC = "/Applications/VLC.app/Contents/MacOS/VLC";
        String pfad = "";
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            pfad = GuiFunktionenProgramme.getWindowsVlcPath();
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            pfad = "/usr/bin/vlc";
        } else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            pfad = "/Applications/VLC.app/Contents/MacOS/VLC";
        }
        if (new File(pfad).exists()) {
            return pfad;
        }
        return "";
    }

    public static String getMusterPfadFlv() {
        String PFAD_LINUX_FLV = "/usr/bin/flvstreamer";
        String PFAD_WINDOWS_FLV = "bin\\flvstreamer_win32_latest.exe";
        String pfad = "";
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            pfad = GuiFunktionenProgramme.getPathJar() + "bin\\flvstreamer_win32_latest.exe";
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            pfad = "/usr/bin/flvstreamer";
        }
        if (new File(pfad).exists()) {
            return pfad;
        }
        return "";
    }

    public static String getPfadMplayer() {
        if (Daten.system[36].equals("")) {
            new DialogOk(null, true, new PanelProgrammPfade(false, false, true), "Pfade Standardprogramme").setVisible(true);
        }
        return Daten.system[36];
    }

    public static String getPfadVlc() {
        if (Daten.system[34].equals("")) {
            new DialogOk(null, true, new PanelProgrammPfade(true, false, false), "Pfade Standardprogramme").setVisible(true);
        }
        return Daten.system[34];
    }

    public static String getPfadFlv() {
        if (Daten.system[35].equals("")) {
            new DialogOk(null, true, new PanelProgrammPfade(false, true, false), "Pfade Standardprogramme").setVisible(true);
        }
        return Daten.system[35];
    }

    public static String getPfadScript() {
        String PFAD_LINUX_SCRIPT = "bin/flv.sh";
        String PFAD_WINDOWS_SCRIPT = "bin\\flv.bat";
        String pfadScript = System.getProperty("os.name").toLowerCase().contains("linux") ? GuiFunktionenProgramme.getPathJar() + "bin/flv.sh" : (System.getProperty("os.name").toLowerCase().contains("mac") ? GuiFunktionenProgramme.getPathJar() + "bin/flv.sh" : GuiFunktionenProgramme.getPathJar() + "bin\\flv.bat");
        return pfadScript;
    }

    public static ListePset getStandardprogramme(DDaten ddaten) {
        InputStream datei = System.getProperty("os.name").toLowerCase().contains("linux") ? new GetFile().getPsetVorlageLinux() : (System.getProperty("os.name").toLowerCase().contains("mac") ? new GetFile().getPsetVorlageMac() : new GetFile().getPsetVorlageWindows());
        ListePset pSet = IoXmlLesen.importPset(datei, true);
        return pSet;
    }

    public static boolean addVorlagen(DDaten ddaten, ListePset pSet, boolean auto) {
        if (pSet != null) {
            if (!auto) {
                DialogImportPset dialog = new DialogImportPset(null, true, ddaten, pSet);
                dialog.setVisible(true);
                if (!dialog.ok) {
                    return false;
                }
            }
            if (ddaten.listePset.addPset(pSet)) {
                Daten.notifyMediathekListener(3, PanelPsetImport.class.getSimpleName());
                JOptionPane.showMessageDialog(null, pSet.size() + " Programmset importiert!", "Ok", 1);
            }
            return true;
        }
        JOptionPane.showMessageDialog(null, "Die Datei wurde nicht importiert!", "Fehler", 0);
        return false;
    }

    public static boolean praefixTesten(String str, String uurl, boolean praefix) {
        boolean ret = false;
        String url = uurl.toLowerCase();
        String s1 = "";
        if (str.equals("")) {
            ret = true;
        } else {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != ',') {
                    s1 = s1 + str.charAt(i);
                }
                if (str.charAt(i) != ',' && i < str.length() - 1) continue;
                if (praefix) {
                    if (url.startsWith(s1.toLowerCase())) {
                        ret = true;
                        break;
                    }
                } else if (url.endsWith(s1.toLowerCase())) {
                    ret = true;
                    break;
                }
                s1 = "";
            }
        }
        return ret;
    }

    public static boolean checkPfadBeschreibbar(String pfad) {
        boolean ret = false;
        File testPfad = new File(pfad);
        try {
            if (!pfad.equals("") && testPfad.isDirectory() && testPfad.canWrite()) {
                File tmpFile = File.createTempFile("mediathek", "tmp", testPfad);
                tmpFile.delete();
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean programmePruefen(DDaten daten) {
        String PIPE = "| ";
        String LEER = "      ";
        String PFEIL = " -> ";
        boolean ret = true;
        String text = "";
        for (DatenPset datenPset : daten.listePset) {
            ret = true;
            if (datenPset.isFreeLine() || datenPset.isLable()) continue;
            text = text + "++++++++++++++++++++++++++++++++++++++++++++\n";
            text = text + "| Programmgruppe: " + datenPset.arr[0] + "\n";
            String zielPfad = datenPset.arr[4];
            if (zielPfad.equals("")) {
                if (datenPset.needsPath()) {
                    ret = false;
                    text = text + "|       Zielpfad fehlt!\n";
                }
            } else {
                File pfad = new File(zielPfad);
                if (!pfad.isDirectory()) {
                    ret = false;
                    text = text + "|       Falscher Zielpfad!\n";
                    text = text + "|        -> Zielpfad \"" + zielPfad + "\" ist kein Verzeichnis!" + "\n";
                } else if (!GuiFunktionenProgramme.checkPfadBeschreibbar(zielPfad)) {
                    ret = false;
                    text = text + "|       Falscher Zielpfad!\n";
                    text = text + "|        -> Zielpfad \"" + zielPfad + "\" nicht beschreibbar!" + "\n";
                }
            }
            for (DatenProg datenProg : datenPset.getListeProg()) {
                if (new File(datenProg.arr[2]).canExecute()) continue;
                ret = false;
                text = text + "|       Falscher Programmpfad!\n";
                text = text + "|        -> Programmname: " + datenProg.arr[0] + "\n";
                text = text + "|             Pfad: " + datenProg.arr[2] + "\n";
                if (datenProg.arr[2].contains(File.separator)) continue;
                text = text + "|        -> Wenn das Programm nicht im Systempfad liegt, \n";
                text = text + "|             wird der Start nicht klappen!\n";
            }
            if (ret) {
                text = text + "|  -> Ok!\n";
            }
            text = text + "++++++++++++++++++++++++++++++++++++++++++++\n\n\n";
        }
        new DialogHilfe(null, true, text).setVisible(true);
        return ret;
    }
}

