/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.Daten;
import mediathek.controller.filme.BeobFilmeLaden;
import mediathek.controller.filme.FilmListenerElement;
import mediathek.daten.DDaten;
import mediathek.gui.PanelVorlage;

public class PanelSenderLaden
extends PanelVorlage {
    private JButton[] buttonSender;
    private String[] sender;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLabel jLabelProgress;
    private JLayeredPane jLayeredPane1;
    private JPanel jPanel4;
    private JProgressBar jProgressBar1;
    private JSpinner jSpinnerWarten;
    private JPanel panelSender;

    public PanelSenderLaden(DDaten d) {
        super(d);
        this.initComponents();
        this.ddaten = d;
        this.init();
        this.jSpinnerWarten.addChangeListener(new BeobSpinnerWarten());
    }

    private void init() {
        this.sender = Daten.filmeLaden.getSenderNamen();
        this.buttonSender = new JButton[this.sender.length];
        for (int i = 0; i < Daten.filmeLaden.getSenderNamen().length; ++i) {
            this.buttonSender[i] = new JButton(this.sender[i]);
            this.buttonSender[i].addActionListener(new BeobSenderLaden(this.sender[i]));
        }
        if (Daten.system[25].equals("")) {
            this.jSpinnerWarten.setValue(1);
            Daten.system[25] = "1";
        } else {
            this.jSpinnerWarten.setValue(Integer.parseInt(Daten.system[25]));
        }
        this.addSender();
        DDaten.filmeLaden.addAdListener(new BeobFilmeLaden(){

            @Override
            public void start(FilmListenerElement filmListenerElement) {
            }

            @Override
            public void progress(FilmListenerElement filmListenerElement) {
                PanelSenderLaden.this.jProgressBar1.setMaximum(filmListenerElement.max);
                PanelSenderLaden.this.jProgressBar1.setMinimum(0);
                PanelSenderLaden.this.jProgressBar1.setValue(filmListenerElement.progress);
                PanelSenderLaden.this.jProgressBar1.setStringPainted(true);
                PanelSenderLaden.this.jLabelProgress.setText(filmListenerElement.text);
            }

            @Override
            public void fertig(FilmListenerElement filmListenerElement) {
                PanelSenderLaden.this.jProgressBar1.setMaximum(0);
                PanelSenderLaden.this.jProgressBar1.setMinimum(0);
                PanelSenderLaden.this.jProgressBar1.setValue(0);
                PanelSenderLaden.this.jProgressBar1.setStringPainted(false);
                PanelSenderLaden.this.jLabelProgress.setText("");
                for (int i = 0; i < PanelSenderLaden.this.buttonSender.length; ++i) {
                    PanelSenderLaden.this.buttonSender[i].setEnabled(true);
                }
            }
        });
    }

    private void addSender() {
        this.panelSender.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        this.panelSender.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 1;
        int nr = 0;
        int y = 0;
        int halbe = this.sender.length / 2;
        halbe += this.sender.length % 2;
        for (int i = 0; i < this.sender.length; ++i) {
            c.gridy = y++;
            this.addPanel(gridbag, c, this.sender[i], nr);
            ++nr;
            if (y < halbe) continue;
            y = 0;
            c.gridx = 1;
        }
        JLabel label = new JLabel();
        c.gridx = 4;
        c.weightx = 2.0;
        gridbag.setConstraints(label, c);
        this.panelSender.add(label);
        this.panelSender.updateUI();
    }

    private void addPanel(GridBagLayout gridbag, GridBagConstraints c, String sender, int nr) {
        c.insets = new Insets(2, 10, 2, 2);
        gridbag.setConstraints(this.buttonSender[nr], c);
        this.panelSender.add(this.buttonSender[nr]);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLayeredPane1 = new JLayeredPane();
        this.panelSender = new JPanel();
        this.jPanel4 = new JPanel();
        this.jSpinnerWarten = new JSpinner();
        this.jLabel7 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabelProgress = new JLabel();
        this.panelSender.setBorder(BorderFactory.createTitledBorder("Sender"));
        GroupLayout panelSenderLayout = new GroupLayout(this.panelSender);
        this.panelSender.setLayout(panelSenderLayout);
        panelSenderLayout.setHorizontalGroup(panelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 468, Short.MAX_VALUE));
        panelSenderLayout.setVerticalGroup(panelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 28, Short.MAX_VALUE));
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jSpinnerWarten.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jLabel7.setText("Laden um den Faktor bremsen");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jSpinnerWarten, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(202, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jSpinnerWarten, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setText("Filme von den Websiten der Sender laden, kann etwas dauern!");
        this.jLabelProgress.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.panelSender, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jProgressBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelProgress, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelSender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jProgressBar1, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelProgress).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class BeobSpinnerWarten
    implements ChangeListener {
        private BeobSpinnerWarten() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            Daten.system[25] = String.valueOf(((Number)PanelSenderLaden.this.jSpinnerWarten.getModel().getValue()).intValue());
            Daten.setGeaendert();
        }
    }

    private class BeobSenderLaden
    implements ActionListener {
        private String sender;

        public BeobSenderLaden(String ssender) {
            this.sender = ssender;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanelSenderLaden.this.jLabelProgress.setText("");
            for (int i = 0; i < PanelSenderLaden.this.buttonSender.length; ++i) {
                PanelSenderLaden.this.buttonSender[i].setEnabled(false);
            }
            Daten.filmeLaden.updateSender(this.sender, Daten.listeFilme);
            Daten.setGeaendert();
        }
    }
}

