/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import mediathek.Daten;
import mediathek.controller.filme.FilmListenerElement;
import mediathek.controller.filme.filmeImportieren.MediathekListener;
import mediathek.controller.filme.filmeImportieren.MediathekTimer;

public final class InfoPanel
extends JPanel {
    public static final int IDX_NIX = 0;
    public static final int IDX_GUI_FILME = 1;
    public static final int IDX_GUI_DOWNLOAD = 2;
    public static final int IDX_GUI_ABO = 3;
    private final int IDX_MAX = 4;
    private String[] idx = new String[4];
    private int aktIdx = 0;
    private MediathekTimer mediathekTimer = new MediathekTimer();
    private JButton jButtonStop;
    private JLabel jLabelRechts;
    private JLabel jLabelStatusLinks;
    private JProgressBar jProgressBar1;

    public InfoPanel() {
        this.initComponents();
        this.clearProgress();
        for (int i = 0; i < 4; ++i) {
            this.idx[i] = "";
        }
        this.jLabelStatusLinks.setMinimumSize(new Dimension(25, 25));
        this.jLabelRechts.setMinimumSize(new Dimension(25, 25));
        this.jButtonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.filmeLaden.setStop();
            }
        });
        this.mediathekTimer.addAdListener(new BeobTimer());
    }

    public void setTextLinks(int i, String text) {
        this.idx[i] = text;
        this.setIdx(this.aktIdx);
    }

    public void setIdx(int i) {
        this.aktIdx = i;
        this.jLabelStatusLinks.setText(this.idx[i]);
    }

    public void setProgressBar(FilmListenerElement filmListenerElement) {
        this.jProgressBar1.setVisible(true);
        this.jButtonStop.setVisible(true);
        this.jProgressBar1.setMaximum(filmListenerElement.max);
        this.jProgressBar1.setMinimum(0);
        this.jProgressBar1.setValue(filmListenerElement.progress);
        this.jProgressBar1.setStringPainted(true);
    }

    public void clearProgress() {
        this.jProgressBar1.setVisible(false);
        this.jButtonStop.setVisible(false);
    }

    private void setInfoRechts() {
        String textRechts = "Filmliste erstellt: ";
        textRechts = textRechts + Daten.listeFilme.metaDaten[0];
        textRechts = textRechts + " Uhr  ||  Alter: ";
        int sekunden = Daten.listeFilme.alterFilmlisteSek();
        int minuten = sekunden / 60;
        String sek = String.valueOf(sekunden % 60);
        String min = String.valueOf(minuten % 60);
        String stu = String.valueOf(minuten / 60);
        while (sek.length() < 2) {
            sek = "0" + sek;
        }
        while (min.length() < 2) {
            min = "0" + min;
        }
        while (stu.length() < 2) {
            stu = "0" + stu;
        }
        textRechts = textRechts + stu + ":" + min + ":" + sek + " ";
        this.jLabelRechts.setText(textRechts);
    }

    private void initComponents() {
        this.jLabelStatusLinks = new JLabel();
        this.jLabelRechts = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jButtonStop = new JButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.setMinimumSize(new Dimension(15, 15));
        this.jLabelStatusLinks.setText("jLabel2");
        this.jLabelRechts.setText("jLabel1");
        this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/stop_16.png")));
        this.jButtonStop.setIconTextGap(1);
        this.jButtonStop.setMargin(new Insets(0, 10, 0, 10));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelStatusLinks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabelRechts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelStatusLinks).addComponent(this.jLabelRechts).addComponent(this.jProgressBar1, -2, -1, -2).addComponent(this.jButtonStop)));
        layout.linkSize(1, this.jButtonStop, this.jProgressBar1);
    }

    private class BeobTimer
    extends MediathekListener {
        private BeobTimer() {
        }

        @Override
        public void ping() {
            InfoPanel.this.setInfoRechts();
        }
    }
}

