/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filme.filmeSuchen.sender;

import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Log;
import mediathek.controller.filme.filmeSuchen.FilmeSuchen;
import mediathek.controller.io.GetUrl;
import mediathek.daten.DatenFilm;
import mediathek.tool.DatumZeit;
import mediathek.tool.GermanStringSorter;

public class MediathekReader
implements Runnable {
    String senderText = "";
    String senderName = "";
    int senderMaxThread = 4;
    long senderWartenSeiteLaden = 500L;
    boolean senderOn = true;
    boolean updateOn = false;
    int threads = 0;
    int max = 0;
    int progress = 0;
    LinkedList<String[]> listeThemen = new LinkedList();
    GetUrl getUrlIo;
    FilmeSuchen suchen;

    public MediathekReader(FilmeSuchen ssearch, String name, String text, int ssenderMaxThread, int ssenderWartenSeiteLaden) {
        this.suchen = ssearch;
        this.getUrlIo = new GetUrl();
        this.senderText = text;
        this.senderName = name;
        this.senderMaxThread = ssenderMaxThread;
        this.senderWartenSeiteLaden = ssenderWartenSeiteLaden;
    }

    public boolean istSenderAn() {
        return this.senderOn;
    }

    public void setSenderAn(boolean an) {
        this.senderOn = an;
    }

    public String getSenderName() {
        return this.senderName;
    }

    @Override
    public void run() {
        try {
            this.updateOn = false;
            this.threads = 0;
            this.addToList();
        }
        catch (Exception ex) {
            Log.fehlerMeldung("MediathekReader.run", ex, this.senderName);
        }
    }

    void addToList() {
    }

    void setInfo(int feld, String wert) {
        this.suchen.listeFilmeNeu.setInfo(feld, wert);
    }

    boolean addFilm(DatenFilm film) {
        return this.suchen.listeFilmeNeu.addFilmVomSender(film);
    }

    boolean istInListe(LinkedList<String[]> liste, String str, int nr) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            if (!((String[])it.next())[nr].equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    synchronized String[] getListeThemen() {
        return this.listeThemen.pollFirst();
    }

    boolean themaLaden(String sender, String thema) {
        boolean ret = true;
        return ret;
    }

    synchronized void meldungStart(int mmax) {
        this.max = mmax;
        this.progress = 0;
        this.suchen.melden(this.senderName, this.max, this.progress, "");
    }

    synchronized void meldungAddMax(int mmax) {
        this.max += mmax;
        this.suchen.melden(this.senderName, this.max, this.progress, "");
    }

    synchronized void meldungAddThread() {
        ++this.threads;
        this.suchen.melden(this.senderName, this.max, this.progress, "");
    }

    synchronized void meldungProgress(String text) {
        ++this.progress;
        this.suchen.melden(this.senderName, this.max, this.progress, text);
    }

    synchronized void meldung(String text) {
        this.suchen.melden(this.senderName, this.max, this.progress, text);
    }

    synchronized void meldungThreadUndFertig() {
        --this.threads;
        this.meldungFertig();
    }

    synchronized void meldungFertig() {
        if (this.threads <= 0) {
            Log.systemMeldung("Fertig " + this.senderName + ": " + DatumZeit.getJetzt_HH_MM_SS());
            this.suchen.meldenFertig(this.senderName);
        } else {
            this.suchen.melden(this.senderName, this.max, this.progress, "");
        }
    }

    String addsUrl(String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null && !pfad1.equals("") && !pfad2.equals("")) {
            ret = pfad1.charAt(pfad1.length() - 1) == '/' ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
            ret = pfad2.charAt(0) == '/' ? ret + pfad2 : ret + '/' + pfad2;
        }
        if (ret.equals("")) {
            Log.fehlerMeldung("MediathekReader.addsUrl", pfad1 + " " + pfad2);
        }
        return ret;
    }

    static void listeSort(LinkedList<String[]> liste, int stelle) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        if (liste != null) {
            for (int i = 1; i < liste.size(); ++i) {
                String str2;
                String str1;
                for (int k = i; k > 0 && sorter.compare(str1 = liste.get(k - 1)[stelle], str2 = liste.get(k)[stelle]) > 0; --k) {
                    liste.add(k - 1, liste.remove(k));
                }
            }
        }
    }
}

