/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filme;

import java.util.Iterator;
import javax.swing.event.EventListenerList;
import mediathek.controller.filme.FilmListener;
import mediathek.controller.filme.FilmListenerElement;
import mediathek.controller.filme.filmUpdateServer.ListeFilmUpdateServer;
import mediathek.controller.filme.filmeImportieren.FilmeImportieren;
import mediathek.controller.filme.filmeSuchen.FilmeSuchen;
import mediathek.controller.filme.filmeSuchen.sender.MediathekReader;
import mediathek.controller.io.GetUrl;
import mediathek.daten.DDaten;
import mediathek.daten.ListeFilme;
import mediathek.tool.GuiFunktionen;

public class FilmeLaden {
    public static final int UPDATE_FILME_AUS = 0;
    public static final int UPDATE_FILME_URL = 1;
    public static final int UPDATE_FILME_AUTO = 2;
    public static final int ALTER_FILMLISTE_SEKUNDEN_FUER_AUTOUPDATE = 10800;
    public static String updateUrl = "";
    private boolean stop = false;
    private ListeFilme listeFilmeAlt = null;
    private ListeFilme listeFilmeNeu = null;
    private FilmeSuchen filmeSuchen;
    private FilmeImportieren filmeImportieren;
    private EventListenerList listeners = new EventListenerList();
    private boolean istAmLaufen = false;

    public FilmeLaden() {
        this.filmeSuchen = new FilmeSuchen();
        this.filmeImportieren = new FilmeImportieren();
        this.filmeSuchen.addAdListener(new BeobLadenSuchen());
        this.filmeImportieren.addAdListener(new BeobLadenImportieren());
    }

    public void filmeLaden(DDaten daten) {
        if (GuiFunktionen.getImportArtFilme() == 0) {
            this.filmlisteImportieren(DDaten.system[22]);
        } else {
            this.filmlisteImportierenAuto();
        }
    }

    public synchronized void setStop() {
        this.stop = true;
    }

    public synchronized boolean getStop() {
        return this.stop;
    }

    public synchronized void resetStop() {
        this.stop = false;
    }

    public ListeFilmUpdateServer getListeFilmUpdateServer(boolean update) {
        if (update) {
            this.filmeImportieren.filmUpdateServer.suchen();
        }
        return this.filmeImportieren.filmUpdateServer.listeUpdateServer;
    }

    public int getSeitenGeladen() {
        return GetUrl.getSeitenZaehler();
    }

    public ListeFilme getListeFilme() {
        if (this.listeFilmeNeu != null) {
            return this.listeFilmeNeu;
        }
        return new ListeFilme();
    }

    public String[] getSenderNamen() {
        String[] ret = new String[this.filmeSuchen.mediathekListe.size()];
        Iterator it = this.filmeSuchen.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = ((MediathekReader)it.next()).getSenderName();
            ++i;
        }
        return ret;
    }

    public synchronized void filmlisteImportierenAuto() {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.stop = false;
            this.filmeImportieren.filmeImportierenAuto();
        }
    }

    public synchronized void filmlisteImportieren(String dateiUrl) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.stop = false;
            this.filmeImportieren.filmeImportierenDatei(dateiUrl, GuiFunktionen.istUrl(dateiUrl));
        }
    }

    public void filmeBeimSenderSuchen(ListeFilme llisteFilme, boolean allesLaden) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.stop = false;
            this.listeFilmeAlt = llisteFilme;
            this.filmeSuchen.filmeBeimSenderLaden(allesLaden, this.listeFilmeAlt);
        }
    }

    public void updateSender(String sender, ListeFilme llisteFilme) {
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.stop = false;
            this.listeFilmeAlt = llisteFilme;
            this.filmeSuchen.updateSender(sender, llisteFilme);
        }
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    public void notifyStart(FilmListenerElement filmListenerElement) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start(filmListenerElement);
        }
    }

    public void notifyProgress(FilmListenerElement filmListenerElement) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress(filmListenerElement);
        }
    }

    public void notifyFertig(FilmListenerElement filmListenerElement) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.fertig(filmListenerElement);
        }
    }

    private class BeobLadenImportieren
    implements FilmListener {
        private BeobLadenImportieren() {
        }

        @Override
        public synchronized void start(FilmListenerElement filmListenerElement) {
            FilmeLaden.this.notifyStart(filmListenerElement);
        }

        @Override
        public synchronized void progress(FilmListenerElement filmListenerElement) {
            FilmeLaden.this.notifyProgress(filmListenerElement);
        }

        @Override
        public synchronized void fertig(FilmListenerElement filmListenerElement) {
            FilmeLaden.this.listeFilmeNeu = ((FilmeLaden)FilmeLaden.this).filmeImportieren.listeFilme;
            ((FilmeLaden)FilmeLaden.this).filmeImportieren.listeFilme = null;
            FilmeLaden.this.istAmLaufen = false;
            FilmeLaden.this.notifyFertig(filmListenerElement);
        }
    }

    private class BeobLadenSuchen
    implements FilmListener {
        private BeobLadenSuchen() {
        }

        @Override
        public synchronized void start(FilmListenerElement filmListenerElement) {
            FilmeLaden.this.notifyStart(filmListenerElement);
        }

        @Override
        public synchronized void progress(FilmListenerElement filmListenerElement) {
            FilmeLaden.this.notifyProgress(filmListenerElement);
        }

        @Override
        public synchronized void fertig(FilmListenerElement filmListenerElement) {
            FilmeLaden.this.listeFilmeNeu = ((FilmeLaden)FilmeLaden.this).filmeSuchen.listeFilmeNeu;
            ((FilmeLaden)FilmeLaden.this).filmeSuchen.listeFilmeNeu = null;
            FilmeLaden.this.istAmLaufen = false;
            FilmeLaden.this.notifyFertig(filmListenerElement);
        }
    }
}

