/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.Daten;
import mediathek.DialogStarteinstellungen;
import mediathek.Log;
import mediathek.controller.filme.BeobFilmeLaden;
import mediathek.controller.filme.FilmListenerElement;
import mediathek.controller.filme.filmeImportieren.MediathekListener;
import mediathek.controller.io.CheckUpdate;
import mediathek.controller.io.IoXmlLesen;
import mediathek.controller.io.ProgrammLog;
import mediathek.daten.DDaten;
import mediathek.gui.GuiAbo;
import mediathek.gui.GuiDebug;
import mediathek.gui.GuiDownloads;
import mediathek.gui.GuiFilme;
import mediathek.gui.OSXAdapter;
import mediathek.gui.dialog.DialogLeer;
import mediathek.gui.dialog.DialogOk;
import mediathek.gui.dialog.PanelHilfe;
import mediathek.gui.dialogEinstellungen.DialogEinstellungen;
import mediathek.gui.dialogEinstellungen.PanelFilmlisteLaden;
import mediathek.tool.GuiFunktionen;

public final class MediathekGui
extends JFrame {
    public static final int ButtonAus = 0;
    public static final int ButtonFilme = 1;
    public static final int ButtonDonwload = 2;
    public static final int ButtonAbo = 3;
    private DDaten ddaten;
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private boolean debug = false;
    private BeobMausToolBar beobMausToolBar = new BeobMausToolBar();
    private DialogEinstellungen dialogEinstellungen;
    private JSpinner jSpinnerAnzahl = new JSpinner(new SpinnerNumberModel(1, 1, 9, 1));
    JLabel jLabelAnzahl = new JLabel("Anzahl gleichzeitige Downloads");
    JPanel jPanelAnzahl = new JPanel();
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler4;
    private JButton jButtonAbosAusschalten;
    private JButton jButtonAbosEinschalten;
    private JButton jButtonAbosLoeschen;
    private JButton jButtonDownloadAktualisieren;
    private JButton jButtonDownloadAufraeumen;
    private JButton jButtonDownloadLoeschen;
    private JButton jButtonDownloadStarten;
    private JButton jButtonDownloadZurueckstellen;
    private JButton jButtonFilmAbspielen;
    private JButton jButtonFilmSpeichern;
    private JButton jButtonFilmeLaden;
    private JCheckBoxMenuItem jCheckBoxIconKlein;
    private JCheckBoxMenuItem jCheckBoxMenuItemToolBar;
    private JCheckBoxMenuItem jCheckBoxMenuItemVideoplayer;
    private JMenu jMenu1;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu7;
    private JMenu jMenu9;
    private JMenuBar jMenuBar1;
    private JMenu jMenuDebug;
    private JMenu jMenuDownload;
    private JMenuItem jMenuItemAbosAendern;
    private JMenuItem jMenuItemAbosAusschalten;
    private JMenuItem jMenuItemAbosEinschalten;
    private JMenuItem jMenuItemAbosLoeschen;
    private JMenuItem jMenuItemAnleitung;
    private JMenuItem jMenuItemBeenden;
    private JMenuItem jMenuItemDownloadAendern;
    private JMenuItem jMenuItemDownloadsAktualisieren;
    private JMenuItem jMenuItemDownloadsAufraeumen;
    private JMenuItem jMenuItemDownloadsLoeschen;
    private JMenuItem jMenuItemDownloadsStarten;
    private JMenuItem jMenuItemDownloadsZurueckstellen;
    private JMenuItem jMenuItemEinstellungen;
    private JMenuItem jMenuItemFilmAbspielen;
    private JMenuItem jMenuItemFilmAufzeichnen;
    private JMenuItem jMenuItemFilmlisteLaden;
    private JMenuItem jMenuItemLoeschen;
    private JMenuItem jMenuItemProgrammlog;
    private JPanel jPanel1;
    private JPanel jPanelInfo;
    private JPopupMenu.Separator jSeparator2;
    private JTabbedPane jTabbedPane;
    private JToolBar jToolBar;

    public MediathekGui(String[] ar) {
        String pfad = "";
        boolean max = false;
        this.initComponents();
        if (ar != null) {
            if (ar.length > 0 && !ar[0].startsWith("-")) {
                if (!ar[0].endsWith(File.separator)) {
                    ar[0] = ar[0] + File.separator;
                }
                pfad = ar[0];
            }
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].equalsIgnoreCase("-D")) {
                    this.debug = true;
                }
                if (!ar[i].equals("-M")) continue;
                max = true;
            }
        }
        this.ddaten = new DDaten(pfad);
        DDaten.debug = this.debug;
        Log.startMeldungen(this.getClass().getName());
        this.jPanelInfo.setLayout(new BorderLayout());
        this.jPanelInfo.add((Component)this.ddaten.infoPanel, "Center");
        if (IoXmlLesen.einstellungenExistieren()) {
            this.ddaten.allesLaden();
        } else {
            new DialogStarteinstellungen(null, true, this.ddaten).setVisible(true);
        }
        this.setTitle("MediathekView 3.0.0");
        GuiFunktionen.setLook(this);
        this.init();
        this.setSize(max);
        this.dialogEinstellungen = new DialogEinstellungen(null, false, this.ddaten);
        this.registerForMacOSXEvents();
        new CheckUpdate(this, this.ddaten).suchen();
        if (GuiFunktionen.getImportArtFilme() == 2 && Daten.listeFilme.filmlisteIstAelter()) {
            DDaten.filmeLaden.filmlisteImportierenAuto();
        }
    }

    public void setToolbar(int nr) {
        switch (nr) {
            case 0: {
                this.buttonAus();
                break;
            }
            case 1: {
                this.buttonAus();
                this.jButtonFilmeLaden.setEnabled(true);
                this.jButtonFilmAbspielen.setEnabled(true);
                this.jButtonFilmSpeichern.setEnabled(true);
                this.jMenuItemFilmAbspielen.setEnabled(true);
                this.jMenuItemFilmAufzeichnen.setEnabled(true);
                break;
            }
            case 2: {
                this.buttonAus();
                this.jButtonFilmeLaden.setEnabled(true);
                this.jButtonDownloadAktualisieren.setEnabled(true);
                this.jButtonDownloadStarten.setEnabled(true);
                this.jButtonDownloadZurueckstellen.setEnabled(true);
                this.jButtonDownloadLoeschen.setEnabled(true);
                this.jButtonDownloadAufraeumen.setEnabled(true);
                this.jMenuItemDownloadsAktualisieren.setEnabled(true);
                this.jMenuItemDownloadsAufraeumen.setEnabled(true);
                this.jMenuItemDownloadsLoeschen.setEnabled(true);
                this.jMenuItemDownloadsStarten.setEnabled(true);
                this.jMenuItemDownloadAendern.setEnabled(true);
                this.jMenuItemDownloadsZurueckstellen.setEnabled(true);
                this.jSpinnerAnzahl.setEnabled(true);
                this.jLabelAnzahl.setEnabled(true);
                break;
            }
            case 3: {
                this.buttonAus();
                this.jButtonFilmeLaden.setEnabled(true);
                this.jButtonAbosLoeschen.setEnabled(true);
                this.jButtonAbosEinschalten.setEnabled(true);
                this.jButtonAbosAusschalten.setEnabled(true);
                this.jMenuItemAbosEinschalten.setEnabled(true);
                this.jMenuItemAbosAusschalten.setEnabled(true);
                this.jMenuItemAbosLoeschen.setEnabled(true);
                this.jMenuItemAbosAendern.setEnabled(true);
            }
        }
    }

    private void buttonAus() {
        this.jButtonFilmeLaden.setEnabled(false);
        this.jButtonFilmAbspielen.setEnabled(false);
        this.jButtonFilmSpeichern.setEnabled(false);
        this.jButtonDownloadAktualisieren.setEnabled(false);
        this.jButtonDownloadStarten.setEnabled(false);
        this.jButtonDownloadZurueckstellen.setEnabled(false);
        this.jButtonDownloadLoeschen.setEnabled(false);
        this.jButtonDownloadAufraeumen.setEnabled(false);
        this.jButtonAbosLoeschen.setEnabled(false);
        this.jButtonAbosEinschalten.setEnabled(false);
        this.jButtonAbosAusschalten.setEnabled(false);
        this.jMenuItemFilmAbspielen.setEnabled(false);
        this.jMenuItemFilmAufzeichnen.setEnabled(false);
        this.jMenuItemDownloadsAktualisieren.setEnabled(false);
        this.jMenuItemDownloadsAufraeumen.setEnabled(false);
        this.jMenuItemDownloadsLoeschen.setEnabled(false);
        this.jMenuItemDownloadsStarten.setEnabled(false);
        this.jMenuItemDownloadAendern.setEnabled(false);
        this.jMenuItemDownloadsZurueckstellen.setEnabled(false);
        this.jSpinnerAnzahl.setEnabled(false);
        this.jLabelAnzahl.setEnabled(false);
        this.jMenuItemAbosEinschalten.setEnabled(false);
        this.jMenuItemAbosAusschalten.setEnabled(false);
        this.jMenuItemAbosLoeschen.setEnabled(false);
        this.jMenuItemAbosAendern.setEnabled(false);
    }

    private void setSize(boolean max) {
        this.pack();
        if (max || Boolean.parseBoolean(Daten.system[8])) {
            this.setExtendedState(6);
        } else {
            int y;
            int x;
            try {
                x = Integer.parseInt(Daten.system[5]);
                y = Integer.parseInt(Daten.system[6]);
            }
            catch (Exception ex) {
                x = 0;
                y = 0;
            }
            if (x > 0 && y > 0) {
                this.setSize(new Dimension(x, y));
            }
        }
    }

    private void init() {
        this.initTabs();
        this.initMenue();
        this.initToolBar();
        DDaten.filmeLaden.addAdListener(new BeobFilmeLaden(){

            @Override
            public void start(FilmListenerElement filmListenerElement) {
                MediathekGui.this.jButtonFilmeLaden.setEnabled(false);
                MediathekGui.this.jMenuItemFilmlisteLaden.setEnabled(false);
            }

            @Override
            public void progress(FilmListenerElement filmListenerElement) {
                ((MediathekGui)MediathekGui.this).ddaten.infoPanel.setProgressBar(filmListenerElement);
            }

            @Override
            public void fertig(FilmListenerElement filmListenerElement) {
                ((MediathekGui)MediathekGui.this).ddaten.infoPanel.clearProgress();
                MediathekGui.this.jButtonFilmeLaden.setEnabled(true);
                MediathekGui.this.jMenuItemFilmlisteLaden.setEnabled(true);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MediathekGui.this.beenden();
            }
        });
        this.jToolBar.addMouseListener(this.beobMausToolBar);
    }

    private void initTabs() {
        this.ddaten.mediathekGui = this;
        this.ddaten.guiFilme = new GuiFilme(this.ddaten);
        this.ddaten.guiDownloads = new GuiDownloads(this.ddaten);
        this.ddaten.guiAbo = new GuiAbo(this.ddaten);
        this.ddaten.guiDebug = new GuiDebug(this.ddaten);
        this.jTabbedPane.addTab("Filme", this.ddaten.guiFilme);
        this.jTabbedPane.addTab("Downloads", this.ddaten.guiDownloads);
        this.jTabbedPane.addTab("Abos", this.ddaten.guiAbo);
        if (this.debug) {
            this.jTabbedPane.addTab("Debug", this.ddaten.guiDebug);
        }
    }

    private void initToolBar() {
        this.setIcon(Boolean.parseBoolean(Daten.system[7]));
        this.jButtonFilmeLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediathekGui.this.filmeLaden();
            }
        });
        this.jButtonFilmSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiFilme.filmSpeichern();
            }
        });
        this.jButtonFilmAbspielen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiFilme.filmAbspielen();
            }
        });
        this.jButtonDownloadAktualisieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.akualisieren();
            }
        });
        this.jButtonDownloadAufraeumen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.aufraeumen();
            }
        });
        this.jButtonDownloadLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.loeschen();
            }
        });
        this.jButtonDownloadStarten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.starten();
            }
        });
        this.jButtonDownloadZurueckstellen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.zurueckstellen();
            }
        });
        this.jMenuItemDownloadAendern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.aendern();
            }
        });
        this.jButtonAbosEinschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiAbo.einAus(true);
            }
        });
        this.jButtonAbosAusschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiAbo.einAus(false);
            }
        });
        this.jButtonAbosLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiAbo.loeschen();
            }
        });
    }

    private void initSpinner() {
        if (Daten.system[15].equals("")) {
            this.jSpinnerAnzahl.setValue(1);
            Daten.system[15] = "1";
        } else {
            this.jSpinnerAnzahl.setValue(Integer.parseInt(Daten.system[15]));
        }
    }

    private void initMenue() {
        this.initSpinner();
        this.jPanelAnzahl.setLayout(new BorderLayout());
        this.jPanelAnzahl.add((Component)this.jLabelAnzahl, "West");
        this.jPanelAnzahl.add((Component)this.jSpinnerAnzahl, "East");
        this.jLabelAnzahl.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/up_down_16.png")));
        this.jSpinnerAnzahl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Daten.system[15] = String.valueOf(((Number)MediathekGui.this.jSpinnerAnzahl.getModel().getValue()).intValue());
                Daten.notifyMediathekListener(5, MediathekGui.class.getSimpleName());
                DDaten.setGeaendert();
            }
        });
        Daten.addAdListener(new MediathekListener(5, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGui.this.initSpinner();
            }
        });
        this.jMenuDownload.add(this.jPanelAnzahl);
        this.jMenuItemEinstellungen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediathekGui.this.dialogEinstellungen.setVisible(true);
            }
        });
        this.jMenuItemBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediathekGui.this.beenden();
            }
        });
        this.jMenuItemFilmlisteLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediathekGui.this.filmeLaden();
            }
        });
        this.jMenuItemFilmAbspielen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiFilme.filmAbspielen();
            }
        });
        this.jMenuItemFilmAufzeichnen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiFilme.filmSpeichern();
            }
        });
        this.jMenuItemDownloadsAktualisieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.akualisieren();
            }
        });
        this.jMenuItemDownloadsAufraeumen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.aufraeumen();
            }
        });
        this.jMenuItemDownloadsLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.loeschen();
            }
        });
        this.jMenuItemDownloadsStarten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.starten();
            }
        });
        this.jMenuItemDownloadsZurueckstellen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiDownloads.zurueckstellen();
            }
        });
        this.jMenuItemAbosEinschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiAbo.einAus(true);
            }
        });
        this.jMenuItemAbosAusschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiAbo.einAus(false);
            }
        });
        this.jMenuItemAbosLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiAbo.loeschen();
            }
        });
        this.jMenuItemAbosAendern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MediathekGui)MediathekGui.this).ddaten.guiAbo.aendern();
            }
        });
        this.jCheckBoxMenuItemToolBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediathekGui.this.jToolBar.setVisible(MediathekGui.this.jCheckBoxMenuItemToolBar.isSelected());
            }
        });
        this.jCheckBoxIconKlein.setSelected(Boolean.parseBoolean(Daten.system[7]));
        this.jCheckBoxIconKlein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.setGeaendert();
                MediathekGui.this.setIcon(MediathekGui.this.jCheckBoxIconKlein.isSelected());
            }
        });
        this.jCheckBoxMenuItemVideoplayer.setSelected(Boolean.parseBoolean(Daten.system[9]));
        this.ddaten.guiFilme.videoPlayerAnzeigen(this.jCheckBoxMenuItemVideoplayer.isSelected());
        this.jCheckBoxMenuItemVideoplayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.setGeaendert();
                Daten.system[9] = String.valueOf(MediathekGui.this.jCheckBoxMenuItemVideoplayer.isSelected());
                ((MediathekGui)MediathekGui.this).ddaten.guiFilme.videoPlayerAnzeigen(MediathekGui.this.jCheckBoxMenuItemVideoplayer.isSelected());
            }
        });
        this.jMenuItemAnleitung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogOk dialogOk = new DialogOk(null, true, new PanelHilfe(MediathekGui.this.ddaten), "Hilfe zum Programm");
                dialogOk.setVisible(true);
            }
        });
        this.jMenuItemProgrammlog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgrammLog.LogDateiSchreiben(MediathekGui.this.ddaten);
            }
        });
        if (!DDaten.debug) {
            this.jMenuDebug.setVisible(false);
        } else {
            this.jMenuItemLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DDaten.listeFilme.clear();
                    DDaten.listeFilmeNachBlackList.clear();
                    Daten.notifyMediathekListener(4, MediathekGui.class.getSimpleName());
                }
            });
        }
    }

    private void beenden() {
        this.ddaten.allesAbbrechen();
        Daten.system[8] = this.getExtendedState() == 6 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        Daten.system[5] = String.valueOf(this.getSize().width);
        Daten.system[6] = String.valueOf(this.getSize().height);
        this.ddaten.allesSpeichern();
        this.dispose();
        System.exit(0);
    }

    private void setIcon(boolean klein) {
        Daten.system[7] = Boolean.toString(klein);
        this.jCheckBoxIconKlein.setSelected(klein);
        this.beobMausToolBar.itemKlein.setSelected(klein);
        if (klein) {
            this.jButtonFilmeLaden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/download_16.png")));
            this.jButtonFilmAbspielen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_play_16.png")));
            this.jButtonFilmSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_rec_16.png")));
            this.jButtonDownloadAktualisieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/view-refresh_16.png")));
            this.jButtonDownloadStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/next_16.png")));
            this.jButtonDownloadZurueckstellen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/undo_16.png")));
            this.jButtonDownloadLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_16.png")));
            this.jButtonDownloadAufraeumen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/edit-clear_16.png")));
            this.jButtonAbosLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_16.png")));
            this.jButtonAbosEinschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/ja_16.png")));
            this.jButtonAbosAusschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_16.png")));
        } else {
            this.jButtonFilmeLaden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/download_32.png")));
            this.jButtonFilmAbspielen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_play_32.png")));
            this.jButtonFilmSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_rec_32.png")));
            this.jButtonDownloadAktualisieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/view-refresh_32.png")));
            this.jButtonDownloadStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/next_32.png")));
            this.jButtonDownloadZurueckstellen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/undo_32.png")));
            this.jButtonDownloadLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_32.png")));
            this.jButtonDownloadAufraeumen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/edit-clear_32.png")));
            this.jButtonAbosLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_32.png")));
            this.jButtonAbosEinschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/ja_32.png")));
            this.jButtonAbosAusschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_32.png")));
        }
        this.repaint();
    }

    private void filmeLaden() {
        if (GuiFunktionen.getImportArtFilme() == 0) {
            DialogLeer dialog = new DialogLeer(null, true, new PanelFilmlisteLaden(this.ddaten), "Einstellungen zum Laden der Filme");
            dialog.setVisible(true);
        } else {
            this.jButtonFilmeLaden.setEnabled(false);
            this.jMenuItemFilmlisteLaden.setEnabled(false);
            Daten.setGeaendert();
            Daten.filmeLaden.filmeLaden(this.ddaten);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanelInfo = new JPanel();
        this.jToolBar = new JToolBar();
        this.jButtonFilmeLaden = new JButton();
        this.filler1 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.jButtonFilmAbspielen = new JButton();
        this.jButtonFilmSpeichern = new JButton();
        this.filler2 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.jButtonDownloadAktualisieren = new JButton();
        this.jButtonDownloadStarten = new JButton();
        this.jButtonDownloadZurueckstellen = new JButton();
        this.jButtonDownloadLoeschen = new JButton();
        this.jButtonDownloadAufraeumen = new JButton();
        this.filler4 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.jButtonAbosEinschalten = new JButton();
        this.jButtonAbosAusschalten = new JButton();
        this.jButtonAbosLoeschen = new JButton();
        this.jTabbedPane = new JTabbedPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItemFilmlisteLaden = new JMenuItem();
        this.jMenuItemEinstellungen = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemBeenden = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.jMenuItemFilmAbspielen = new JMenuItem();
        this.jMenuItemFilmAufzeichnen = new JMenuItem();
        this.jMenuDownload = new JMenu();
        this.jMenuItemDownloadsAktualisieren = new JMenuItem();
        this.jMenuItemDownloadsStarten = new JMenuItem();
        this.jMenuItemDownloadsZurueckstellen = new JMenuItem();
        this.jMenuItemDownloadsLoeschen = new JMenuItem();
        this.jMenuItemDownloadAendern = new JMenuItem();
        this.jMenuItemDownloadsAufraeumen = new JMenuItem();
        this.jMenu9 = new JMenu();
        this.jMenuItemAbosEinschalten = new JMenuItem();
        this.jMenuItemAbosAusschalten = new JMenuItem();
        this.jMenuItemAbosLoeschen = new JMenuItem();
        this.jMenuItemAbosAendern = new JMenuItem();
        this.jMenu7 = new JMenu();
        this.jCheckBoxMenuItemToolBar = new JCheckBoxMenuItem();
        this.jCheckBoxIconKlein = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemVideoplayer = new JCheckBoxMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItemAnleitung = new JMenuItem();
        this.jMenuItemProgrammlog = new JMenuItem();
        this.jMenuDebug = new JMenu();
        this.jMenuItemLoeschen = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setLayout(new BorderLayout());
        GroupLayout jPanelInfoLayout = new GroupLayout(this.jPanelInfo);
        this.jPanelInfo.setLayout(jPanelInfoLayout);
        jPanelInfoLayout.setHorizontalGroup(jPanelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1083, Short.MAX_VALUE));
        jPanelInfoLayout.setVerticalGroup(jPanelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.jPanel1.add((Component)this.jPanelInfo, "Last");
        this.jToolBar.setRollover(true);
        this.jButtonFilmeLaden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/download_32.png")));
        this.jButtonFilmeLaden.setToolTipText("neue Filmliste laden");
        this.jButtonFilmeLaden.setFocusable(false);
        this.jButtonFilmeLaden.setHorizontalTextPosition(0);
        this.jButtonFilmeLaden.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonFilmeLaden);
        this.jToolBar.add(this.filler1);
        this.jButtonFilmAbspielen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_play_32.png")));
        this.jButtonFilmAbspielen.setToolTipText("Film abspielen");
        this.jButtonFilmAbspielen.setFocusable(false);
        this.jButtonFilmAbspielen.setHorizontalTextPosition(0);
        this.jButtonFilmAbspielen.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonFilmAbspielen);
        this.jButtonFilmSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_rec_32.png")));
        this.jButtonFilmSpeichern.setToolTipText("Film speichern");
        this.jButtonFilmSpeichern.setFocusable(false);
        this.jButtonFilmSpeichern.setHorizontalTextPosition(0);
        this.jButtonFilmSpeichern.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonFilmSpeichern);
        this.jToolBar.add(this.filler2);
        this.jButtonDownloadAktualisieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/view-refresh_32.png")));
        this.jButtonDownloadAktualisieren.setToolTipText("Downloads aktualisieren");
        this.jButtonDownloadAktualisieren.setFocusable(false);
        this.jButtonDownloadAktualisieren.setHorizontalTextPosition(0);
        this.jButtonDownloadAktualisieren.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonDownloadAktualisieren);
        this.jButtonDownloadStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/next_32.png")));
        this.jButtonDownloadStarten.setToolTipText("alle Downloads starten");
        this.jButtonDownloadStarten.setFocusable(false);
        this.jButtonDownloadStarten.setHorizontalTextPosition(0);
        this.jButtonDownloadStarten.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonDownloadStarten);
        this.jButtonDownloadZurueckstellen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/undo_32.png")));
        this.jButtonDownloadZurueckstellen.setToolTipText("Download zur\u00fcckstellen");
        this.jButtonDownloadZurueckstellen.setFocusable(false);
        this.jButtonDownloadZurueckstellen.setHorizontalTextPosition(0);
        this.jButtonDownloadZurueckstellen.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonDownloadZurueckstellen);
        this.jButtonDownloadLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_32.png")));
        this.jButtonDownloadLoeschen.setToolTipText("Download l\u00f6schen");
        this.jButtonDownloadLoeschen.setFocusable(false);
        this.jButtonDownloadLoeschen.setHorizontalTextPosition(0);
        this.jButtonDownloadLoeschen.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonDownloadLoeschen);
        this.jButtonDownloadAufraeumen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/edit-clear_32.png")));
        this.jButtonDownloadAufraeumen.setToolTipText("Liste der Downloads aufr\u00e4umen");
        this.jButtonDownloadAufraeumen.setFocusable(false);
        this.jButtonDownloadAufraeumen.setHorizontalTextPosition(0);
        this.jButtonDownloadAufraeumen.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonDownloadAufraeumen);
        this.jToolBar.add(this.filler4);
        this.jButtonAbosEinschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/ja_32.png")));
        this.jButtonAbosEinschalten.setToolTipText("Abos einschalten");
        this.jButtonAbosEinschalten.setFocusable(false);
        this.jButtonAbosEinschalten.setHorizontalTextPosition(0);
        this.jButtonAbosEinschalten.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonAbosEinschalten);
        this.jButtonAbosAusschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_32.png")));
        this.jButtonAbosAusschalten.setToolTipText("Abos deaktivieren");
        this.jButtonAbosAusschalten.setFocusable(false);
        this.jButtonAbosAusschalten.setHorizontalTextPosition(0);
        this.jButtonAbosAusschalten.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonAbosAusschalten);
        this.jButtonAbosLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_32.png")));
        this.jButtonAbosLoeschen.setToolTipText("Abos l\u00f6schen");
        this.jButtonAbosLoeschen.setFocusable(false);
        this.jButtonAbosLoeschen.setHorizontalTextPosition(0);
        this.jButtonAbosLoeschen.setVerticalTextPosition(3);
        this.jToolBar.add(this.jButtonAbosLoeschen);
        this.jPanel1.add((Component)this.jToolBar, "First");
        this.jPanel1.add((Component)this.jTabbedPane, "Center");
        this.jMenu1.setText("Datei");
        this.jMenuItemFilmlisteLaden.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.jMenuItemFilmlisteLaden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/download_16.png")));
        this.jMenuItemFilmlisteLaden.setText("neue Filmliste laden");
        this.jMenu1.add(this.jMenuItemFilmlisteLaden);
        this.jMenuItemEinstellungen.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.jMenuItemEinstellungen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/configure_16.png")));
        this.jMenuItemEinstellungen.setText("Einstellungen");
        this.jMenuItemEinstellungen.setToolTipText("allgemeine Programmeinstellungen");
        this.jMenu1.add(this.jMenuItemEinstellungen);
        this.jMenu1.add(this.jSeparator2);
        this.jMenuItemBeenden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/exit_16.png")));
        this.jMenuItemBeenden.setText("Beenden");
        this.jMenu1.add(this.jMenuItemBeenden);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu4.setText("Filme");
        this.jMenuItemFilmAbspielen.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.jMenuItemFilmAbspielen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_play_16.png")));
        this.jMenuItemFilmAbspielen.setText("Film abspielen");
        this.jMenu4.add(this.jMenuItemFilmAbspielen);
        this.jMenuItemFilmAufzeichnen.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.jMenuItemFilmAufzeichnen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_rec_16.png")));
        this.jMenuItemFilmAufzeichnen.setText("Film aufzeichnen");
        this.jMenu4.add(this.jMenuItemFilmAufzeichnen);
        this.jMenuBar1.add(this.jMenu4);
        this.jMenuDownload.setText("Downloads");
        this.jMenuItemDownloadsAktualisieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/view-refresh_16.png")));
        this.jMenuItemDownloadsAktualisieren.setText("aktualisieren");
        this.jMenuDownload.add(this.jMenuItemDownloadsAktualisieren);
        this.jMenuItemDownloadsStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/next_16.png")));
        this.jMenuItemDownloadsStarten.setText("alle starten");
        this.jMenuDownload.add(this.jMenuItemDownloadsStarten);
        this.jMenuItemDownloadsZurueckstellen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/undo_16.png")));
        this.jMenuItemDownloadsZurueckstellen.setText("zur\u00fcckstellen");
        this.jMenuDownload.add(this.jMenuItemDownloadsZurueckstellen);
        this.jMenuItemDownloadsLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_16.png")));
        this.jMenuItemDownloadsLoeschen.setText("l\u00f6schen");
        this.jMenuDownload.add(this.jMenuItemDownloadsLoeschen);
        this.jMenuItemDownloadAendern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/configure_16.png")));
        this.jMenuItemDownloadAendern.setText("\u00e4ndern");
        this.jMenuDownload.add(this.jMenuItemDownloadAendern);
        this.jMenuItemDownloadsAufraeumen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/edit-clear_16.png")));
        this.jMenuItemDownloadsAufraeumen.setText("aufr\u00e4umen");
        this.jMenuDownload.add(this.jMenuItemDownloadsAufraeumen);
        this.jMenuBar1.add(this.jMenuDownload);
        this.jMenu9.setText("Abos");
        this.jMenuItemAbosEinschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/ja_16.png")));
        this.jMenuItemAbosEinschalten.setText("einschalten");
        this.jMenu9.add(this.jMenuItemAbosEinschalten);
        this.jMenuItemAbosAusschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_16.png")));
        this.jMenuItemAbosAusschalten.setText("ausschalten");
        this.jMenu9.add(this.jMenuItemAbosAusschalten);
        this.jMenuItemAbosLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_16.png")));
        this.jMenuItemAbosLoeschen.setText("l\u00f6schen");
        this.jMenu9.add(this.jMenuItemAbosLoeschen);
        this.jMenuItemAbosAendern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/configure_16.png")));
        this.jMenuItemAbosAendern.setText("\u00e4ndern");
        this.jMenu9.add(this.jMenuItemAbosAendern);
        this.jMenuBar1.add(this.jMenu9);
        this.jMenu7.setText("Ansicht");
        this.jCheckBoxMenuItemToolBar.setSelected(true);
        this.jCheckBoxMenuItemToolBar.setText("Toolbar");
        this.jMenu7.add(this.jCheckBoxMenuItemToolBar);
        this.jCheckBoxIconKlein.setSelected(true);
        this.jCheckBoxIconKlein.setText("kleine Icons");
        this.jMenu7.add(this.jCheckBoxIconKlein);
        this.jCheckBoxMenuItemVideoplayer.setText("weitere Videoplayer");
        this.jMenu7.add(this.jCheckBoxMenuItemVideoplayer);
        this.jMenuBar1.add(this.jMenu7);
        this.jMenu3.setText("Hilfe");
        this.jMenuItemAnleitung.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/agt_support.png")));
        this.jMenuItemAnleitung.setText("Hilfe und Fragen zum Programm");
        this.jMenu3.add(this.jMenuItemAnleitung);
        this.jMenuItemProgrammlog.setText("Programmlog in Datei schreiben");
        this.jMenu3.add(this.jMenuItemProgrammlog);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenuDebug.setText("Debug");
        this.jMenuItemLoeschen.setText("Filmliste l\u00f6schen");
        this.jMenuDebug.add(this.jMenuItemLoeschen);
        this.jMenuBar1.add(this.jMenuDebug);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 737, Short.MAX_VALUE));
        this.pack();
    }

    public void registerForMacOSXEvents() {
        if (MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quitForMac", null));
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
            }
        }
    }

    public void quitForMac() {
        this.beenden();
    }

    class BeobMausToolBar
    extends MouseAdapter {
        JCheckBoxMenuItem itemKlein = new JCheckBoxMenuItem("kleine Icons");
        JMenuItem itemAusblenden = new JMenuItem("Toolbar ausblenden");

        public BeobMausToolBar() {
            this.itemKlein.setSelected(Boolean.parseBoolean(Daten.system[7]));
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            this.itemAusblenden.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MediathekGui.this.jToolBar.setVisible(false);
                    MediathekGui.this.jCheckBoxMenuItemToolBar.setSelected(false);
                }
            });
            jPopupMenu.add(this.itemAusblenden);
            this.itemKlein.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Daten.setGeaendert();
                    MediathekGui.this.setIcon(BeobMausToolBar.this.itemKlein.isSelected());
                }
            });
            jPopupMenu.add(this.itemKlein);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public class JMenuItemSpinner
    extends JSpinner
    implements Accessible,
    MenuElement {
        @Override
        public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public MenuElement[] getSubElements() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Component getComponent() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

