/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.event.EventListenerList;
import mediathek.Daten;
import mediathek.Main;
import mediathek.controller.filme.filmeImportieren.MediathekListener;
import mediathek.tool.GuiFunktionenProgramme;

public class Log {
    public static final String LOG_FEHLER = "fehler";
    public static final String LOG_SYSTEM = "system";
    public static final String LOG_PLAYER = "player";
    private static EventListenerList listeners = new EventListenerList();
    private static boolean prog = false;

    public static void addAdListener(MediathekListener listener) {
        listeners.add(MediathekListener.class, listener);
    }

    public static synchronized void startMeldungen(String classname) {
        Log.systemMeldung("###########################################################");
        try {
            Log.systemMeldung("MediathekView 3.0.0");
            Date d = new Date(Main.class.getResource("Main.class").openConnection().getLastModified());
            Log.systemMeldung("Compiled: " + new SimpleDateFormat("dd.MM.yyyy, HH:mm").format(d));
        }
        catch (IOException ex) {
            // empty catch block
        }
        Log.systemMeldung("Klassenname: " + classname);
        Log.systemMeldung("");
        Log.systemMeldung("Programmpfad: " + GuiFunktionenProgramme.getPathJar());
        Log.systemMeldung("Verzeichnis Einstellungen: " + Daten.getBasisVerzeichnis());
        Log.systemMeldung("Useragent: " + Daten.getUserAgent());
        Log.systemMeldung("");
        long totalMem = Runtime.getRuntime().totalMemory();
        Log.systemMeldung("totalMemory: " + totalMem / 0x100000L + " MB");
        long maxMem = Runtime.getRuntime().maxMemory();
        Log.systemMeldung("maxMemory: " + maxMem / 0x100000L + " MB");
        long freeMem = Runtime.getRuntime().freeMemory();
        Log.systemMeldung("freeMemory: " + freeMem / 0x100000L + " MB");
        Log.systemMeldung("###########################################################");
    }

    public static synchronized void fehlerMeldung(String klasse, Exception ex) {
        Log.fehlermeldung(klasse, new String[]{ex.getMessage(), ""});
    }

    public static synchronized void fehlerMeldung(String klasse, Exception ex, String text) {
        String[] str = new String[]{ex.getLocalizedMessage(), text};
        Log.fehlermeldung(klasse, str);
    }

    public static synchronized void fehlerMeldung(String klasse, String text) {
        Log.fehlermeldung(klasse, new String[]{text});
    }

    public static synchronized void fehlerMeldung(String klasse, String[] text) {
        Log.fehlermeldung(klasse, text);
    }

    public static synchronized void systemMeldung(String[] text) {
        Log.meldung(text);
    }

    public static synchronized void systemMeldung(String text) {
        Log.meldung(new String[]{text});
    }

    public static synchronized void playerMeldung(String text) {
        Log.playermeldung(new String[]{text});
    }

    public static synchronized void progress(String texte) {
        prog = true;
        texte = texte + "\r";
        System.out.print(texte);
    }

    private static void fehlermeldung(String klasse, String[] texte) {
        if (prog) {
            System.out.print("                                                                            \r");
            prog = false;
        }
        String FEHLER = "Fehler: ";
        String z = "*";
        System.out.println("****************************");
        System.out.println("* Fehler: " + klasse);
        Log.notifyMediathekListener(LOG_FEHLER, "Fehler: " + klasse);
        for (int i = 0; i < texte.length; ++i) {
            System.out.println("*           " + texte[i]);
            Log.notifyMediathekListener(LOG_FEHLER, texte[i]);
        }
        System.out.println("****************************");
    }

    private static void meldung(String[] texte) {
        if (prog) {
            System.out.print("                                                                            \r");
            prog = false;
        }
        String SYSTEMMELDUNG = "";
        String z = ".";
        System.out.println(". " + texte[0]);
        Log.notifyMediathekListener(LOG_SYSTEM, texte[0]);
        for (int i = 1; i < texte.length; ++i) {
            System.out.println(". " + texte[i]);
            Log.notifyMediathekListener(LOG_SYSTEM, texte[i]);
        }
    }

    private static void playermeldung(String[] texte) {
        if (prog) {
            System.out.print("                                                                            \r");
            prog = false;
        }
        String z = "  >>";
        System.out.println("  >> " + texte[0]);
        Log.notifyMediathekListener(LOG_PLAYER, texte[0]);
        for (int i = 1; i < texte.length; ++i) {
            System.out.println("  >> " + texte[i]);
            Log.notifyMediathekListener(LOG_PLAYER, texte[i]);
        }
    }

    private static void notifyMediathekListener(String art, String zeile) {
        for (MediathekListener l : (MediathekListener[])listeners.getListeners(MediathekListener.class)) {
            l.ping(art, zeile);
        }
    }
}

