/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mediathek.Daten;
import mediathek.Log;
import mediathek.daten.DDaten;
import mediathek.daten.ListePset;
import mediathek.gui.beobachter.EscBeenden;
import mediathek.gui.dialogEinstellungen.PanelProgrammPfade;
import mediathek.gui.dialogEinstellungen.PanelPsetKurz;
import mediathek.gui.dialogEinstellungen.PanelPsetLang;
import mediathek.importOld.IoXmlLesen__old;
import mediathek.tool.GuiFunktionenProgramme;

public class DialogStarteinstellungen
extends JDialog {
    DDaten ddaten;
    private final int STAT_START = 1;
    private final int STAT_PFAD = 2;
    private final int STAT_PSET = 3;
    private final int STAT_FERTIG = 4;
    private int status = 1;
    private JButton jButtonAlt;
    private JButton jButtonStandard;
    private JButton jButtonZiel;
    private JCheckBox jCheckBoxAlleEinstellungen;
    private JCheckBox jCheckBoxAnpassen;
    private JCheckBox jCheckBoxSuchen;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel7;
    private JPanel jPanelExtra;
    private JScrollPane jScrollPane1;
    private JTextField jTextField2;
    private JTextField jTextFieldPfad;

    public DialogStarteinstellungen(Frame parent, boolean modal, DDaten dd) {
        super(parent, modal);
        this.initComponents();
        this.ddaten = dd;
        this.setTitle("Erster Start");
        this.jButtonStandard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStarteinstellungen.this.jCheckBoxAnpassen.setVisible(false);
                DialogStarteinstellungen.this.weiter();
            }
        });
        this.jButtonAlt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStarteinstellungen.this.alt();
            }
        });
        this.jButtonZiel.addActionListener(new ZielBeobachter());
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogStarteinstellungen.this.weiter();
            }
        };
        this.jCheckBoxAlleEinstellungen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogStarteinstellungen.this.status = 3;
                DialogStarteinstellungen.this.weiter();
            }
        });
        this.jCheckBoxSuchen.setSelected(true);
        Daten.system[27] = Boolean.TRUE.toString();
        this.jCheckBoxSuchen.addActionListener(new BeobCheckBoxSuchen());
        String dateiAlt = IoXmlLesen__old.altExistiert();
        this.jTextFieldPfad.setText(dateiAlt);
        Daten.system[36] = GuiFunktionenProgramme.getMusterPfadMplayer();
        Daten.system[34] = GuiFunktionenProgramme.getMusterPfadVlc();
        Daten.system[35] = GuiFunktionenProgramme.getMusterPfadFlv();
    }

    private void weiter() {
        switch (this.status) {
            case 1: {
                this.statusStart();
                break;
            }
            case 2: {
                this.statusPfade();
                break;
            }
            case 3: {
                this.statusPset();
                break;
            }
            default: {
                this.beenden();
            }
        }
    }

    private void alt() {
        if (!this.jTextFieldPfad.getText().equals("")) {
            new IoXmlLesen__old().importOld(this.ddaten, this.jTextFieldPfad.getText());
            this.status = 3;
            this.weiter();
        }
    }

    private void statusStart() {
        this.jButtonStandard.setText("Weiter");
        if (Daten.system[34].equals("") || Daten.system[35].equals("")) {
            this.status = 2;
        } else if (this.jCheckBoxAnpassen.isSelected()) {
            this.status = 2;
        } else {
            ListePset pSet = GuiFunktionenProgramme.getStandardprogramme(this.ddaten);
            if (pSet != null) {
                this.ddaten.listePset.addPset(pSet);
                this.status = 4;
            } else {
                this.status = 3;
            }
        }
        this.weiter();
    }

    private void statusPfade() {
        this.jCheckBoxAnpassen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.setVisible(false);
        this.jScrollPane1.setViewportView(new PanelProgrammPfade(true, true, false));
        this.status = 3;
        this.jButtonStandard.setText("Weiter");
    }

    private void statusPset() {
        this.jCheckBoxAnpassen.setVisible(false);
        this.jCheckBoxAlleEinstellungen.setVisible(true);
        if (this.ddaten.listePset.size() == 0) {
            this.ddaten.listePset.addPset(GuiFunktionenProgramme.getStandardprogramme(this.ddaten));
        }
        if (this.jCheckBoxAlleEinstellungen.isSelected()) {
            this.jScrollPane1.setViewportView(new PanelPsetLang(this.ddaten, this.ddaten.listePset));
        } else {
            this.jScrollPane1.setViewportView(new PanelPsetKurz(this.ddaten, this.ddaten.listePset));
        }
        this.status = 4;
        this.jButtonStandard.setText("Weiter");
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jButtonStandard = new JButton();
        this.jCheckBoxAlleEinstellungen = new JCheckBox();
        this.jCheckBoxAnpassen = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.jPanel7 = new JPanel();
        this.jCheckBoxSuchen = new JCheckBox();
        this.jTextField2 = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButtonZiel = new JButton();
        this.jTextFieldPfad = new JTextField();
        this.jLabel1 = new JLabel();
        this.jButtonAlt = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 255), 3));
        this.jButtonStandard.setText("Mit Standardeinstellungen starten");
        this.jCheckBoxAlleEinstellungen.setText("alle Einstellungen anzeigen");
        this.jCheckBoxAnpassen.setText("vorher anpassen");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxAlleEinstellungen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxAnpassen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonStandard).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonStandard).addComponent(this.jCheckBoxAlleEinstellungen).addComponent(this.jCheckBoxAnpassen)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Programmupdate"));
        this.jCheckBoxSuchen.setSelected(true);
        this.jCheckBoxSuchen.setText("Einmal am Tag nach einer neuen Programmversion suchen");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxSuchen).addContainerGap(243, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jCheckBoxSuchen).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextField2.setBackground(new Color(204, 204, 204));
        this.jTextField2.setFont(new Font("Dialog", 1, 14));
        this.jTextField2.setHorizontalAlignment(0);
        this.jTextField2.setText("Alte Einstellungen");
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jButtonZiel.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/fileopen_16.png")));
        this.jButtonZiel.setContentAreaFilled(false);
        this.jTextFieldPfad.setEditable(false);
        this.jLabel1.setText("Pfad:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPfad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.jTextFieldPfad, -2, -1, -2).addComponent(this.jButtonZiel)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldPfad);
        this.jButtonAlt.setText("Mit alten Einstellungen starten");
        this.jButtonAlt.setContentAreaFilled(false);
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtraLayout.createSequentialGroup().addContainerGap().addGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField2, GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanelExtraLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonAlt))).addContainerGap()));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelExtraLayout.createSequentialGroup().addContainerGap().addComponent(this.jTextField2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButtonAlt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 217, Short.MAX_VALUE).addComponent(this.jPanel7, -2, -1, -2).addContainerGap()));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private class BeobCheckBoxSuchen
    implements ActionListener {
        private BeobCheckBoxSuchen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Daten.system[27] = Boolean.toString(DialogStarteinstellungen.this.jCheckBoxSuchen.isSelected());
        }
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileHidingEnabled(false);
            if (!DialogStarteinstellungen.this.jTextFieldPfad.getText().equals("")) {
                chooser.setCurrentDirectory(new File(DialogStarteinstellungen.this.jTextFieldPfad.getText()));
            }
            chooser.setFileSelectionMode(0);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                try {
                    DialogStarteinstellungen.this.jTextFieldPfad.setText(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Exception ex) {
                    Log.fehlerMeldung("DialogImportOld.ZielBeobachter", ex);
                }
            }
        }
    }
}

