/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Provider;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.LibraryFileList;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.library.LibraryPanel;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class ShowInListMenu
extends JMenu {
    private final Provider<List<File>> selectedFiles;
    private LibraryPanel libraryPanel;
    private final ShowInListMenuIcons icons = new ShowInListMenuIcons();
    private Provider<LocalFileList> selectedLocalFileList;

    public ShowInListMenu(Provider<List<File>> selectedFiles) {
        this(selectedFiles, null);
    }

    public ShowInListMenu(Provider<List<File>> selectedFiles, Provider<LocalFileList> selectedLocalFileList) {
        super(I18n.tr("Show in List"));
        this.selectedFiles = selectedFiles;
        this.selectedLocalFileList = selectedLocalFileList;
    }

    public void initialize(final SharedFileListManager manager, final LibraryManager libraryManager, LibraryPanel libraryPanel, final boolean showLibrary) {
        this.libraryPanel = libraryPanel;
        this.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                ShowInListMenu menu = ShowInListMenu.this;
                menu.removeAll();
                if (!((List)ShowInListMenu.this.selectedFiles.get()).isEmpty()) {
                    File selectedFile = (File)((List)ShowInListMenu.this.selectedFiles.get()).get(0);
                    LibraryFileList libraryList = libraryManager.getLibraryManagedList();
                    if (showLibrary) {
                        menu.add(new ShowAction(I18n.tr("Library"), ShowInListMenu.this.getListIcon(libraryList), libraryList, selectedFile));
                    }
                    manager.getModel().getReadWriteLock().readLock().lock();
                    try {
                        boolean addSeperator = false;
                        for (SharedFileList fileList : manager.getModel()) {
                            if (!fileList.contains(selectedFile) || ShowInListMenu.this.selectedLocalFileList != null && fileList == ShowInListMenu.this.selectedLocalFileList.get()) continue;
                            menu.add(new ShowAction(fileList.getCollectionName(), ShowInListMenu.this.getListIcon(fileList), fileList, selectedFile));
                            addSeperator = true;
                        }
                        if (addSeperator && showLibrary) {
                            menu.insertSeparator(1);
                        }
                    }
                    finally {
                        manager.getModel().getReadWriteLock().readLock().unlock();
                    }
                }
                if (menu.getMenuComponentCount() < 1) {
                    menu.add(new JMenuItem(I18n.tr("empty"))).setEnabled(false);
                }
            }
        });
        this.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (ShowInListMenu.this.getPopupMenu().getPreferredSize().width > 300) {
                    ShowInListMenu.this.getPopupMenu().setPreferredSize(new Dimension(300, ShowInListMenu.this.getPopupMenu().getPreferredSize().height));
                }
            }
        });
        this.add(new JMenuItem(I18n.tr("empty")));
    }

    private Icon getListIcon(LocalFileList localFileList) {
        if (localFileList instanceof SharedFileList) {
            if (((SharedFileList)localFileList).isPublic()) {
                return this.icons.publicIcon;
            }
            if (((SharedFileList)localFileList).getFriendIds().size() == 0) {
                return this.icons.unsharedIcon;
            }
            return this.icons.sharedIcon;
        }
        return this.icons.libraryIcon;
    }

    private static class ShowInListMenuIcons {
        @Resource
        private Icon libraryIcon;
        @Resource
        private Icon publicIcon;
        @Resource
        private Icon unsharedIcon;
        @Resource
        private Icon sharedIcon;

        public ShowInListMenuIcons() {
            GuiUtils.assignResources(this);
        }
    }

    private class ShowAction
    extends AbstractAction {
        private final LocalFileList localFileList;
        private final File selectedFile;

        public ShowAction(String text, Icon icon, LocalFileList localFileList, File selectedFile) {
            super(text);
            this.putValue("SmallIcon", icon);
            this.localFileList = localFileList;
            this.selectedFile = selectedFile;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowInListMenu.this.libraryPanel.selectLocalFileList(this.localFileList);
            ShowInListMenu.this.libraryPanel.selectAndScrollTo(this.selectedFile);
        }
    }
}

