/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.matchers.Matcher;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.components.RangeSlider;
import org.limewire.ui.swing.filter.AbstractFilter;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.RangeFilterFormat;
import org.limewire.ui.swing.util.I18n;

class RangeFilter<E extends FilterableItem>
extends AbstractFilter<E> {
    private final JPanel panel = new JPanel();
    private final JLabel headerLabel = new JLabel();
    private final JLabel valueLabel = new JLabel();
    private final RangeSlider slider = new RangeSlider();
    private final RangeFilterFormat<E> rangeFormat;
    private boolean resetAdjusting;

    public RangeFilter(RangeFilterFormat<E> rangeFormat) {
        this.rangeFormat = rangeFormat;
        AbstractFilter.FilterResources resources = this.getResources();
        this.panel.setLayout(new MigLayout("insets 0 0 0 0, gap 0!", "[left,grow]", "[top][top]3[top]"));
        this.panel.setOpaque(false);
        this.headerLabel.setFont(resources.getHeaderFont());
        this.headerLabel.setForeground(resources.getHeaderColor());
        this.headerLabel.setText(rangeFormat.getHeaderText());
        this.valueLabel.setFont(resources.getRowFont());
        this.valueLabel.setForeground(resources.getRowColor());
        this.slider.setMinimum(0);
        this.slider.setMaximum(rangeFormat.getValues().length - 1);
        this.slider.setOpaque(false);
        this.slider.setPreferredSize(new Dimension(resources.getFilterWidth(), this.slider.getPreferredSize().height));
        this.slider.setFocusable(false);
        this.slider.setRequestFocusEnabled(false);
        this.slider.setUpperThumbEnabled(rangeFormat.isUpperLimitEnabled());
        this.resetSliderRange();
        this.slider.addChangeListener(new SliderListener());
        this.panel.add((Component)this.headerLabel, "gap 6 6, wrap");
        this.panel.add((Component)this.valueLabel, "gap 6 6, wrap");
        this.panel.add((Component)this.slider, "gap 6 6, growx");
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public void reset() {
        this.resetAdjusting = true;
        this.resetSliderRange();
        this.resetAdjusting = false;
        this.deactivate();
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append("[");
        buf.append("header=").append(this.rangeFormat.getHeaderText());
        buf.append(", active=").append(this.isActive());
        buf.append(", selectedRange=").append(this.createRangeText());
        buf.append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRange(SearchCategory filterCategory) {
        long upperValue;
        int oldLower = this.slider.getValue();
        int oldUpper = this.slider.getUpperValue();
        long[] oldValues = this.rangeFormat.getValues();
        long lowerValue = oldLower > 0 ? oldValues[oldLower] : -1L;
        long l = upperValue = oldUpper < oldValues.length - 1 ? oldValues[oldUpper] : -1L;
        if (this.rangeFormat.updateValues(filterCategory, lowerValue, upperValue)) {
            long[] newValues = this.rangeFormat.getValues();
            int newLower = 0;
            int newUpper = newValues.length - 1;
            if (lowerValue > -1L || upperValue > -1L) {
                for (int i = 0; i < newValues.length; ++i) {
                    if (newValues[i] == lowerValue) {
                        newLower = i;
                    }
                    if (newValues[i] != upperValue) continue;
                    newUpper = i;
                }
            }
            this.resetAdjusting = true;
            try {
                this.slider.setMaximum(newValues.length - 1);
                this.slider.setValue(newLower);
                this.slider.setUpperValue(newUpper);
                this.slider.repaint();
            }
            finally {
                this.resetAdjusting = false;
            }
        }
    }

    protected String createRangeText() {
        if (this.rangeFormat.isUpperLimitEnabled()) {
            String minText = this.rangeFormat.getValueText(this.slider.getValue());
            String maxText = this.rangeFormat.getValueText(this.slider.getUpperValue());
            if (this.slider.getUpperValue() == this.slider.getMaximum()) {
                if (this.rangeFormat.isMaximumAbsolute()) {
                    return minText;
                }
                return I18n.tr("{0} or above", minText);
            }
            return I18n.tr("{0} to {1}", minText, maxText);
        }
        String minText = this.rangeFormat.getValueText(this.slider.getValue());
        if (this.slider.getValue() == this.slider.getMinimum()) {
            return I18n.tr("all");
        }
        if (this.slider.getValue() == this.slider.getMaximum() && this.rangeFormat.isMaximumAbsolute()) {
            return minText;
        }
        return I18n.tr("{0} or above", minText);
    }

    private void resetSliderRange() {
        this.slider.setValue(this.slider.getMinimum());
        if (this.rangeFormat.isUpperLimitEnabled()) {
            this.slider.setUpperValue(this.slider.getMaximum());
        }
        this.valueLabel.setText(this.createRangeText());
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (RangeFilter.this.resetAdjusting) {
                return;
            }
            RangeSlider slider = (RangeSlider)e.getSource();
            String rangeText = RangeFilter.this.createRangeText();
            RangeFilter.this.valueLabel.setText(rangeText);
            if (!slider.getValueIsAdjusting()) {
                long[] values = RangeFilter.this.rangeFormat.getValues();
                boolean activate = false;
                if (RangeFilter.this.rangeFormat.isUpperLimitEnabled()) {
                    activate = slider.getValue() > 0 || slider.getUpperValue() < values.length - 1;
                } else {
                    boolean bl = activate = slider.getValue() > 0;
                }
                if (activate) {
                    long minValue = values[slider.getValue()];
                    long maxValue = values[slider.getUpperValue()];
                    Matcher newMatcher = RangeFilter.this.rangeFormat.getMatcher(minValue, maxValue);
                    RangeFilter.this.activate(rangeText, newMatcher);
                } else {
                    RangeFilter.this.deactivate();
                }
                RangeFilter.this.fireFilterChanged(RangeFilter.this);
            }
        }
    }
}

