/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.listener.EventListener;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.components.AutoCompleter;
import org.limewire.ui.swing.components.BasicAutoCompleter;
import org.limewire.ui.swing.components.Paintable;

public class DropDownListAutoCompleteControl {
    private static final String PROPERTY = "limewire.text.autocompleteControl";
    private final JTextField textField;
    private final AutoCompleter autoCompleter;
    protected JPopupMenu popup;
    protected boolean showPending;
    private boolean autoComplete = true;

    public static DropDownListAutoCompleteControl install(final JTextField textField) {
        final BasicAutoCompleter basicAutoCompleter = new BasicAutoCompleter();
        textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                basicAutoCompleter.addAutoCompleteSuggestion(textField.getText());
            }
        });
        return DropDownListAutoCompleteControl.install(textField, basicAutoCompleter);
    }

    public static DropDownListAutoCompleteControl install(JTextField textField, AutoCompleter autoCompleter) {
        DropDownListAutoCompleteControl control = new DropDownListAutoCompleteControl(textField, autoCompleter);
        textField.putClientProperty(PROPERTY, control);
        DropDownListAutoCompleteControl dropDownListAutoCompleteControl = control;
        dropDownListAutoCompleteControl.getClass();
        Listener listener = dropDownListAutoCompleteControl.new Listener();
        textField.addKeyListener(listener);
        textField.addHierarchyListener(listener);
        textField.addFocusListener(listener);
        textField.addActionListener(listener);
        autoCompleter.setAutoCompleterCallback(listener);
        return control;
    }

    public static DropDownListAutoCompleteControl getDropDownListAutoCompleteControl(JTextField textField) {
        return (DropDownListAutoCompleteControl)textField.getClientProperty(PROPERTY);
    }

    private DropDownListAutoCompleteControl(JTextField textField, AutoCompleter autoCompleter) {
        this.textField = textField;
        this.autoCompleter = autoCompleter;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
    }

    public boolean isAutoCompleting() {
        return this.autoComplete;
    }

    private void autoCompleteInput() {
        if (this.isAutoCompleting()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String input = DropDownListAutoCompleteControl.this.textField.getText();
                    if (input != null && input.length() > 0) {
                        ListeningFuture<Boolean> future = DropDownListAutoCompleteControl.this.autoCompleter.setInput(input);
                        if (!future.isDone()) {
                            DropDownListAutoCompleteControl.this.hidePopup();
                        }
                        future.addFutureListener(new EventListener<FutureEvent<Boolean>>(){

                            @Override
                            @SwingEDTEvent
                            public void handleEvent(FutureEvent<Boolean> event) {
                                if (event.getResult() == Boolean.TRUE) {
                                    DropDownListAutoCompleteControl.this.showPopup();
                                } else {
                                    DropDownListAutoCompleteControl.this.hidePopup();
                                }
                            }
                        });
                    } else {
                        DropDownListAutoCompleteControl.this.hidePopup();
                    }
                }
            });
        }
    }

    private JPopupMenu createPopup(Component component) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(BorderFactory.createEmptyBorder());
        popupMenu.setFocusable(false);
        popupMenu.add(component);
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                DropDownListAutoCompleteControl.this.resetPopup();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        return popupMenu;
    }

    private void showPopup() {
        if (this.autoCompleter.isAutoCompleteAvailable()) {
            if (this.textField.isShowing()) {
                JTextField parent = this.textField;
                JComponent component = this.autoCompleter.getRenderComponent();
                int leftInset = 0;
                int bottomInset = 0;
                int widthInset = 0;
                if (this.textField instanceof Paintable) {
                    Insets paintedInsets = ((Paintable)((Object)this.textField)).getPaintedInsets();
                    leftInset = paintedInsets.left;
                    bottomInset = paintedInsets.bottom;
                    widthInset = paintedInsets.left + paintedInsets.right;
                }
                Dimension priorPref = component.getPreferredSize();
                component.setPreferredSize(null);
                Dimension pref = component.getPreferredSize();
                pref = new Dimension(this.textField.getWidth() - widthInset, pref.height + 10);
                component.setPreferredSize(pref);
                if (this.popup != null && priorPref.equals(pref)) {
                    return;
                }
                if (this.popup != null) {
                    this.hidePopup();
                }
                this.popup = this.createPopup(component);
                this.showPending = false;
                this.popup.show(parent, leftInset, this.textField.getHeight() - bottomInset);
            } else {
                this.showPending = true;
            }
        }
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        this.resetPopup();
    }

    private void resetPopup() {
        this.showPending = false;
        this.popup = null;
    }

    private class Listener
    implements ActionListener,
    KeyListener,
    HierarchyListener,
    FocusListener,
    AutoCompleter.AutoCompleterCallback {
        private Listener() {
        }

        @Override
        public void itemSuggested(String autoCompleteString, boolean keepPopupVisible, boolean triggerAction) {
            DropDownListAutoCompleteControl.this.textField.setText(autoCompleteString);
            DropDownListAutoCompleteControl.this.textField.setCaretPosition(DropDownListAutoCompleteControl.this.textField.getDocument().getLength());
            if (triggerAction) {
                DropDownListAutoCompleteControl.this.textField.postActionEvent();
            } else if (!keepPopupVisible) {
                DropDownListAutoCompleteControl.this.hidePopup();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DropDownListAutoCompleteControl.this.popup != null) {
                String selection = DropDownListAutoCompleteControl.this.autoCompleter.getSelectedAutoCompleteString();
                DropDownListAutoCompleteControl.this.hidePopup();
                if (selection != null) {
                    DropDownListAutoCompleteControl.this.textField.setText(selection);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40) {
                evt.consume();
            }
            if (DropDownListAutoCompleteControl.this.autoCompleter != null) {
                switch (evt.getKeyCode()) {
                    case 38: {
                        if (DropDownListAutoCompleteControl.this.popup != null) {
                            DropDownListAutoCompleteControl.this.autoCompleter.decrementSelection();
                            break;
                        }
                        String input = DropDownListAutoCompleteControl.this.textField.getText();
                        DropDownListAutoCompleteControl.this.autoCompleter.setInput(input).addFutureListener(new EventListener<FutureEvent<Boolean>>(){

                            @Override
                            @SwingEDTEvent
                            public void handleEvent(FutureEvent<Boolean> event) {
                                if (event.getResult() == Boolean.TRUE) {
                                    DropDownListAutoCompleteControl.this.showPopup();
                                }
                            }
                        });
                        break;
                    }
                    case 40: {
                        if (DropDownListAutoCompleteControl.this.popup != null) {
                            DropDownListAutoCompleteControl.this.autoCompleter.incrementSelection();
                            break;
                        }
                        String input = DropDownListAutoCompleteControl.this.textField.getText();
                        DropDownListAutoCompleteControl.this.autoCompleter.setInput(input).addFutureListener(new EventListener<FutureEvent<Boolean>>(){

                            @Override
                            @SwingEDTEvent
                            public void handleEvent(FutureEvent<Boolean> event) {
                                if (event.getResult() == Boolean.TRUE) {
                                    DropDownListAutoCompleteControl.this.showPopup();
                                }
                            }
                        });
                        break;
                    }
                    case 37: 
                    case 39: {
                        String selection;
                        if (DropDownListAutoCompleteControl.this.popup == null || (selection = DropDownListAutoCompleteControl.this.autoCompleter.getSelectedAutoCompleteString()) == null) break;
                        DropDownListAutoCompleteControl.this.hidePopup();
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40) {
                evt.consume();
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40) {
                evt.consume();
            }
            if (DropDownListAutoCompleteControl.this.autoCompleter != null) {
                switch (evt.getKeyChar()) {
                    case '\u001b': {
                        if (DropDownListAutoCompleteControl.this.popup == null) break;
                        DropDownListAutoCompleteControl.this.hidePopup();
                        DropDownListAutoCompleteControl.this.textField.selectAll();
                        break;
                    }
                    case '\n': {
                        break;
                    }
                    default: {
                        DropDownListAutoCompleteControl.this.autoCompleteInput();
                    }
                }
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent evt) {
            if ((evt.getChangeFlags() & 4L) == 4L) {
                boolean showing = DropDownListAutoCompleteControl.this.textField.isShowing();
                if (!showing && DropDownListAutoCompleteControl.this.popup != null) {
                    DropDownListAutoCompleteControl.this.hidePopup();
                } else if (showing && DropDownListAutoCompleteControl.this.popup == null && DropDownListAutoCompleteControl.this.showPending) {
                    DropDownListAutoCompleteControl.this.autoCompleteInput();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getID() == 1005 && DropDownListAutoCompleteControl.this.popup != null) {
                DropDownListAutoCompleteControl.this.hidePopup();
            }
        }
    }
}

