/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.listener;

import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.listener.BlockingEvent;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.ExceptionUtils;
import org.limewire.util.Objects;

public class EventListenerList<E>
implements ListenerSupport<E>,
EventBroadcaster<E> {
    private final List<ListenerProxy<E>> listenerList = new CopyOnWriteArrayList<ListenerProxy<E>>();
    private final Log log;
    private final EventListenerListContext context;

    public EventListenerList() {
        this(null, new EventListenerListContext());
    }

    public EventListenerList(Class loggerKey) {
        this(LogFactory.getLog(loggerKey), new EventListenerListContext());
    }

    public EventListenerList(Log log) {
        this(log, new EventListenerListContext());
    }

    public EventListenerList(EventListenerListContext context) {
        this(null, context);
    }

    public EventListenerList(Log log, EventListenerListContext context) {
        this.log = log;
        this.context = context;
    }

    public static <E> void dispatch(EventListener<E> listener, E event, EventListenerListContext context) {
        ListenerProxy<E> proxy = new ListenerProxy<E>(null, Objects.nonNull(listener, "listener"), context);
        proxy.handleEvent(event);
    }

    public EventListenerListContext getContext() {
        return this.context;
    }

    @Override
    public void addListener(EventListener<E> listener) {
        if (this.log != null) {
            this.log.debugf("adding listener {0} to {1}", (Object)listener, (Object)this);
        }
        this.listenerList.add(new ListenerProxy<E>(this.log, Objects.nonNull(listener, "listener"), this.context));
    }

    @Override
    public boolean removeListener(EventListener<E> listener) {
        if (this.log != null) {
            this.log.debugf("removing listener {0} from {1}", (Object)listener, (Object)this);
        }
        Objects.nonNull(listener, "listener");
        for (ListenerProxy<E> proxyListener : this.listenerList) {
            if (!((ListenerProxy)proxyListener).delegate.equals(listener)) continue;
            return this.listenerList.remove(proxyListener);
        }
        return false;
    }

    public void dispatch(EventListener<E> listener, E event) {
        EventListenerList.dispatch(listener, event, this.context);
    }

    @Override
    public void broadcast(E event) {
        Objects.nonNull(event, "event");
        if (this.log != null) {
            this.log.debugf("broadcasting event {0} from {1}", (Object)event, (Object)this);
        }
        Throwable t = null;
        for (ListenerProxy<E> listener : this.listenerList) {
            try {
                listener.handleEvent(event);
            }
            catch (Throwable thrown) {
                if (this.log != null) {
                    this.log.error("error dispatching " + event, thrown);
                }
                if ((thrown = ExceptionUtils.reportOrReturn(thrown)) == null || t != null) continue;
                t = thrown;
            }
        }
        if (t != null) {
            ExceptionUtils.reportOrRethrow(t);
        }
    }

    public int size() {
        return this.listenerList.size();
    }

    public static final class EventListenerListContext {
        private final AtomicReference<ConcurrentMap<String, Executor>> eventExecutorsRef = new AtomicReference();

        private Executor getOrCreateExecutor(String queueName) {
            if (queueName != null && !queueName.equals("")) {
                Executor executor;
                ConcurrentMap<String, Executor> executorMap = this.eventExecutorsRef.get();
                if (executorMap == null) {
                    this.eventExecutorsRef.compareAndSet(null, new ConcurrentHashMap());
                    executorMap = this.eventExecutorsRef.get();
                }
                if ((executor = (Executor)executorMap.get(queueName)) == null) {
                    executorMap.putIfAbsent(queueName, ExecutorsHelper.newProcessingQueue("BlockingEventQueue-" + queueName));
                    executor = (Executor)executorMap.get(queueName);
                }
                return executor;
            }
            return null;
        }
    }

    private static class ExecutorDispatchStrategy
    extends DispatchStrategy {
        private final Executor executor;

        public ExecutorDispatchStrategy(Executor executor) {
            this.executor = executor;
        }

        @Override
        <E> void dispatch(final EventListener<E> listener, final E event) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    listener.handleEvent(event);
                }
            };
            this.executor.execute(runner);
        }
    }

    private static abstract class DispatchStrategy {
        public static DispatchStrategy UNKNOWN = new DispatchStrategy(){

            @Override
            <E> void dispatch(EventListener<E> listener, E event) {
                throw new IllegalStateException("unknown dispatch!");
            }
        };
        public static DispatchStrategy INLINE = new DispatchStrategy(){

            @Override
            <E> void dispatch(EventListener<E> listener, E event) {
                listener.handleEvent(event);
            }
        };
        public static DispatchStrategy SWING = new DispatchStrategy(){

            @Override
            <E> void dispatch(final EventListener<E> listener, final E event) {
                if (EventQueue.isDispatchThread()) {
                    listener.handleEvent(event);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            listener.handleEvent(event);
                        }
                    });
                }
            }
        };
        public static DispatchStrategy NEW_THREAD = new DispatchStrategy(){

            @Override
            <E> void dispatch(final EventListener<E> listener, final E event) {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        listener.handleEvent(event);
                    }
                };
                ThreadExecutor.startThread(runner, "BlockingEvent");
            }
        };

        private DispatchStrategy() {
        }

        abstract <E> void dispatch(EventListener<E> var1, E var2);

        public static DispatchStrategy getBlockingStrategy(EventListenerListContext context, BlockingEvent event) {
            if (context == null) {
                return NEW_THREAD;
            }
            Executor executor = context.getOrCreateExecutor(event.queueName());
            if (executor == null) {
                return NEW_THREAD;
            }
            return new ExecutorDispatchStrategy(executor);
        }
    }

    private static final class ListenerProxy<E>
    implements EventListener<E> {
        private final Log log;
        private final EventListener<E> delegate;
        private final EventListenerListContext context;
        private volatile DispatchStrategy strategy = DispatchStrategy.UNKNOWN;

        public ListenerProxy(Log log, EventListener<E> delegate, EventListenerListContext context) {
            this.log = log;
            this.delegate = delegate;
            this.context = context;
        }

        @Override
        public void handleEvent(E event) {
            if (this.strategy == DispatchStrategy.UNKNOWN) {
                this.strategy = this.analyze(this.delegate, event);
            }
            if (this.log != null) {
                this.log.tracef("Dispatching event {0} to {1} with strategy {2}", (Object)event, (Object)this.delegate, (Object)this.strategy);
            }
            this.strategy.dispatch(this.delegate, event);
        }

        private DispatchStrategy analyze(EventListener<E> delegate, E event) {
            Method method = null;
            for (Class<?> eventClass = event.getClass(); eventClass != null; eventClass = eventClass.getSuperclass()) {
                try {
                    method = delegate.getClass().getMethod("handleEvent", eventClass);
                    break;
                }
                catch (NoSuchMethodException ignored) {
                    continue;
                }
            }
            if (method == null) {
                throw new IllegalStateException("Unable to find method!");
            }
            if (method.getAnnotation(SwingEDTEvent.class) != null) {
                return DispatchStrategy.SWING;
            }
            BlockingEvent blockingEvent = method.getAnnotation(BlockingEvent.class);
            if (blockingEvent != null) {
                return DispatchStrategy.getBlockingStrategy(this.context, blockingEvent);
            }
            return DispatchStrategy.INLINE;
        }
    }
}

