/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.friend;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.HTTPAcceptor;
import com.limegroup.gnutella.uploader.HttpRequestHandlerFactory;
import org.limewire.core.impl.xmpp.FriendFileViewProvider;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;

@EagerSingleton
public class CoreGlueFriendService
implements Service {
    private final Provider<HTTPAcceptor> httpAcceptor;
    private final HttpRequestHandlerFactory httpRequestHandlerFactory;
    private final Provider<FriendFileViewProvider> authenticatingBrowseFriendListProvider;
    static final String FRIEND_BROWSE_PREFIX = "/friend/browse/";
    static final String FRIEND_DOWNLOAD_PREFIX = "/friend/download/";
    static final String FRIEND_BROWSE_PATTERN = "/friend/browse/*";
    static final String FRIEND_DOWNLOAD_PATTERN = "/friend/download/*";

    @Inject
    public CoreGlueFriendService(Provider<HTTPAcceptor> httpAcceptor, HttpRequestHandlerFactory httpRequestHandlerFactory, Provider<FriendFileViewProvider> authenticatingBrowseFriendListProvider) {
        this.httpAcceptor = httpAcceptor;
        this.httpRequestHandlerFactory = httpRequestHandlerFactory;
        this.authenticatingBrowseFriendListProvider = authenticatingBrowseFriendListProvider;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("XMPP Service");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        this.httpAcceptor.get().registerHandler(FRIEND_BROWSE_PATTERN, this.httpRequestHandlerFactory.createBrowseRequestHandler(this.authenticatingBrowseFriendListProvider.get(), true));
        this.httpAcceptor.get().registerHandler(FRIEND_DOWNLOAD_PATTERN, this.httpRequestHandlerFactory.createFileRequestHandler(this.authenticatingBrowseFriendListProvider.get(), true));
    }

    @Override
    public void stop() {
        this.httpAcceptor.get().unregisterHandler(FRIEND_BROWSE_PATTERN);
        this.httpAcceptor.get().unregisterHandler(FRIEND_DOWNLOAD_PATTERN);
    }
}

