/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.collection.CharSequenceKeyAnalyzer;
import org.limewire.collection.PatriciaTrie;
import org.limewire.collection.Trie;

public class StringTrieSet
implements AutoCompleteDictionary,
Iterable<String> {
    private final transient Trie<String, String> map;

    public StringTrieSet(boolean ignoreCase) {
        this.map = ignoreCase ? new CaseIgnoredTrie<String>() : new PatriciaTrie<CharSequence, String>(new CharSequenceKeyAnalyzer());
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public void addEntry(String data) {
        if (!this.contains(data)) {
            this.map.put(data, data);
        }
    }

    public boolean contains(String data) {
        return this.map.get(data) != null;
    }

    @Override
    public boolean removeEntry(String data) {
        return this.map.remove(data) != null;
    }

    @Override
    public Collection<String> getPrefixedBy(String data) {
        return this.map.getPrefixedBy(data).values();
    }

    @Override
    public String lookup(String data) {
        Iterator<String> it = this.map.getPrefixedBy(data).values().iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    @Override
    public Iterator<String> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public void clear() {
        ArrayList<String> l = new ArrayList<String>(this.map.size());
        for (String string : this) {
            l.add(string);
        }
        for (String string : l) {
            this.removeEntry(string);
        }
    }

    private static class CaseIgnoredTrie<V>
    extends PatriciaTrie<String, V> {
        public CaseIgnoredTrie() {
            super(new CharSequenceKeyAnalyzer());
        }

        private String canonicalize(String s) {
            return s.toUpperCase(Locale.US).toLowerCase(Locale.US);
        }

        @Override
        public boolean containsKey(Object k) {
            return super.containsKey(this.canonicalize((String)k));
        }

        @Override
        public V get(Object k) {
            return super.get(this.canonicalize((String)k));
        }

        @Override
        public SortedMap<String, V> getPrefixedBy(String key, int offset, int length) {
            return super.getPrefixedBy(this.canonicalize(key), offset, length);
        }

        @Override
        public SortedMap<String, V> getPrefixedBy(String key, int length) {
            return super.getPrefixedBy(this.canonicalize(key), length);
        }

        @Override
        public SortedMap<String, V> getPrefixedBy(String key) {
            return super.getPrefixedBy(this.canonicalize(key));
        }

        @Override
        public SortedMap<String, V> getPrefixedByBits(String key, int bitLength) {
            return super.getPrefixedByBits(this.canonicalize(key), bitLength);
        }

        @Override
        public SortedMap<String, V> headMap(String toKey) {
            return super.headMap(this.canonicalize(toKey));
        }

        @Override
        public V put(String key, V value) {
            return super.put(this.canonicalize(key), value);
        }

        @Override
        public V remove(Object k) {
            return super.remove(this.canonicalize((String)k));
        }

        @Override
        public Map.Entry<String, V> select(String key, Trie.Cursor<? super String, ? super V> cursor) {
            return super.select(this.canonicalize(key), cursor);
        }

        @Override
        public V select(String key) {
            return super.select(this.canonicalize(key));
        }

        @Override
        public SortedMap<String, V> subMap(String fromKey, String toKey) {
            return super.subMap(this.canonicalize(fromKey), this.canonicalize(toKey));
        }

        @Override
        public SortedMap<String, V> tailMap(String fromKey) {
            return super.tailMap(this.canonicalize(fromKey));
        }
    }
}

