/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.bittorrent;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.limewire.bittorrent.BTData;
import org.limewire.bittorrent.BTDataValueException;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.security.SHA1;
import org.limewire.service.ErrorService;
import org.limewire.util.BEncoder;
import org.limewire.util.CommonUtils;
import org.limewire.util.GenericsUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.URIUtils;

public class BTDataImpl
implements BTData {
    public static final String UTF_8_ENCODING = "UTF-8";
    private static final Log LOG = LogFactory.getLog(BTDataImpl.class);
    private final List<URI> trackerUris;
    private final URI[] webSeeds;
    private byte[] pieces;
    private final Long pieceLength;
    private byte[] infoHash;
    private final String name;
    private final Long length;
    private final List<BTData.BTFileData> files;
    private final Set<String> folders;
    private final boolean isPrivate;

    public BTDataImpl(Map<?, ?> torrentFileMap) throws BTDataValueException {
        this.trackerUris = BTDataImpl.parseTrackerUris(torrentFileMap);
        if (this.trackerUris.isEmpty()) {
            throw new BTDataValueException("announces missing or invalid!");
        }
        this.webSeeds = this.parseWebSeeds(torrentFileMap);
        Object tmp = torrentFileMap.get("info");
        if (tmp == null || !(tmp instanceof Map)) {
            throw new BTDataValueException("info missing or invalid!");
        }
        Map infoMap = (Map)tmp;
        this.infoHash = this.calculateInfoHash(infoMap);
        tmp = infoMap.get("private");
        this.isPrivate = tmp instanceof Long ? ((Long)tmp).intValue() == 1 : false;
        tmp = infoMap.get("pieces");
        if (!(tmp instanceof byte[])) {
            throw new BTDataValueException("info->piece missing!");
        }
        this.pieces = (byte[])tmp;
        tmp = infoMap.get("piece length");
        if (!(tmp instanceof Long)) {
            throw new BTDataValueException("info->'piece length' missing!");
        }
        this.pieceLength = (Long)tmp;
        tmp = infoMap.get("name.utf-8");
        this.name = this.getPreferredString(infoMap, "name");
        if (this.name == null || this.name.length() == 0) {
            throw new BTDataValueException("no valid name!");
        }
        if (infoMap.containsKey("length") == infoMap.containsKey("files")) {
            throw new BTDataValueException("info->length & info.files can't both exist or not exist!");
        }
        tmp = infoMap.get("length");
        if (tmp instanceof Long) {
            this.length = (Long)tmp;
            if (this.length < 0L) {
                throw new BTDataValueException("invalid length value");
            }
        } else {
            if (tmp != null) {
                throw new BTDataValueException("info->length is non-null, but not a Long!");
            }
            this.length = null;
        }
        if ((tmp = infoMap.get("files")) instanceof List) {
            List fileData = (List)tmp;
            if (fileData.isEmpty()) {
                throw new BTDataValueException("empty file list");
            }
            this.files = new ArrayList<BTData.BTFileData>(fileData.size());
            this.folders = new HashSet<String>();
            for (Object o : fileData) {
                if (!(o instanceof Map)) {
                    throw new BTDataValueException("info->files[x] not a Map!");
                }
                Map fileMap = (Map)o;
                tmp = fileMap.get("length");
                if (!(tmp instanceof Long)) {
                    throw new BTDataValueException("info->files[x].length not a Long!");
                }
                Long ln = (Long)tmp;
                if (ln < 0L) {
                    throw new BTDataValueException("invalid length");
                }
                boolean doASCII = true;
                try {
                    this.parseFiles(fileMap, ln, this.files, this.folders, true);
                    doASCII = false;
                }
                catch (BTDataValueException ignored) {
                    // empty catch block
                }
                if (!doASCII) continue;
                this.parseFiles(fileMap, ln, this.files, this.folders, false);
            }
        } else {
            if (tmp != null) {
                throw new BTDataValueException("info->files is non-null, but not a list!");
            }
            this.files = null;
            this.folders = null;
        }
    }

    static List<URI> parseTrackerUris(Map<?, ?> torrentFileMap) {
        ArrayList<URI> trackerUris = new ArrayList<URI>(2);
        Object value = torrentFileMap.get("announce-list");
        if (value instanceof List) {
            List<List> announceLists = GenericsUtils.scanForList(value, List.class, GenericsUtils.ScanMode.REMOVE);
            for (List uriList : announceLists) {
                List<byte[]> list = GenericsUtils.scanForList(uriList, byte[].class, GenericsUtils.ScanMode.REMOVE);
                for (byte[] data : list) {
                    String uriString = StringUtils.getASCIIString(data);
                    try {
                        trackerUris.add(URIUtils.toURI(uriString));
                    }
                    catch (URISyntaxException e) {
                        LOG.debugf(e, "invalid uri: {0}", uriString);
                    }
                }
            }
        }
        if (trackerUris.isEmpty() && (value = torrentFileMap.get("announce")) instanceof byte[]) {
            String uriString = StringUtils.getASCIIString((byte[])value);
            try {
                trackerUris.add(URIUtils.toURI(uriString));
            }
            catch (URISyntaxException e) {
                LOG.debugf(e, "invalid uri: {0}", uriString);
            }
        }
        return trackerUris.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(trackerUris);
    }

    private URI[] parseWebSeeds(Map<?, ?> torrentFileMap) {
        ArrayList<URI> webSeeds = new ArrayList<URI>();
        Object tmp = torrentFileMap.get("url-list");
        if (tmp != null) {
            if (tmp instanceof List) {
                List uris = (List)tmp;
                if (uris.size() > 0) {
                    for (byte[] uri : uris) {
                        this.addURI(webSeeds, StringUtils.getASCIIString(uri));
                    }
                }
            } else if (tmp instanceof byte[]) {
                String uri = StringUtils.getASCIIString((byte[])tmp);
                this.addURI(webSeeds, uri);
            }
        }
        return webSeeds.toArray(new URI[webSeeds.size()]);
    }

    private void addURI(List<URI> uris, String uriString) {
        try {
            URI uri = URIUtils.toURI(uriString);
            uris.add(uri);
        }
        catch (URISyntaxException e) {
            LOG.warn("Error parsing uri: " + uriString, e);
        }
    }

    private void parseFiles(Map<?, ?> fileMap, Long ln, List<BTData.BTFileData> fileData, Set<String> folderData, boolean utf8) throws BTDataValueException {
        Object tmp = fileMap.get("path" + (utf8 ? ".utf-8" : ""));
        if (!(tmp instanceof List)) {
            throw new BTDataValueException("info->files[x].path[.utf-8] not a List!");
        }
        HashSet<String> newFolders = new HashSet<String>();
        String path = this.parseFileList((List)tmp, newFolders, true);
        if (path == null) {
            throw new BTDataValueException("info->files[x].path[-utf-8] not valid!");
        }
        folderData.addAll(newFolders);
        fileData.add(new BTData.BTFileData(ln, path));
    }

    private String parseFileList(List<?> paths, Set<String> folders, boolean utf8) throws BTDataValueException {
        if (paths.isEmpty()) {
            throw new BTDataValueException("empty paths list");
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> i = paths.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof byte[])) {
                throw new BTDataValueException("info->files[x]->path[.utf-8][x] not a byte[]!");
            }
            String current = utf8 ? StringUtils.getUTF8String((byte[])o) : StringUtils.getASCIIString((byte[])o);
            if (current.length() == 0) {
                throw new BTDataValueException("empty path element");
            }
            sb.append("/");
            sb.append(CommonUtils.convertFileName(current));
            if (!i.hasNext()) continue;
            folders.add(sb.toString());
        }
        return sb.toString();
    }

    private String getPreferredString(Map<?, ?> info, String key) {
        String str = null;
        Object data = info.get(key + ".utf-8");
        if (data instanceof byte[]) {
            try {
                str = new String((byte[])data, UTF_8_ENCODING);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (str == null && (data = info.get(key)) instanceof byte[]) {
            str = StringUtils.getASCIIString((byte[])data);
        }
        return str;
    }

    private byte[] calculateInfoHash(Map<?, ?> infoMap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BEncoder.getEncoder(baos, true, false, UTF_8_ENCODING).encodeDict(infoMap);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
        }
        SHA1 md = new SHA1();
        return md.digest(baos.toByteArray());
    }

    @Override
    public List<URI> getTrackerUris() {
        return this.trackerUris;
    }

    @Override
    public List<BTData.BTFileData> getFiles() {
        return this.files;
    }

    @Override
    public Set<String> getFolders() {
        return this.folders;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public byte[] getInfoHash() {
        return this.infoHash;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getPieceLength() {
        return this.pieceLength;
    }

    @Override
    public byte[] getPieces() {
        return this.pieces;
    }

    @Override
    public void clearPieces() {
        this.pieces = null;
    }

    @Override
    public URI[] getWebSeeds() {
        return this.webSeeds;
    }
}

