/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ActionMap;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ProxyActions;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationActionMap
extends ActionMap {
    private final ApplicationContext context;
    private final ResourceMap resourceMap;
    private final Class actionsClass;
    private final Object actionsObject;
    private final List<ApplicationAction> proxyActions;

    public ApplicationActionMap(ApplicationContext context, Class actionsClass, Object actionsObject, ResourceMap resourceMap) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        if (actionsClass == null) {
            throw new IllegalArgumentException("null actionsClass");
        }
        if (actionsObject == null) {
            throw new IllegalArgumentException("null actionsObject");
        }
        if (!actionsClass.isInstance(actionsObject)) {
            throw new IllegalArgumentException("actionsObject not an instanceof actionsClass");
        }
        this.context = context;
        this.actionsClass = actionsClass;
        this.actionsObject = actionsObject;
        this.resourceMap = resourceMap;
        this.proxyActions = new ArrayList<ApplicationAction>();
        this.addAnnotationActions(resourceMap);
        this.maybeAddActionsPCL();
    }

    public final ApplicationContext getContext() {
        return this.context;
    }

    public final Class getActionsClass() {
        return this.actionsClass;
    }

    public final Object getActionsObject() {
        return this.actionsObject;
    }

    public List<ApplicationAction> getProxyActions() {
        ArrayList<ApplicationAction> allProxyActions = new ArrayList<ApplicationAction>(this.proxyActions);
        for (ActionMap parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ApplicationActionMap)) continue;
            allProxyActions.addAll(((ApplicationActionMap)parent).proxyActions);
        }
        return Collections.unmodifiableList(allProxyActions);
    }

    private String aString(String s, String emptyValue) {
        return s.length() == 0 ? emptyValue : s;
    }

    private void putAction(String key, ApplicationAction action) {
        if (this.get(key) != null) {
            // empty if block
        }
        this.put(key, action);
    }

    private void addAnnotationActions(ResourceMap resourceMap) {
        Class actionsClass = this.getActionsClass();
        for (Method m : actionsClass.getDeclaredMethods()) {
            Action action = m.getAnnotation(Action.class);
            if (action == null) continue;
            String methodName = m.getName();
            String enabledProperty = this.aString(action.enabledProperty(), null);
            String selectedProperty = this.aString(action.selectedProperty(), null);
            String actionName = this.aString(action.name(), methodName);
            Task.BlockingScope block = action.block();
            ApplicationAction appAction = new ApplicationAction(this, resourceMap, actionName, m, enabledProperty, selectedProperty, block);
            this.putAction(actionName, appAction);
        }
        ProxyActions proxyActionsAnnotation = actionsClass.getAnnotation(ProxyActions.class);
        if (proxyActionsAnnotation != null) {
            for (String actionName : proxyActionsAnnotation.value()) {
                ApplicationAction appAction = new ApplicationAction(this, resourceMap, actionName);
                appAction.setEnabled(false);
                this.putAction(actionName, appAction);
                this.proxyActions.add(appAction);
            }
        }
    }

    private void maybeAddActionsPCL() {
        boolean needsPCL = false;
        Object[] keys = this.keys();
        if (keys != null) {
            for (Object key : keys) {
                ApplicationAction actionAdapter;
                javax.swing.Action value = this.get(key);
                if (!(value instanceof ApplicationAction) || (actionAdapter = (ApplicationAction)value).getEnabledProperty() == null && actionAdapter.getSelectedProperty() == null) continue;
                needsPCL = true;
                break;
            }
            if (needsPCL) {
                try {
                    Class actionsClass = this.getActionsClass();
                    Method m = actionsClass.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                    m.invoke(this.getActionsObject(), new ActionsPCL());
                }
                catch (Exception e) {
                    String s = "addPropertyChangeListener undefined " + this.actionsClass;
                    throw new Error(s, e);
                }
            }
        }
    }

    private class ActionsPCL
    implements PropertyChangeListener {
        private ActionsPCL() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            Object[] keys = ApplicationActionMap.this.keys();
            if (keys != null) {
                for (Object key : keys) {
                    javax.swing.Action value = ApplicationActionMap.this.get(key);
                    if (!(value instanceof ApplicationAction)) continue;
                    ApplicationAction appAction = (ApplicationAction)value;
                    if (propertyName.equals(appAction.getEnabledProperty())) {
                        appAction.forwardPropertyChangeEvent(event, "enabled");
                        continue;
                    }
                    if (!propertyName.equals(appAction.getSelectedProperty())) continue;
                    appAction.forwardPropertyChangeEvent(event, "selected");
                }
            }
        }
    }
}

