/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class BufferToImage {
    public BufferToImage(VideoFormat format) {
        if (format.getSize() == null) {
            throw new NullPointerException();
        }
    }

    public Image createImage(Buffer buffer) {
        return this.createBufferedImage(buffer);
    }

    public BufferedImage createBufferedImage(Buffer buffer) {
        VideoFormat format = (VideoFormat)buffer.getFormat();
        int w = format.getSize().width;
        int h = format.getSize().height;
        Class dataType = format.getDataType();
        if (format instanceof RGBFormat) {
            boolean flipped;
            RGBFormat rgbFormat = (RGBFormat)format;
            int bitsPerPixel = rgbFormat.getBitsPerPixel();
            int redMask = rgbFormat.getRedMask();
            int greenMask = rgbFormat.getGreenMask();
            int blueMask = rgbFormat.getBlueMask();
            int lineStride = rgbFormat.getLineStride();
            int pixelStride = rgbFormat.getPixelStride();
            boolean bl = flipped = rgbFormat.getFlipped() == 1;
            if (dataType == Format.byteArray) {
                byte[] bytes = (byte[])buffer.getData();
                if (bitsPerPixel == 24) {
                    DataBufferByte db = new DataBufferByte(new byte[][]{bytes}, bytes.length);
                    ComponentSampleModel sm = new ComponentSampleModel(0, w, h, pixelStride, lineStride, new int[]{redMask - 1, greenMask - 1, blueMask - 1});
                    WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    ColorSpace cs = ColorSpace.getInstance(1000);
                    int[] nBits = new int[]{8, 8, 8};
                    ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, false, false, 1, 0);
                    BufferedImage bi = new BufferedImage(colorModel, r, false, null);
                    return bi;
                }
                if (bitsPerPixel == 32) {
                    DataBufferByte db = new DataBufferByte(new byte[][]{bytes}, bytes.length);
                    ComponentSampleModel sm = new ComponentSampleModel(0, w, h, pixelStride, lineStride, new int[]{redMask - 1, greenMask - 1, blueMask - 1, 3});
                    WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    ColorSpace cs = ColorSpace.getInstance(1000);
                    int[] nBits = new int[]{8, 8, 8, 8};
                    ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, true, false, 3, 0);
                    BufferedImage bi = new BufferedImage(colorModel, r, false, null);
                    return bi;
                }
                if (bitsPerPixel == 8) {
                    DataBufferByte db = new DataBufferByte(new byte[][]{bytes}, bytes.length);
                    SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(0, w, h, lineStride, new int[]{redMask, greenMask, blueMask});
                    WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    DirectColorModel colorModel = new DirectColorModel(bitsPerPixel, redMask, greenMask, blueMask);
                    BufferedImage bi = new BufferedImage(colorModel, r, false, null);
                    return bi;
                }
                BufferedImage bi = new BufferedImage(w, h, 1);
                int[] pixels = new int[w * h];
                int pixelIndex = 0;
                int lineOffset = 0;
                if (flipped) {
                    lineOffset = (h - 1) * lineStride;
                }
                for (int y = 0; y < h; ++y) {
                    int off = lineOffset;
                    for (int x = 0; x < w; ++x) {
                        byte r = bytes[off + redMask - 1];
                        byte g = bytes[off + greenMask - 1];
                        byte b = bytes[off + blueMask - 1];
                        int pixel = 0;
                        pixel += r & 0xFF;
                        pixel *= 256;
                        pixel += g & 0xFF;
                        pixel *= 256;
                        pixels[pixelIndex++] = pixel += b & 0xFF;
                        off += pixelStride;
                    }
                    if (flipped) {
                        lineOffset -= lineStride;
                        continue;
                    }
                    lineOffset += lineStride;
                }
                bi.setRGB(0, 0, w, h, pixels, 0, w);
                return bi;
            }
            if (dataType == Format.shortArray) {
                short[] shorts = (short[])buffer.getData();
                if (bitsPerPixel == 16) {
                    DataBufferUShort db = new DataBufferUShort(new short[][]{shorts}, shorts.length);
                    SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(1, w, h, lineStride, new int[]{redMask, greenMask, blueMask});
                    WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
                    DirectColorModel colorModel = new DirectColorModel(bitsPerPixel, redMask, greenMask, blueMask);
                    BufferedImage bi = new BufferedImage(colorModel, r, false, null);
                    return bi;
                }
                throw new UnsupportedOperationException();
            }
            if (dataType == Format.intArray) {
                int[] bytes = (int[])buffer.getData();
                DataBufferInt db = new DataBufferInt(new int[][]{bytes}, bytes.length);
                SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(3, w, h, new int[]{redMask, greenMask, blueMask});
                WritableRaster r = Raster.createWritableRaster(sm, db, new Point(0, 0));
                DirectColorModel colorModel = new DirectColorModel(24, redMask, greenMask, blueMask, 0);
                BufferedImage bi = new BufferedImage(colorModel, r, false, null);
                return bi;
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }
}

