/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceStream;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.NewSendStreamEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SendStreamEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.StreamMappedEvent;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.datasink.rtp.RTPBonusFormatsMgr;
import net.sf.fmj.media.rtp.RTCPHandler;
import net.sf.fmj.media.rtp.RTCPHeader;
import net.sf.fmj.media.rtp.RTCPReceiverReport;
import net.sf.fmj.media.rtp.RTCPReport;
import net.sf.fmj.media.rtp.RTCPSenderReport;
import net.sf.fmj.media.rtp.RTPDataSource;
import net.sf.fmj.media.rtp.RTPDataStream;
import net.sf.fmj.media.rtp.RTPGlobalReceptionStats;
import net.sf.fmj.media.rtp.RTPGlobalTransmissionStats;
import net.sf.fmj.media.rtp.RTPHandler;
import net.sf.fmj.media.rtp.RTPHeader;
import net.sf.fmj.media.rtp.RTPLocalParticipant;
import net.sf.fmj.media.rtp.RTPParticipant;
import net.sf.fmj.media.rtp.RTPReceiveStream;
import net.sf.fmj.media.rtp.RTPReceptionStats;
import net.sf.fmj.media.rtp.RTPRemoteParticipant;
import net.sf.fmj.media.rtp.RTPSendStream;
import net.sf.fmj.media.rtp.RTPSocketAdapter;
import net.sf.fmj.media.rtp.SSRCGenerator;
import net.sf.fmj.media.rtp.SocketOutputStream;
import net.sf.fmj.utility.FmjStartup;
import net.sf.fmj.utility.LoggerSingleton;

public class RTPSessionMgr
extends RTPManager
implements SessionManager {
    private static final Logger logger = LoggerSingleton.logger;
    private static final int MIN_RTCP_INTERVAL = 5000;
    private static final long REAPER_PERIOD = 4999L;
    private static final int LOWLAYERS = 28;
    private HashMap formatMap = new HashMap();
    private Vector receiveStreamListeners = new Vector();
    private Vector remoteListeners = new Vector();
    private Vector sendStreamListeners = new Vector();
    private Vector sessionListeners = new Vector();
    private RTPLocalParticipant localParticipant = null;
    private HashMap activeParticipants = new HashMap();
    private HashMap inactiveParticipants = new HashMap();
    private RTPGlobalReceptionStats globalReceptionStats = new RTPGlobalReceptionStats();
    private RTPGlobalTransmissionStats globalTransmissionStats = new RTPGlobalTransmissionStats();
    private HashMap receiveStreams = new HashMap();
    private HashMap sendStreams = new HashMap();
    private HashMap ignoredStreams = new HashMap();
    private HashMap unassignedStreams = new HashMap();
    private HashMap senders = new HashMap();
    private double rtcpReceiverBandwidthFraction = 0.0375;
    private double rtcpSenderBandwidthFraction = 0.0125;
    private SessionAddress localAddress = null;
    private final HashMap<SessionAddress, RTPConnector> targets = new HashMap();
    private RTPHandler rtpHandler = null;
    private RTCPHandler rtcpHandler = null;
    private Integer eventLock = new Integer(0);
    private boolean eventLocked = false;
    private boolean done = false;
    private Timer rtcpTimer = new Timer("RTCP Timer", true);
    private RTCPTimerTask RTCPSendTask = null;
    private Timer reaperTimer = new Timer("Reaper Timer", true);
    private long lastRTCPSendTime = -1L;
    private long nextRTCPSendTime = -1L;
    private int averageRTCPSize = 60;
    private long rtcpPacketsSent = 0L;
    private boolean sayonara = false;
    private int RRRoundRobin = 0;
    private boolean we_sent = false;
    private long pmembers = 1L;
    protected long ssrc = 0L;
    private SSRCGenerator generator;
    RTPConnector socket = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEventLock() {
        Integer n = this.eventLock;
        synchronized (n) {
            while (this.eventLocked) {
                try {
                    this.eventLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.eventLocked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseEventLock() {
        Integer n = this.eventLock;
        synchronized (n) {
            this.eventLocked = false;
            this.eventLock.notifyAll();
        }
    }

    public RTPSessionMgr() {
        String user = "username";
        if (!FmjStartup.isApplet) {
            user = System.getProperty("user.name");
        }
        String host = "localhost";
        if (!FmjStartup.isApplet) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.localParticipant = new RTPLocalParticipant(user + "@FMJ." + host);
        this.generator = new SSRCGenerator();
        this.addFormat(new AudioFormat("ULAW/rtp", 8000.0, 8, 1), 0);
        this.addFormat(new AudioFormat("gsm/rtp", 8000.0, -1, 1), 3);
        this.addFormat(new AudioFormat("g723/rtp", 8000.0, -1, 1), 4);
        this.addFormat(new AudioFormat("dvi/rtp", 8000.0, 4, 1), 5);
        this.addFormat(new AudioFormat("mpegaudio/rtp"), 14);
        this.addFormat(new AudioFormat("g728/rtp", 8000.0, -1, 1), 15);
        this.addFormat(new AudioFormat("dvi/rtp", 11025.0, 4, 1), 16);
        this.addFormat(new AudioFormat("dvi/rtp", 22050.0, 4, 1), 17);
        this.addFormat(new AudioFormat("g729/rtp", 8000.0, -1, 1), 18);
        this.addFormat(new VideoFormat("jpeg/rtp"), 26);
        this.addFormat(new VideoFormat("h261/rtp"), 31);
        this.addFormat(new VideoFormat("mpeg/rtp"), 32);
        this.addFormat(new VideoFormat("h263/rtp"), 34);
        this.addFormat(new VideoFormat("h263-1998/rtp"), 42);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean formatSupported(Format f) {
        RTPSessionMgr mgr = new RTPSessionMgr();
        try {
            RTPBonusFormatsMgr.addBonusFormats(mgr);
            for (Integer id : mgr.formatMap.keySet()) {
                Format testFormat = (Format)mgr.formatMap.get(id);
                if (!testFormat.matches(f)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            mgr.dispose();
        }
    }

    public Format getFormat(int payload) {
        return (Format)this.formatMap.get(new Integer(payload));
    }

    public void addFormat(Format format, int payload) {
        this.formatMap.put(new Integer(payload), format);
    }

    public void addReceiveStreamListener(ReceiveStreamListener listener) {
        this.receiveStreamListeners.add(listener);
    }

    public void addRemoteListener(RemoteListener listener) {
        this.remoteListeners.add(listener);
    }

    public void addSendStreamListener(SendStreamListener listener) {
        this.sendStreamListeners.add(listener);
    }

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public void removeReceiveStreamListener(ReceiveStreamListener listener) {
        this.receiveStreamListeners.remove(listener);
    }

    public void removeRemoteListener(RemoteListener listener) {
        this.remoteListeners.remove(listener);
    }

    public void removeSendStreamListener(SendStreamListener listener) {
        this.sendStreamListeners.remove(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public Vector getActiveParticipants() {
        Vector participants = new Vector(this.activeParticipants.values());
        if (this.localParticipant.isActive()) {
            participants.add(this.localParticipant);
        }
        return participants;
    }

    public Vector getAllParticipants() {
        Vector<Object> participants = new Vector<Object>();
        participants.addAll(this.activeParticipants.values());
        participants.addAll(this.inactiveParticipants.values());
        participants.add(this.localParticipant);
        return participants;
    }

    public LocalParticipant getLocalParticipant() {
        return this.localParticipant;
    }

    public Vector getPassiveParticipants() {
        Vector participants = new Vector(this.inactiveParticipants.values());
        if (!this.localParticipant.isActive()) {
            participants.add(this.localParticipant);
        }
        return participants;
    }

    public Vector getRemoteParticipants() {
        Vector participants = new Vector();
        participants.addAll(this.activeParticipants.values());
        participants.addAll(this.inactiveParticipants.values());
        return participants;
    }

    public GlobalReceptionStats getGlobalReceptionStats() {
        return this.globalReceptionStats;
    }

    public GlobalTransmissionStats getGlobalTransmissionStats() {
        return this.globalTransmissionStats;
    }

    public Vector getReceiveStreams() {
        return new Vector(this.receiveStreams.values());
    }

    public Vector getSendStreams() {
        return new Vector(this.sendStreams.values());
    }

    public void initialize(SessionAddress localAddress) throws IOException {
        String user = "username";
        if (!FmjStartup.isApplet) {
            user = System.getProperty("user.name");
        }
        this.initialize(new SessionAddress[]{localAddress}, new SourceDescription[]{new SourceDescription(1, user + "@" + InetAddress.getLocalHost().getHostName(), 1, false), new SourceDescription(2, user + "@" + InetAddress.getLocalHost().getHostName(), 3, false)}, 0.05, 0.25, null);
    }

    public void initialize(SessionAddress[] localAddresses, SourceDescription[] sourceDescription, double rtcpBandwidthFraction, double rtcpSenderBandwidthFraction, EncryptionInfo encryptionInfo) {
        this.rtcpSenderBandwidthFraction = rtcpSenderBandwidthFraction * rtcpBandwidthFraction;
        this.rtcpReceiverBandwidthFraction = rtcpBandwidthFraction - this.rtcpSenderBandwidthFraction;
        this.localParticipant.setSourceDescription(sourceDescription);
        this.localAddress = localAddresses[0];
        this.ssrc = this.generateSSRC();
        this.inactiveParticipants.put(this.localParticipant.getCNAME(), this.localParticipant);
        this.start();
    }

    public void addTarget(SessionAddress remoteAddress) throws IOException {
        if (this.socket == null) {
            this.socket = new RTPSocketAdapter(this.localAddress.getDataAddress(), this.localAddress.getDataPort(), this.localAddress.getTimeToLive());
            this.rtpHandler = new RTPHandler(this);
            this.rtcpHandler = new RTCPHandler(this);
            this.socket.getControlInputStream().setTransferHandler(this.rtcpHandler);
            this.socket.getDataInputStream().setTransferHandler(this.rtpHandler);
        }
        if (this.socket instanceof RTPSocketAdapter) {
            ((RTPSocketAdapter)this.socket).addTarget(remoteAddress);
        }
        this.targets.put(remoteAddress, this.socket);
    }

    public void initialize(RTPConnector connector) {
        try {
            this.ssrc = this.generateSSRC();
            this.socket = connector;
            this.rtpHandler = new RTPHandler(this);
            this.rtcpHandler = new RTCPHandler(this);
            connector.getControlInputStream().setTransferHandler(this.rtcpHandler);
            connector.getDataInputStream().setTransferHandler(this.rtpHandler);
            this.targets.put(null, connector);
            this.start();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    public void removeTarget(SessionAddress remoteAddress, String reason) {
        Vector sendStreams = this.localParticipant.getStreams();
        if (sendStreams != null) {
            RTPSendStream sendStream = null;
            if (sendStreams.size() > 0) {
                sendStream = (RTPSendStream)sendStreams.get(0);
            }
            this.sendBYE(sendStream, remoteAddress, reason);
        }
        if (this.socket instanceof RTPSocketAdapter) {
            ((RTPSocketAdapter)this.socket).removeTarget(remoteAddress);
        }
        this.targets.remove(remoteAddress);
    }

    public void removeTargets(String reason) {
        for (SessionAddress addr : this.targets.keySet()) {
            this.removeTarget(addr, reason);
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    private void sendBYE(RTPSendStream sendStream, SessionAddress remoteAddress, String reason) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bytes);
        try {
            boolean fSendBYE;
            boolean bl = fSendBYE = this.rtcpPacketsSent > 0L;
            if (null != sendStream && sendStream.getSourceTransmissionStats().getBytesTransmitted() > 0) {
                fSendBYE = true;
            }
            if (fSendBYE) {
                int packetType = 201;
                int packetSize = 1;
                if (this.we_sent) {
                    packetType = 200;
                    packetSize = 6;
                }
                output.writeByte(128);
                output.writeByte(packetType & 0xFF);
                output.writeShort(packetSize);
                if (this.we_sent) {
                    this.writeSenderInfo(output, sendStream);
                } else {
                    output.writeInt((int)(this.ssrc & 0xFFFFFFFFFFFFFFFFL));
                }
                this.writeSDESPacket(output);
                int byelen = 4;
                if (null != reason && reason.length() > 0) {
                    byte[] reasonBytes = reason.getBytes("UTF-8");
                    byelen += reasonBytes.length + 1;
                }
                int padding = 0;
                if (byelen % 4 != 0) {
                    padding = 4 - byelen % 4;
                    byelen += padding;
                }
                output.writeByte(129);
                output.writeByte(203);
                output.writeShort(byelen / 4);
                output.writeInt((int)(this.ssrc & 0xFFFFFFFFFFFFFFFFL));
                if (null != reason && reason.length() > 0) {
                    byte[] reasonBytes = reason.getBytes("UTF-8");
                    output.writeByte(reasonBytes.length & 0xFF);
                    output.write(reasonBytes);
                    for (int i = 0; i < padding; ++i) {
                        output.writeByte(0);
                    }
                }
                output.close();
                bytes.close();
                byte[] data = bytes.toByteArray();
                if (this.socket.getControlOutputStream() instanceof SocketOutputStream) {
                    SocketOutputStream out = (SocketOutputStream)this.socket.getControlOutputStream();
                    out.writeToRemote(data, 0, data.length, remoteAddress.getControlAddress(), remoteAddress.getControlPort());
                } else {
                    OutputDataStream outstream = this.socket.getControlOutputStream();
                    outstream.write(data, 0, data.length);
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "" + ex, ex);
        }
    }

    public SendStream createSendStream(DataSource dataSource, int streamIndex) throws UnsupportedFormatException, IOException {
        SourceStream stream;
        int format = -1;
        Format fmt = null;
        double clockRate = 90000.0;
        if (dataSource instanceof PushBufferDataSource) {
            stream = ((PushBufferDataSource)dataSource).getStreams()[streamIndex];
            fmt = stream.getFormat();
        } else if (dataSource instanceof PullBufferDataSource) {
            stream = ((PullBufferDataSource)dataSource).getStreams()[streamIndex];
            fmt = stream.getFormat();
        } else {
            throw new IOException("Cannot use stream sources");
        }
        for (Integer id : this.formatMap.keySet()) {
            Format testFormat = (Format)this.formatMap.get(id);
            if (!testFormat.matches(fmt)) continue;
            format = id;
        }
        if (format == -1) {
            throw new UnsupportedFormatException(fmt);
        }
        if (fmt instanceof AudioFormat) {
            clockRate = ((AudioFormat)fmt).getSampleRate();
        }
        OutputDataStream stream2 = this.socket.getDataOutputStream();
        RTPSendStream RTPStream2 = new RTPSendStream(this.ssrc, dataSource, stream2, streamIndex, this.localParticipant, format, clockRate, this);
        this.sendStreams.put(new Long(this.ssrc), RTPStream2);
        this.localParticipant.addStream(RTPStream2);
        this.getEventLock();
        NewSendStreamEvent ev = new NewSendStreamEvent(this, RTPStream2);
        new SendStreamNotifier(this.sendStreamListeners, ev);
        return RTPStream2;
    }

    public void dispose() {
        this.closeSession("Quitting");
        this.rtcpTimer.cancel();
        this.reaperTimer.cancel();
        this.done = true;
    }

    public Object getControl(String controlClass) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    protected void handleRTPPacket(byte[] data, int offset, int length) {
        block12: {
            if (this.sayonara) {
                return;
            }
            try {
                this.globalReceptionStats.addPacketRecd();
                this.globalReceptionStats.addBytesRecd(length);
                this.computeAverageRTPSize(length);
                RTPHeader header = new RTPHeader(data, offset, length);
                long ssrc = header.getSsrc();
                Object test = this.sendStreams.get(new Long(ssrc));
                if (test != null) {
                    logger.fine("Collision/Loop ??");
                    return;
                }
                Integer packetType = (Integer)this.ignoredStreams.get(new Long(ssrc));
                if (packetType != null && packetType.intValue() != header.getPacketType()) {
                    this.ignoredStreams.remove(new Long(ssrc));
                    packetType = null;
                }
                if (packetType != null) break block12;
                RTPReceiveStream stream = (RTPReceiveStream)this.receiveStreams.get(new Long(ssrc));
                if (stream == null) {
                    short type = header.getPacketType();
                    Format format = (Format)this.formatMap.get(new Integer(type));
                    if (format == null) {
                        this.globalReceptionStats.addUnknownType();
                        logger.warning("Unknown format identifier: " + type);
                        this.ignoredStreams.put(new Long(ssrc), new Integer(type));
                    } else {
                        if (format instanceof VideoFormat) {
                            format = this.findVideoSize(data, offset + header.getSize(), (VideoFormat)format);
                        }
                        RTPDataSource dataSource = new RTPDataSource(ssrc, format);
                        stream = new RTPReceiveStream(dataSource, ssrc);
                        this.receiveStreams.put(new Long(ssrc), stream);
                        this.unassignedStreams.put(new Long(ssrc), stream);
                        NewReceiveStreamEvent event = new NewReceiveStreamEvent(this, stream);
                        new ReceiveStreamNotifier(this.receiveStreamListeners, event);
                    }
                }
                if (stream == null) break block12;
                if (stream.checkResumeActivity()) {
                    try {
                        String cname = (String)this.senders.get(new Long(ssrc));
                        RTPRemoteParticipant pal = (RTPRemoteParticipant)this.activeParticipants.get(cname);
                        this.getEventLock();
                        new ReceiveStreamNotifier(this.receiveStreamListeners, new ActiveReceiveStreamEvent((SessionManager)this, pal, stream));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                RTPDataSource dataSource = (RTPDataSource)stream.getDataSource();
                dataSource.handleRTPPacket(header, data, offset + header.getSize(), length - header.getSize());
            }
            catch (IOException e) {
                this.globalReceptionStats.addBadRTPkt();
            }
        }
    }

    private VideoFormat findVideoSize(byte[] data, int offset, VideoFormat format) {
        if (format.getEncoding().equalsIgnoreCase("jpeg/rtp")) {
            int width = data[offset + 6] << 3;
            int height = data[offset + 7] << 3;
            return new VideoFormat("jpeg/rtp", new Dimension(width, height), -1, format.getDataType(), -1.0f);
        }
        return format;
    }

    protected void handleRTCPPacket(byte[] data, int offset, int length) {
        try {
            this.globalReceptionStats.addRTCPRecd();
            this.globalReceptionStats.addBytesRecd(length);
            RTCPHeader header = new RTCPHeader(data, offset, length);
            long ssrc = header.getSsrc();
            RTPReceiveStream stream = (RTPReceiveStream)this.receiveStreams.get(new Long(ssrc));
            RTCPReport report = null;
            RemoteEvent remoteEvent = null;
            if (header.getPacketType() == 200) {
                report = new RTCPSenderReport(data, offset, length);
                ((RTCPSenderReport)report).setStream(stream);
                remoteEvent = new SenderReportEvent(this, (RTCPSenderReport)report);
                this.globalReceptionStats.addSRRecd();
            }
            if (header.getPacketType() == 201) {
                report = new RTCPReceiverReport(data, offset, length);
                remoteEvent = new ReceiverReportEvent(this, (RTCPReceiverReport)report);
            }
            if (report != null) {
                String cname;
                if (this.sayonara) {
                    if (report.isByePacket()) {
                        this.inactiveParticipants.put(new Long(System.currentTimeMillis()), "BYE");
                        this.computeAverageRTPSize(length);
                    }
                    return;
                }
                if (!report.isByePacket()) {
                    this.computeAverageRTPSize(length);
                }
                if ((cname = report.getCName()) == null) {
                    cname = (String)this.senders.get(new Long(ssrc));
                }
                if (stream != null) {
                    stream.setReport(report);
                }
                if (cname != null) {
                    RTPEvent event;
                    this.unassignedStreams.remove(new Long(ssrc));
                    this.senders.put(new Long(ssrc), cname);
                    RTPRemoteParticipant participant = (RTPRemoteParticipant)this.activeParticipants.get(cname);
                    if (participant == null) {
                        participant = (RTPRemoteParticipant)this.inactiveParticipants.get(cname);
                    }
                    if (participant == null) {
                        participant = new RTPRemoteParticipant(cname);
                        this.getEventLock();
                        event = new NewParticipantEvent(this, participant);
                        new SessionNotifier(this.sessionListeners, (SessionEvent)event);
                        this.inactiveParticipants.put(cname, participant);
                    }
                    report.setParticipant(participant);
                    participant.addReport(report);
                    if (report.isByePacket()) {
                        new RemoveStreamTimer(this, participant, stream, cname, report);
                    } else if (stream != null) {
                        if (!this.activeParticipants.containsKey(cname)) {
                            this.inactiveParticipants.remove(cname);
                            this.activeParticipants.put(cname, participant);
                        }
                        if (stream.getParticipant() == null) {
                            participant.addStream(stream);
                            stream.setParticipant(participant);
                            this.getEventLock();
                            event = new StreamMappedEvent(this, stream, participant);
                            new ReceiveStreamNotifier(this.receiveStreamListeners, (ReceiveStreamEvent)event);
                        }
                    }
                }
            } else {
                throw new IOException("Unknown report type: " + header.getPacketType());
            }
            this.getEventLock();
            new RemoteNotifier(this.remoteListeners, remoteEvent);
        }
        catch (IOException e) {
            this.globalReceptionStats.addBadRTCPPkt();
        }
    }

    public int initSession(SessionAddress localAddress, long defaultSSRC, SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) {
        this.initialize(new SessionAddress[]{localAddress}, defaultUserDesc, rtcp_bw_fraction, rtcp_sender_bw_fraction, null);
        return 0;
    }

    public int initSession(SessionAddress localAddress, SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) {
        this.initialize(new SessionAddress[]{localAddress}, defaultUserDesc, rtcp_bw_fraction, rtcp_sender_bw_fraction, null);
        return 0;
    }

    public int startSession(SessionAddress destAddress, int mcastScope, EncryptionInfo encryptionInfo) throws IOException {
        this.addTarget(destAddress);
        return 0;
    }

    public int startSession(SessionAddress localReceiverAddress, SessionAddress localSenderAddress, SessionAddress remoteReceiverAddress, EncryptionInfo encryptionInfo) throws IOException {
        this.addTarget(remoteReceiverAddress);
        return 0;
    }

    public long getDefaultSSRC() {
        return this.ssrc;
    }

    public RTPStream getStream(long filterssrc) {
        return null;
    }

    public int getMulticastScope() {
        return 127;
    }

    public void setMulticastScope(int multicastScope) {
    }

    public void closeSession(String reason) {
        this.sayonara = true;
        if (this.rtcpReceiverBandwidthFraction == 0.0 && !this.we_sent) {
            return;
        }
        if (this.getAllParticipants().size() < 50) {
            this.removeTargets(reason);
            return;
        }
        long now = System.currentTimeMillis();
        this.RTCPSendTask.cancel();
        this.RTCPSendTask = null;
        this.reaperTimer.cancel();
        this.reaperTimer = null;
        this.we_sent = false;
        this.lastRTCPSendTime = -1L;
        this.activeParticipants.clear();
        this.inactiveParticipants.clear();
        this.inactiveParticipants.put(this.localParticipant.getCNAME(), this.localParticipant);
        this.pmembers = 0L;
        this.averageRTCPSize = 32 + this.localParticipant.getStreams().size() * 4;
        long delay = this.calculateRTCPDelay(false, false);
        this.lastRTCPSendTime = now;
        while ((now = System.currentTimeMillis()) < this.lastRTCPSendTime + delay) {
            this.nextRTCPSendTime = this.lastRTCPSendTime + delay;
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            long temp = this.lastRTCPSendTime;
            this.lastRTCPSendTime = -1L;
            delay = this.calculateRTCPDelay(false, false);
            this.lastRTCPSendTime = temp;
        }
        this.removeTargets(reason);
    }

    public String generateCNAME() {
        return this.localParticipant.getCNAME();
    }

    public long generateSSRC() {
        return this.generator.generate();
    }

    public SessionAddress getSessionAddress() {
        return null;
    }

    public SessionAddress getRemoteSessionAddress() {
        return null;
    }

    public SessionAddress getLocalSessionAddress() {
        return this.localAddress;
    }

    public SendStream createSendStream(int ssrc, DataSource ds, int streamindex) throws UnsupportedFormatException, IOException {
        return this.createSendStream(ds, streamindex);
    }

    public int startSession(int mcastScope, EncryptionInfo encryptionInfo) {
        return -1;
    }

    public void addPeer(SessionAddress peerAddress) throws IOException {
        this.addTarget(peerAddress);
    }

    public void removePeer(SessionAddress peerAddress) {
        this.removeTarget(peerAddress, "Leaving");
    }

    public void removeAllPeers() {
        this.removeTargets("Leaving");
    }

    public Vector getPeers() {
        return this.getAllParticipants();
    }

    public void start() {
        long delay = (long)(this.generator.random() * 1000.0) + 500L;
        this.rtcpTimer.schedule((TimerTask)new RTCPTimerTask(this), delay);
        this.globalReceptionStats.resetBytesRecd();
        this.reaperTimer.schedule((TimerTask)new CheckStreamsTimeout(this), new Date(), 4999L);
    }

    private long calculateRTCPDelay() {
        return this.calculateRTCPDelay(false, this.we_sent);
    }

    private long calculateRTCPDelay(boolean deterministic, boolean is_sender) {
        long delay = 5000L;
        long rtcp_min_time = 5000L;
        double bandwidth = (double)this.globalReceptionStats.getBytesRecd() / (double)(System.currentTimeMillis() - this.lastRTCPSendTime);
        int nbSenders = this.activeParticipants.size();
        int nbReceivers = this.inactiveParticipants.size();
        long nbMembers = nbSenders + nbReceivers;
        if (!deterministic && this.lastRTCPSendTime < 0L) {
            rtcp_min_time /= 2L;
        }
        if (!deterministic && this.globalReceptionStats.getBytesRecd() > 20 * this.averageRTCPSize && bandwidth > 1.0) {
            double bw = bandwidth * 8.0 * 1000.0 / 1024.0;
            rtcp_min_time = (long)(360.0 / bw * 1000.0);
        }
        if (bandwidth < 0.1) {
            delay = rtcp_min_time;
        } else {
            double senderFraction = 0.0;
            if (nbMembers > 0L) {
                senderFraction = (long)nbSenders / nbMembers;
            }
            double ratio = this.rtcpSenderBandwidthFraction / (this.rtcpSenderBandwidthFraction + this.rtcpReceiverBandwidthFraction);
            delay = nbSenders > 0 && senderFraction < ratio ? (is_sender ? (long)((double)(this.averageRTCPSize * nbSenders) / (bandwidth * this.rtcpSenderBandwidthFraction)) : (this.rtcpReceiverBandwidthFraction == 0.0 ? rtcp_min_time : (long)((double)(this.averageRTCPSize * nbReceivers) / (bandwidth * this.rtcpReceiverBandwidthFraction)))) : (long)((double)((long)this.averageRTCPSize * nbMembers) / (bandwidth * (this.rtcpSenderBandwidthFraction + this.rtcpReceiverBandwidthFraction)));
            if (delay < rtcp_min_time) {
                delay = rtcp_min_time;
            }
        }
        if (deterministic) {
            return delay;
        }
        delay = (long)((double)delay * (this.generator.random() + 0.5));
        delay = (long)((double)delay / 1.21828);
        this.pmembers = nbMembers;
        return delay;
    }

    private void writeSenderInfo(DataOutputStream output, RTPSendStream sendStream) throws IOException {
        long sendtime = System.currentTimeMillis();
        long sendTimeSeconds = (sendtime -= -2208988800000L) / 1000L;
        double fractionalPart = sendtime % 1000L;
        fractionalPart /= 1000.0;
        long sendTimeFractional = (long)(fractionalPart *= 4.294967296E9);
        double timestamp = (double)(sendStream.getLastSendTime() - sendStream.getInitialSendTime()) * (sendStream.getClockRate() / 1000.0);
        long rtpTimestamp = sendStream.getInitialTimestamp() + Math.round(timestamp);
        TransmissionStats stats = sendStream.getSourceTransmissionStats();
        output.writeInt((int)(sendStream.getSSRC() & 0xFFFFFFFFFFFFFFFFL));
        output.writeInt((int)(sendTimeSeconds & 0xFFFFFFFFFFFFFFFFL));
        output.writeInt((int)(sendTimeFractional & 0xFFFFFFFFFFFFFFFFL));
        output.writeInt((int)(rtpTimestamp & 0xFFFFFFFFFFFFFFFFL));
        output.writeInt(stats.getPDUTransmitted());
        output.writeInt(stats.getBytesTransmitted());
    }

    private void writeSDESPacket(DataOutputStream output) throws IOException {
        Vector sdesItems = this.localParticipant.getSourceDescription();
        if (sdesItems.size() > 0) {
            this.writeSDESPacketImpl(output, this.ssrc, sdesItems, this.rtcpPacketsSent % 3L != 0L);
        }
    }

    private void writeSDESPacketImpl(DataOutputStream output, long ssrc, Vector sdesItems, boolean onlyCNAME) throws IOException {
        int i;
        int sdesLength = 5;
        for (int i2 = 0; i2 < sdesItems.size(); ++i2) {
            SourceDescription sdesItem = (SourceDescription)sdesItems.elementAt(i2);
            if (onlyCNAME && sdesItem.getType() != 1) continue;
            sdesLength += sdesItem.getDescription().getBytes("UTF-8").length + 2;
        }
        int padding = 0;
        if (sdesLength % 4 != 0) {
            padding = 4 - sdesLength % 4;
            sdesLength += padding;
        }
        output.writeByte(129);
        output.writeByte(202);
        output.writeShort(sdesLength / 4);
        output.writeInt((int)(ssrc & 0xFFFFFFFFFFFFFFFFL));
        for (i = 0; i < sdesItems.size(); ++i) {
            SourceDescription sdesItem = (SourceDescription)sdesItems.elementAt(i);
            if (onlyCNAME && sdesItem.getType() != 1) continue;
            output.writeByte(sdesItem.getType() & 0xFF);
            byte[] desc = sdesItem.getDescription().getBytes("UTF-8");
            output.writeByte(desc.length & 0xFF);
            output.write(desc);
        }
        output.writeByte(0);
        for (i = 0; i < padding; ++i) {
            output.writeByte(0);
        }
    }

    public void sendRTCPPacket() {
        if (this.sayonara) {
            return;
        }
        long delay = this.calculateRTCPDelay();
        long now = System.currentTimeMillis();
        if (now < this.lastRTCPSendTime + delay | (this.rtcpReceiverBandwidthFraction == 0.0 && !this.we_sent)) {
            this.nextRTCPSendTime = this.lastRTCPSendTime + delay;
            this.RTCPSendTask = new RTCPTimerTask(this);
            this.rtcpTimer.schedule((TimerTask)this.RTCPSendTask, new Date(this.nextRTCPSendTime));
        } else {
            Vector streams = new Vector(this.receiveStreams.values());
            int rc = streams.size();
            if (rc > 31) {
                if (this.RRRoundRobin >= rc) {
                    this.RRRoundRobin = 0;
                }
                rc = rc - this.RRRoundRobin > 31 ? 31 : rc - this.RRRoundRobin;
            } else {
                this.RRRoundRobin = 0;
            }
            this.globalReceptionStats.resetBytesRecd();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(bytes);
            try {
                int packetType = 201;
                int packetSize = rc * 24 + 8;
                if (this.we_sent) {
                    packetType = 200;
                    packetSize += 20;
                }
                output.writeByte(0x80 | rc & 0x1F);
                output.writeByte(packetType & 0xFF);
                output.writeShort(packetSize / 4 - 1);
                if (this.we_sent) {
                    RTPSendStream sendStream = (RTPSendStream)this.localParticipant.getStreams().get(0);
                    this.writeSenderInfo(output, sendStream);
                } else {
                    output.writeInt((int)(this.ssrc & 0xFFFFFFFFFFFFFFFFL));
                }
                if (streams.size() > 0) {
                    now = System.currentTimeMillis();
                    for (int i = this.RRRoundRobin; i < this.RRRoundRobin + rc; ++i) {
                        RTPReceiveStream stream = (RTPReceiveStream)streams.get(i);
                        RTPReceptionStats stats = (RTPReceptionStats)stream.getSourceReceptionStats();
                        RTPDataSource dataSource = (RTPDataSource)stream.getDataSource();
                        RTPDataStream dataStream = (RTPDataStream)dataSource.getStreams()[0];
                        long lossFraction = 0L;
                        long extendedHighestSequenceNumber = dataStream.itsRTPBuffer.getExtendedHighestSequenceNumber();
                        int cumulativePacketLoss = dataStream.itsRTPBuffer.getCumulativePacketLoss();
                        long jitter = dataSource.getJitter();
                        long lsrMSW = stream.getLastSRReportTimestampMSW();
                        long lsrLSW = stream.getLastSRReportTimestampLSW();
                        long DLSR = 0L;
                        if (stream.getLastSRReportTime() > 0L) {
                            DLSR = (now - stream.getLastSRReportTime()) * 65536L / 1000L;
                        }
                        output.writeInt((int)(stream.getSSRC() & 0xFFFFFFFFFFFFFFFFL));
                        output.writeByte((int)(lossFraction & 0xFFL));
                        output.writeByte(cumulativePacketLoss >> 16 & 0xFF);
                        output.writeShort(cumulativePacketLoss & 0xFFFF);
                        output.writeInt((int)(extendedHighestSequenceNumber & 0xFFFFFFFFFFFFFFFFL));
                        output.writeInt((int)(jitter & 0xFFFFFFFFFFFFFFFFL));
                        output.writeShort((int)(lsrMSW & 0xFFFFL));
                        output.writeShort((int)(lsrLSW >> 16 & 0xFFFFL));
                        output.writeInt((int)(DLSR & 0xFFFFFFFFFFFFFFFFL));
                    }
                }
                this.writeSDESPacket(output);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            byte[] data = bytes.toByteArray();
            try {
                OutputDataStream outputStream = this.socket.getControlOutputStream();
                output.close();
                bytes.close();
                data = bytes.toByteArray();
                outputStream.write(data, 0, data.length);
                ++this.rtcpPacketsSent;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                this.dispose();
            }
            if (data != null) {
                this.computeAverageRTPSize(data.length);
            }
            if (!this.done) {
                delay = this.calculateRTCPDelay();
                this.lastRTCPSendTime = System.currentTimeMillis();
                this.nextRTCPSendTime = this.lastRTCPSendTime + delay;
                this.rtcpTimer.schedule((TimerTask)new RTCPTimerTask(this), new Date(this.nextRTCPSendTime));
                if (rc > 31) {
                    this.RRRoundRobin += 31;
                    if (this.RRRoundRobin > rc) {
                        this.RRRoundRobin = 0;
                    }
                }
            }
        }
    }

    public synchronized void RTPPacketSent(long time, int size) {
        if (this.sayonara) {
            return;
        }
        this.localParticipant.touch(time);
        this.we_sent = true;
        this.activeParticipants.put(this.localParticipant.getCNAME(), this.localParticipant);
        this.inactiveParticipants.remove(this.localParticipant.getCNAME());
        this.computeAverageRTPSize(size);
    }

    private synchronized void doReverseReconsideration() {
        if (this.RTCPSendTask != null && !this.sayonara) {
            this.RTCPSendTask.cancel();
            long now = System.currentTimeMillis();
            long nbMembers = this.inactiveParticipants.size() + this.activeParticipants.size();
            this.nextRTCPSendTime = now + nbMembers / this.pmembers * (this.nextRTCPSendTime - now);
            this.lastRTCPSendTime = now - nbMembers / this.pmembers * (now - this.lastRTCPSendTime);
            this.pmembers = nbMembers;
            this.RTCPSendTask = new RTCPTimerTask(this);
            this.rtcpTimer.schedule((TimerTask)this.RTCPSendTask, new Date(this.nextRTCPSendTime));
        }
    }

    public int getAverageRTCPSize() {
        return this.averageRTCPSize;
    }

    synchronized void computeAverageRTPSize(int length) {
        this.averageRTCPSize = (length + 28) * 0 + this.averageRTCPSize * 0;
    }

    private class CheckStreamsTimeout
    extends TimerTask {
        private final int TIMEOUT_MULT = 5;
        private final int SENDER_TIMEOUT_MULT = 2;
        RTPManager rtpmgr;

        public CheckStreamsTimeout(RTPManager rtpmgr) {
            this.rtpmgr = rtpmgr;
        }

        public void run() {
            long lastSR;
            RTPParticipant pal;
            boolean modified = false;
            logger.finer("Reaping...");
            long delay = RTPSessionMgr.this.calculateRTCPDelay(true, false);
            long timeLimit = System.currentTimeMillis() - 5L * delay;
            Set cnames = RTPSessionMgr.this.inactiveParticipants.keySet();
            for (String cname : cnames) {
                pal = (RTPParticipant)RTPSessionMgr.this.inactiveParticipants.get(cname);
                if (pal.equals(RTPSessionMgr.this.localParticipant) || (lastSR = pal.getLastReportTime()) >= timeLimit) continue;
                RTPSessionMgr.this.inactiveParticipants.remove(pal.getCNAME());
                modified = true;
            }
            delay = RTPSessionMgr.this.calculateRTCPDelay(true, true);
            timeLimit = System.currentTimeMillis() - 2L * delay;
            cnames = RTPSessionMgr.this.activeParticipants.keySet();
            for (String cname : cnames) {
                RTPStream stream;
                int i;
                Vector streamsV;
                pal = (RTPParticipant)RTPSessionMgr.this.activeParticipants.get(cname);
                lastSR = pal.getLastReportTime();
                if (lastSR < timeLimit) {
                    if (pal.equals(RTPSessionMgr.this.localParticipant)) {
                        RTPSessionMgr.this.we_sent = false;
                        RTPSessionMgr.this.inactiveParticipants.put(RTPSessionMgr.this.localParticipant.getCNAME(), RTPSessionMgr.this.localParticipant);
                    } else {
                        streamsV = pal.getStreams();
                        for (i = 0; i < streamsV.size(); ++i) {
                            stream = (RTPStream)streamsV.get(i);
                            RTPSessionMgr.this.receiveStreams.remove(new Long(stream.getSSRC()));
                            RTPSessionMgr.this.senders.remove(new Long(stream.getSSRC()));
                        }
                        modified = true;
                    }
                    RTPSessionMgr.this.activeParticipants.remove(pal.getCNAME());
                    continue;
                }
                if (pal.equals(RTPSessionMgr.this.localParticipant)) continue;
                streamsV = pal.getStreams();
                for (i = 0; i < streamsV.size(); ++i) {
                    PushBufferDataSource pbds;
                    PushBufferStream pbs;
                    stream = (RTPReceiveStream)streamsV.get(i);
                    if (!((RTPReceiveStream)stream).checkInactivity()) continue;
                    DataSource ds = ((RTPReceiveStream)stream).getDataSource();
                    if (ds instanceof PushBufferDataSource && (pbs = (pbds = (PushBufferDataSource)ds).getStreams()[0]) instanceof RTPDataStream) {
                        ((RTPDataStream)pbs).bitsPerSecond = 0;
                    }
                    RTPSessionMgr.this.getEventLock();
                    new ReceiveStreamNotifier(RTPSessionMgr.this.receiveStreamListeners, new InactiveReceiveStreamEvent((SessionManager)((Object)this.rtpmgr), pal, (ReceiveStream)stream, streamsV.size() == 1));
                }
            }
            Set unassigned = RTPSessionMgr.this.unassignedStreams.keySet();
            Iterator it = unassigned.iterator();
            while (it.hasNext()) {
                RTPReceiveStream stream = (RTPReceiveStream)RTPSessionMgr.this.unassignedStreams.get(it.next());
                if (!stream.checkInactivity()) continue;
                RTPSessionMgr.this.getEventLock();
                new ReceiveStreamNotifier(RTPSessionMgr.this.receiveStreamListeners, new InactiveReceiveStreamEvent((SessionManager)((Object)this.rtpmgr), new RTPParticipant("Unknown"), stream, true));
            }
            if (modified) {
                RTPSessionMgr.this.doReverseReconsideration();
            }
        }
    }

    class RTCPTimerTask
    extends TimerTask {
        private RTPSessionMgr rtpSessionManager = null;

        private RTCPTimerTask(RTPSessionMgr rtpSessionManager) {
            this.rtpSessionManager = rtpSessionManager;
        }

        public void run() {
            if (!RTPSessionMgr.this.sayonara) {
                this.rtpSessionManager.sendRTCPPacket();
                return;
            }
        }
    }

    private class RemoteNotifier
    extends Thread {
        private Vector listeners = null;
        private RemoteEvent event = null;

        private RemoteNotifier(Vector listeners, RemoteEvent event) {
            this.listeners = listeners;
            this.event = event;
            this.start();
        }

        public void run() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                RemoteListener listener = (RemoteListener)this.listeners.get(i);
                listener.update(this.event);
            }
            RTPSessionMgr.this.releaseEventLock();
        }
    }

    private class SessionNotifier
    extends Thread {
        private Vector listeners = null;
        private SessionEvent event = null;

        private SessionNotifier(Vector listeners, SessionEvent event) {
            this.listeners = listeners;
            this.event = event;
            this.start();
        }

        public void run() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                SessionListener listener = (SessionListener)this.listeners.get(i);
                listener.update(this.event);
            }
            RTPSessionMgr.this.releaseEventLock();
        }
    }

    private class ReceiveStreamNotifier
    extends Thread {
        private Vector listeners = null;
        private ReceiveStreamEvent event = null;

        private ReceiveStreamNotifier(Vector listeners, ReceiveStreamEvent event) {
            this.listeners = listeners;
            this.event = event;
            this.start();
        }

        public void run() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ReceiveStreamListener listener = (ReceiveStreamListener)this.listeners.get(i);
                listener.update(this.event);
            }
            RTPSessionMgr.this.releaseEventLock();
        }
    }

    private class SendStreamNotifier
    extends Thread {
        private Vector listeners = null;
        private SendStreamEvent event = null;

        private SendStreamNotifier(Vector listeners, SendStreamEvent event) {
            this.listeners = listeners;
            this.event = event;
            this.start();
        }

        public void run() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                SendStreamListener listener = (SendStreamListener)this.listeners.get(i);
                listener.update(this.event);
            }
            RTPSessionMgr.this.releaseEventLock();
        }
    }

    private class RemoveStreamTimer
    extends Thread {
        private final long DELAY_MULTIPLIER = 3L;
        RTPRemoteParticipant participant;
        RTPReceiveStream stream;
        String cname;
        RTCPReport report;
        RTPManager rtpmgr;

        public RemoveStreamTimer(RTPManager rtpmgr, RTPRemoteParticipant participant, RTPReceiveStream stream, String cname, RTCPReport report) {
            this.participant = participant;
            this.stream = stream;
            this.cname = cname;
            this.report = report;
            this.rtpmgr = rtpmgr;
            this.setName("RemoveStreamTimer for " + RTPSessionMgr.this);
            this.start();
        }

        public void run() {
            long delay = RTPSessionMgr.this.calculateRTCPDelay(true, true);
            try {
                Thread.sleep(3L * delay);
            }
            catch (InterruptedException ex) {
                return;
            }
            if (this.stream != null) {
                Long thisSSRC = new Long(this.stream.getSSRC());
                RTPSessionMgr.this.senders.remove(thisSSRC);
                this.participant.removeStream(this.stream);
                RTPSessionMgr.this.receiveStreams.remove(thisSSRC);
            }
            RTPSessionMgr.this.getEventLock();
            new ReceiveStreamNotifier(RTPSessionMgr.this.receiveStreamListeners, new ByeEvent((SessionManager)((Object)this.rtpmgr), this.participant, this.stream, this.report.getByeReason(), this.participant.getStreams().size() == 0));
            if (this.participant.getStreams().size() == 0) {
                RTPSessionMgr.this.activeParticipants.remove(this.cname);
                RTPSessionMgr.this.doReverseReconsideration();
            }
        }
    }
}

