/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.apps.mediaserver;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.SynchronizedBoolean;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.IncompatibleSourceException;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.AbstractDataSink;
import net.sf.fmj.utility.LoggerSingleton;

public class StreamDataSink
extends AbstractDataSink {
    private static final Logger logger = LoggerSingleton.logger;
    private PushDataSource source;
    private WriterThread writerThread;
    private final OutputStream os;

    public StreamDataSink(OutputStream os) {
        this.os = os;
    }

    public Object getControl(String controlType) {
        logger.warning("TODO: getControl " + controlType);
        return null;
    }

    public Object[] getControls() {
        logger.warning("TODO: getControls");
        return new Object[0];
    }

    public void close() {
        try {
            this.stop();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    public void open() throws IOException, SecurityException {
        PushSourceStream[] streams = this.source.getStreams();
        this.source.connect();
        this.writerThread = new WriterThread(this.source.getStreams()[0], this.os);
        this.writerThread.setName("WriterThread for " + this.os);
        this.writerThread.setDaemon(true);
    }

    public void start() throws IOException {
        this.source.start();
        this.writerThread.start();
    }

    public void stop() throws IOException {
        if (this.writerThread != null) {
            this.writerThread.close();
            try {
                this.writerThread.waitUntilClosed();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            finally {
                this.writerThread = null;
            }
        }
        if (this.source != null) {
            this.source.stop();
        }
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        logger.finer("setSource: " + source);
        if (!(source instanceof PushDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PushDataSource)source;
    }

    private class WriterThread
    extends CloseableThread
    implements SourceTransferHandler {
        private final PushSourceStream sourceStream;
        private final OutputStream os;
        private SynchronizedBoolean dataAvailable = new SynchronizedBoolean();
        private static final boolean USE_TRANSFER_HANDLER = true;
        private static final int DEFAULT_BUFFER_SIZE = 10000;

        public boolean isRandomAccess() {
            return false;
        }

        public WriterThread(PushSourceStream sourceStream, OutputStream os) {
            this.sourceStream = sourceStream;
            this.os = os;
            sourceStream.setTransferHandler(this);
        }

        public void transferData(PushSourceStream stream) {
            this.dataAvailable.setValue(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                logger.fine("getMinimumTransferSize: " + this.sourceStream.getMinimumTransferSize());
                byte[] buffer = new byte[this.sourceStream.getMinimumTransferSize() > 10000 ? this.sourceStream.getMinimumTransferSize() : 10000];
                boolean eos = false;
                block10: while (!this.isClosing() && !eos) {
                    int read;
                    SynchronizedBoolean synchronizedBoolean = this.dataAvailable;
                    synchronized (synchronizedBoolean) {
                        this.dataAvailable.waitUntil(true);
                        this.dataAvailable.setValue(false);
                    }
                    while ((read = this.sourceStream.read(buffer, 0, buffer.length)) != 0) {
                        if (read < 0) {
                            eos = true;
                            this.os.close();
                            logger.fine("EOS");
                            StreamDataSink.this.notifyDataSinkListeners(new EndOfStreamEvent(StreamDataSink.this, "EOS"));
                            continue block10;
                        }
                        this.os.write(buffer, 0, read);
                    }
                }
                if (!eos) {
                    logger.warning("Closed before EOS");
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                StreamDataSink.this.notifyDataSinkListeners(new DataSinkErrorEvent(StreamDataSink.this, e.getMessage()));
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            finally {
                this.setClosed();
            }
        }
    }
}

