/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponderFactory;
import com.limegroup.gnutella.handshaking.HandshakeServices;
import com.limegroup.gnutella.handshaking.HeadersFactory;
import com.limegroup.gnutella.handshaking.LeafHandshakeResponder;
import com.limegroup.gnutella.handshaking.UltrapeerHandshakeResponder;

@Singleton
public class HandshakeResponderFactoryImpl
implements HandshakeResponderFactory {
    private final HeadersFactory headersFactory;
    private final HandshakeServices handshakeServices;

    @Inject
    public HandshakeResponderFactoryImpl(HeadersFactory headersFactory, HandshakeServices handshakeServices) {
        this.headersFactory = headersFactory;
        this.handshakeServices = handshakeServices;
    }

    @Override
    public HandshakeResponder createUltrapeerHandshakeResponder(String host) {
        return new UltrapeerHandshakeResponder(host, this.headersFactory, this.handshakeServices);
    }

    @Override
    public HandshakeResponder createLeafHandshakeResponder(String host) {
        return new LeafHandshakeResponder(host, this.headersFactory, this.handshakeServices);
    }
}

