/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.ConnectionCapabilities;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;

public class ConnectionCapabilitiesImpl
implements ConnectionCapabilities {
    private volatile CapabilitiesVM capabilitiesVendorMessage;
    private volatile HandshakeResponse headersRead = HandshakeResponse.createEmptyResponse();
    private volatile HandshakeResponse headersWritten = HandshakeResponse.createEmptyResponse();
    private volatile MessagesSupportedVendorMessage messagesSupportedVendorMessage;

    @Override
    public String getUserAgent() {
        return this.headersRead.getUserAgent();
    }

    @Override
    public boolean isLimeWire() {
        return this.headersRead.isLimeWire();
    }

    @Override
    public boolean isOldLimeWire() {
        return this.headersRead.isOldLimeWire();
    }

    @Override
    public boolean isGoodUltrapeer() {
        return this.headersRead.isGoodUltrapeer();
    }

    @Override
    public boolean isGoodLeaf() {
        return this.headersRead.isGoodLeaf();
    }

    @Override
    public boolean supportsPongCaching() {
        return this.headersRead.supportsPongCaching();
    }

    @Override
    public int getNumIntraUltrapeerConnections() {
        return this.headersRead.getNumIntraUltrapeerConnections();
    }

    @Override
    public boolean isHighDegreeConnection() {
        return this.headersRead.isHighDegreeConnection();
    }

    @Override
    public boolean isUltrapeerQueryRoutingConnection() {
        return this.headersRead.isUltrapeerQueryRoutingConnection();
    }

    @Override
    public boolean supportsProbeQueries() {
        return this.headersRead.supportsProbeQueries();
    }

    @Override
    public boolean receivedHeaders() {
        return this.headersRead != HandshakeResponse.createEmptyResponse();
    }

    @Override
    public HandshakeResponse getHeadersRead() {
        return this.headersRead;
    }

    @Override
    public String getVersion() {
        return this.headersRead.getVersion();
    }

    @Override
    public boolean isLeafConnection() {
        return this.headersRead.isLeaf();
    }

    @Override
    public boolean isSupernodeConnection() {
        return this.headersRead.isUltrapeer();
    }

    @Override
    public boolean isClientSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String value = this.headersWritten.props().getProperty("X-Ultrapeer");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value) == false;
    }

    @Override
    public boolean isSupernodeSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String value = this.headersWritten.props().getProperty("X-Ultrapeer");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public boolean isGUESSUltrapeer() {
        return this.headersRead.isGUESSUltrapeer();
    }

    @Override
    public boolean isSupernodeClientConnection() {
        if (!this.isLeafConnection()) {
            return false;
        }
        String value = this.headersWritten.props().getProperty("X-Ultrapeer");
        if (value == null) {
            return false;
        }
        if (!Boolean.valueOf(value).booleanValue()) {
            return false;
        }
        return this.isQueryRoutingEnabled();
    }

    @Deprecated
    public boolean supportsGGEP() {
        return this.headersRead.supportsGGEP();
    }

    @Override
    public boolean isQueryRoutingEnabled() {
        return this.headersRead.isQueryRoutingEnabled();
    }

    @Override
    public int supportsVendorMessage(byte[] vendorID, int selector) {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsMessage(vendorID, selector);
        }
        return -1;
    }

    @Override
    public boolean supportsVMRouting() {
        if (this.headersRead != null) {
            return (double)this.headersRead.supportsVendorMessages() >= 0.2;
        }
        return false;
    }

    @Override
    public int remoteHostSupportsUDPConnectBack() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsUDPConnectBack();
        }
        return -1;
    }

    @Override
    public int remoteHostSupportsTCPConnectBack() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsTCPConnectBack();
        }
        return -1;
    }

    @Override
    public int remoteHostSupportsUDPRedirect() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsUDPConnectBackRedirect();
        }
        return -1;
    }

    @Override
    public int remoteHostSupportsTCPRedirect() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsTCPConnectBackRedirect();
        }
        return -1;
    }

    @Override
    public int remoteHostSupportsUDPCrawling() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsUDPCrawling();
        }
        return -1;
    }

    @Override
    public int remoteHostSupportsHopsFlow() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsHopsFlow();
        }
        return -1;
    }

    @Override
    public int remoteHostSupportsPushProxy() {
        if (this.messagesSupportedVendorMessage != null && this.isClientSupernodeConnection()) {
            return this.messagesSupportedVendorMessage.supportsPushProxy();
        }
        return -1;
    }

    @Override
    public int remoteHostSupportsLeafGuidance() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsLeafGuidance();
        }
        return -1;
    }

    @Override
    public int remoteHostSupportsHeaderUpdate() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsHeaderUpdate();
        }
        return -1;
    }

    @Override
    public int getSupportedOOBProxyControlVersion() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsOOBProxyingControl();
        }
        return -1;
    }

    @Override
    public int remoteHostSupportsInspections() {
        if (this.messagesSupportedVendorMessage != null) {
            return this.messagesSupportedVendorMessage.supportsInspectionRequests();
        }
        return -1;
    }

    @Override
    public boolean getRemoteHostSupportsFeatureQueries() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.supportsFeatureQueries() > 0;
        }
        return false;
    }

    @Override
    public int getRemoteHostFeatureQuerySelector() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.supportsFeatureQueries();
        }
        return -1;
    }

    @Override
    public boolean remoteHostSupportsWhatIsNew() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.supportsWhatIsNew();
        }
        return false;
    }

    @Override
    public int getRemoteHostUpdateVersion() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.supportsUpdate();
        }
        return -1;
    }

    @Override
    public int remostHostIsActiveDHTNode() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.isActiveDHTNode();
        }
        return -1;
    }

    @Override
    public int remostHostIsPassiveDHTNode() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.isPassiveDHTNode();
        }
        return -1;
    }

    @Override
    public int remoteHostIsPassiveLeafNode() {
        if (this.capabilitiesVendorMessage != null) {
            return this.capabilitiesVendorMessage.isPassiveLeafNode();
        }
        return -1;
    }

    @Override
    public int getCapability(ConnectionCapabilities.Capability capability) {
        if (this.capabilitiesVendorMessage != null) {
            switch (capability) {
                case TLS: {
                    return this.capabilitiesVendorMessage.supportsTLS();
                }
            }
            throw new IllegalArgumentException("unknown capability!");
        }
        return -1;
    }

    @Override
    public HandshakeResponse getHeadersWritten() {
        return this.headersWritten;
    }

    @Override
    public boolean isCapabilitiesVmSet() {
        return this.capabilitiesVendorMessage != null;
    }

    @Override
    public void setCapabilitiesVendorMessage(CapabilitiesVM vm) {
        this.capabilitiesVendorMessage = vm;
    }

    @Override
    public void setHeadersRead(HandshakeResponse createResponse) {
        this.headersRead = createResponse;
    }

    @Override
    public void setHeadersWritten(HandshakeResponse writtenHeaders) {
        this.headersWritten = writtenHeaders;
    }

    @Override
    public void setMessagesSupportedVendorMessage(MessagesSupportedVendorMessage vm) {
        this.messagesSupportedVendorMessage = vm;
    }

    @Override
    public boolean canAcceptIncomingTCP() {
        if (this.capabilitiesVendorMessage == null) {
            return true;
        }
        return this.capabilitiesVendorMessage.canAcceptIncomingTCP();
    }

    @Override
    public boolean canDoFWT() {
        if (this.capabilitiesVendorMessage == null) {
            return true;
        }
        return this.capabilitiesVendorMessage.canDoFWT();
    }
}

