/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.BypassedResultsCache;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.GuidMapManager;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageHandlerBinder;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouteTable;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.connection.Connection;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.filters.URNFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.library.FileViewManager;
import com.limegroup.gnutella.messagehandlers.DualMessageHandler;
import com.limegroup.gnutella.messagehandlers.InspectionRequestHandler;
import com.limegroup.gnutella.messagehandlers.LimeACKHandler;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messagehandlers.OOBHandler;
import com.limegroup.gnutella.messagehandlers.UDPCrawlerPingHandler;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.OutgoingQueryReplyFactory;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingReplyFactory;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import com.limegroup.gnutella.messages.vendor.DHTContactsMessage;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.messages.vendor.HeadPongFactory;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.InspectionRequest;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.UpdateResponse;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QRPUpdater;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import com.limegroup.gnutella.search.QueryHandlerFactory;
import com.limegroup.gnutella.search.ResultCounter;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.UpdateHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Buffer;
import org.limewire.collection.FixedsizeHashMap;
import org.limewire.collection.NoMoreStorageException;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ManagedThread;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.core.settings.FilterSettings;
import org.limewire.core.settings.MessageSettings;
import org.limewire.core.settings.SearchSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.GUID;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.lifecycle.ServiceStage;
import org.limewire.net.SocketsManager;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;
import org.limewire.service.ErrorService;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.util.Base32;
import org.limewire.util.ByteUtils;
import org.limewire.util.Objects;
import org.limewire.util.StringUtils;

public abstract class MessageRouterImpl
implements MessageRouter {
    private static final Log LOG = LogFactory.getLog(MessageRouterImpl.class);
    private static final int OLD_CONNECTIONS_TO_USE = 15;
    protected byte[] _clientGUID;
    private int MAX_ROUTE_TABLE_SIZE = 50000;
    @InspectionPoint(value="ping routing table dump")
    private RouteTable _pingRouteTable = new RouteTable(120, this.MAX_ROUTE_TABLE_SIZE);
    @InspectionPoint(value="query routing table dump")
    private RouteTable _queryRouteTable = new RouteTable(300, this.MAX_ROUTE_TABLE_SIZE);
    @InspectionPoint(value="push routing table dump")
    private RouteTable _pushRouteTable = new RouteTable(420, this.MAX_ROUTE_TABLE_SIZE);
    @InspectionPoint(value="headpong routing table dump")
    private RouteTable _headPongRouteTable = new RouteTable(10, this.MAX_ROUTE_TABLE_SIZE);
    private static final long OOB_SESSION_EXPIRE_TIME = 120000L;
    private static final long HOPS_FLOW_INTERVAL = 15000L;
    private final BypassedResultsCache _bypassedResultsCache;
    private static final FixedsizeHashMap<String, String> _udpConnectBacks = new FixedsizeHashMap(200);
    private static final int MAX_UDP_CONNECTBACK_FORWARDS = 5;
    private static final FixedsizeHashMap<String, String> _tcpConnectBacks = new FixedsizeHashMap(200);
    private static final int MAX_TCP_CONNECTBACK_FORWARDS = 5;
    private static final ExecutorService TCP_CONNECT_BACKER = ExecutorsHelper.newProcessingQueue("TCPConnectBack");
    private final QRPPropagator QRP_PROPAGATOR = new QRPPropagator();
    private QueryRouteTable _lastQueryRouteTable;
    private static final int HIGH_HOPS_RESPONSE_LIMIT = 10;
    private volatile Map<byte[], List<MessageListener>> _messageListeners = Collections.emptyMap();
    private final Object MESSAGE_LISTENER_LOCK = new Object();
    private long _lastQueryKeyTime;
    private ConcurrentMap<Class<? extends Message>, MessageHandler> messageHandlers = new ConcurrentHashMap<Class<? extends Message>, MessageHandler>(30, 0.75f, 3);
    private ConcurrentMap<Class<? extends Message>, MessageHandler> udpMessageHandlers = new ConcurrentHashMap<Class<? extends Message>, MessageHandler>(15, 0.75f, 3);
    private ConcurrentMap<Class<? extends Message>, MessageHandler> multicastMessageHandlers = new ConcurrentHashMap<Class<? extends Message>, MessageHandler>(5, 0.75f, 3);
    private static final long MULTICAST_GUID_EXPIRE_TIME = 60000L;
    private static final int UDP_REPLY_CACHE_TIME = 60000;
    @InspectionPoint(value="guid tracker")
    private final GUIDTracker guidTracker = new GUIDTracker();
    @InspectionPoint(value="dropped replies")
    private final DroppedReplyCounter droppedReplyCounter = new DroppedReplyCounter();
    @InspectionPoint(value="duplicate queries")
    private final DuplicateQueryCounter duplicateQueryCounter = new DuplicateQueryCounter();
    @InspectionPoint(value="last hop counter for ultrapeers")
    private final LastHopCounter lastHopCounter = new LastHopCounter();
    @InspectablePrimitive(value="leaf connection qrp hits")
    private final InspectionHistogram<Integer> leafQRPHits = new InspectionHistogram();
    protected final NetworkManager networkManager;
    protected final QueryRequestFactory queryRequestFactory;
    protected final QueryHandlerFactory queryHandlerFactory;
    protected final OnDemandUnicaster onDemandUnicaster;
    protected final HeadPongFactory headPongFactory;
    protected final PingReplyFactory pingReplyFactory;
    protected final ConnectionManager connectionManager;
    protected final ReplyHandler forMeReplyHandler;
    protected final QueryUnicaster queryUnicaster;
    protected final FileViewManager fileManager;
    protected final ContentManager contentManager;
    protected final DHTManager dhtManager;
    protected final UploadManager uploadManager;
    protected final DownloadManager downloadManager;
    protected final UDPService udpService;
    protected final Provider<SearchResultHandler> searchResultHandler;
    protected final SocketsManager socketsManager;
    protected final HostCatcher hostCatcher;
    protected final QueryReplyFactory queryReplyFactory;
    protected final StaticMessages staticMessages;
    protected final Provider<MessageDispatcher> messageDispatcher;
    protected final MulticastService multicastService;
    protected final QueryDispatcher queryDispatcher;
    protected final Provider<ActivityCallback> activityCallback;
    protected final ConnectionServices connectionServices;
    protected final ScheduledExecutorService backgroundExecutor;
    protected final Provider<PongCacher> pongCacher;
    protected final Provider<SimppManager> simppManager;
    protected final Provider<UpdateHandler> updateHandler;
    protected final UDPReplyHandlerCache udpReplyHandlerCache;
    protected final GuidMap multicastGuidMap;
    private final Provider<InspectionRequestHandler> inspectionRequestHandlerFactory;
    private final Provider<UDPCrawlerPingHandler> udpCrawlerPingHandlerFactory;
    private final Provider<OOBHandler> oobHandlerFactory;
    private final Provider<MACCalculatorRepositoryManager> MACCalculatorRepositoryManager;
    protected final Provider<LimeACKHandler> limeAckHandler;
    protected final QRPUpdater qrpUpdater;
    private final URNFilter urnFilter;
    private final SpamServices spamServices;
    private final PingRequestFactory pingRequestFactory;
    private final MessageHandlerBinder messageHandlerBinder;
    private final ConnectionListener connectionListener = new ConnectionListener();
    private final OutgoingQueryReplyFactory outgoingQueryReplyFactory;

    @Inject
    protected MessageRouterImpl(NetworkManager networkManager, QueryRequestFactory queryRequestFactory, QueryHandlerFactory queryHandlerFactory, OnDemandUnicaster onDemandUnicaster, HeadPongFactory headPongFactory, PingReplyFactory pingReplyFactory, ConnectionManager connectionManager, @Named(value="forMeReplyHandler") ReplyHandler forMeReplyHandler, QueryUnicaster queryUnicaster, FileViewManager fileManager, ContentManager contentManager, DHTManager dhtManager, UploadManager uploadManager, DownloadManager downloadManager, UDPService udpService, Provider<SearchResultHandler> searchResultHandler, SocketsManager socketsManager, HostCatcher hostCatcher, QueryReplyFactory queryReplyFactory, StaticMessages staticMessages, Provider<MessageDispatcher> messageDispatcher, MulticastService multicastService, QueryDispatcher queryDispatcher, Provider<ActivityCallback> activityCallback, ConnectionServices connectionServices, ApplicationServices applicationServices, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<PongCacher> pongCacher, Provider<SimppManager> simppManager, Provider<UpdateHandler> updateHandler, GuidMapManager guidMapManager, UDPReplyHandlerCache udpReplyHandlerCache, Provider<InspectionRequestHandler> inspectionRequestHandlerFactory, Provider<UDPCrawlerPingHandler> udpCrawlerPingHandlerFactory, PingRequestFactory pingRequestFactory, MessageHandlerBinder messageHandlerBinder, Provider<OOBHandler> oobHandlerFactory, Provider<MACCalculatorRepositoryManager> MACCalculatorRepositoryManager2, Provider<LimeACKHandler> limeACKHandler, OutgoingQueryReplyFactory outgoingQueryReplyFactory, QRPUpdater qrpUpdater, URNFilter urnFilter, SpamServices spamServices) {
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.queryHandlerFactory = queryHandlerFactory;
        this.onDemandUnicaster = onDemandUnicaster;
        this.headPongFactory = headPongFactory;
        this.pingReplyFactory = pingReplyFactory;
        this.connectionManager = connectionManager;
        this.forMeReplyHandler = forMeReplyHandler;
        this.queryUnicaster = queryUnicaster;
        this.fileManager = fileManager;
        this.contentManager = contentManager;
        this.dhtManager = dhtManager;
        this.uploadManager = uploadManager;
        this.downloadManager = downloadManager;
        this.udpService = udpService;
        this.searchResultHandler = searchResultHandler;
        this.socketsManager = socketsManager;
        this.hostCatcher = hostCatcher;
        this.queryReplyFactory = queryReplyFactory;
        this.staticMessages = staticMessages;
        this.messageDispatcher = messageDispatcher;
        this.multicastService = multicastService;
        this.queryDispatcher = queryDispatcher;
        this.activityCallback = activityCallback;
        this.connectionServices = connectionServices;
        this.backgroundExecutor = backgroundExecutor;
        this.pongCacher = pongCacher;
        this.simppManager = simppManager;
        this.updateHandler = updateHandler;
        this.udpCrawlerPingHandlerFactory = udpCrawlerPingHandlerFactory;
        this.pingRequestFactory = pingRequestFactory;
        this.messageHandlerBinder = messageHandlerBinder;
        this.outgoingQueryReplyFactory = outgoingQueryReplyFactory;
        this.multicastGuidMap = guidMapManager.getMap();
        this.udpReplyHandlerCache = udpReplyHandlerCache;
        this.inspectionRequestHandlerFactory = inspectionRequestHandlerFactory;
        this.oobHandlerFactory = oobHandlerFactory;
        this.MACCalculatorRepositoryManager = MACCalculatorRepositoryManager2;
        this.limeAckHandler = limeACKHandler;
        this.qrpUpdater = qrpUpdater;
        this.urnFilter = urnFilter;
        this.spamServices = spamServices;
        this._clientGUID = applicationServices.getMyGUID();
        this._bypassedResultsCache = new BypassedResultsCache(activityCallback, downloadManager);
    }

    private boolean setHandler(ConcurrentMap<Class<? extends Message>, MessageHandler> handlerMap, Class<? extends Message> clazz, MessageHandler handler) {
        if (handler != null) {
            MessageHandler old = handlerMap.put(clazz, handler);
            if (old != null) {
                LOG.warn("Ejecting old handler: " + old + " for clazz: " + clazz);
            }
            return true;
        }
        return handlerMap.remove(clazz) != null;
    }

    private void addHandler(ConcurrentMap<Class<? extends Message>, MessageHandler> handlerMap, Class<? extends Message> clazz, MessageHandler handler) {
        MessageHandler existing = (MessageHandler)handlerMap.get(clazz);
        if (existing != null) {
            DualMessageHandler dual;
            while (!handlerMap.replace(clazz, existing, dual = new DualMessageHandler(handler, existing))) {
                existing = (MessageHandler)handlerMap.get(clazz);
                dual = new DualMessageHandler(handler, existing);
            }
        } else {
            this.setHandler(handlerMap, clazz, handler);
        }
    }

    @Override
    public void setMessageHandler(Class<? extends Message> clazz, MessageHandler handler) {
        this.setHandler(this.messageHandlers, clazz, handler);
    }

    @Override
    public void addMessageHandler(Class<? extends Message> clazz, MessageHandler handler) {
        this.addHandler(this.messageHandlers, clazz, handler);
    }

    @Override
    public MessageHandler getMessageHandler(Class<? extends Message> clazz) {
        return (MessageHandler)this.messageHandlers.get(clazz);
    }

    @Override
    public void setUDPMessageHandler(Class<? extends Message> clazz, MessageHandler handler) {
        this.setHandler(this.udpMessageHandlers, clazz, handler);
    }

    @Override
    public void addUDPMessageHandler(Class<? extends Message> clazz, MessageHandler handler) {
        this.addHandler(this.udpMessageHandlers, clazz, handler);
    }

    @Override
    public MessageHandler getUDPMessageHandler(Class<? extends Message> clazz) {
        return (MessageHandler)this.udpMessageHandlers.get(clazz);
    }

    @Override
    public void setMulticastMessageHandler(Class<? extends Message> clazz, MessageHandler handler) {
        this.setHandler(this.multicastMessageHandlers, clazz, handler);
    }

    @Override
    public void addMulticastMessageHandler(Class<? extends Message> clazz, MessageHandler handler) {
        this.addHandler(this.multicastMessageHandlers, clazz, handler);
    }

    @Override
    public MessageHandler getMulticastMessageHandler(Class<? extends Message> clazz) {
        return (MessageHandler)this.multicastMessageHandlers.get(clazz);
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this).in(ServiceStage.EARLY);
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Message Routing");
    }

    @Override
    public void start() {
        this.connectionManager.addEventListener(this.connectionListener);
        this.QRP_PROPAGATOR.start();
        this.backgroundExecutor.scheduleWithFixedDelay(new ConnectBackExpirer(), 300000L, 300000L, TimeUnit.MILLISECONDS);
        this.backgroundExecutor.scheduleWithFixedDelay(new HopsFlowManager(this.uploadManager, this.connectionManager), 150000L, 15000L, TimeUnit.MILLISECONDS);
        this.backgroundExecutor.scheduleWithFixedDelay(new UDPReplyCleaner(), 60000L, 60000L, TimeUnit.MILLISECONDS);
        OOBHandler oobHandler = this.oobHandlerFactory.get();
        this.backgroundExecutor.scheduleWithFixedDelay(oobHandler, 30000L, 30000L, TimeUnit.MILLISECONDS);
        InspectionRequestHandler inspectionHandler = this.inspectionRequestHandlerFactory.get();
        this.messageHandlerBinder.bind(this);
        this.setMessageHandler(PingRequest.class, new PingRequestHandler());
        this.setMessageHandler(PingReply.class, new PingReplyHandler());
        this.setMessageHandler(QueryRequest.class, new QueryRequestHandler());
        this.setMessageHandler(QueryReply.class, new QueryReplyHandler());
        this.setMessageHandler(ResetTableMessage.class, new ResetTableHandler());
        this.setMessageHandler(PatchTableMessage.class, new PatchTableHandler());
        this.setMessageHandler(TCPConnectBackVendorMessage.class, new TCPConnectBackHandler());
        this.setMessageHandler(UDPConnectBackVendorMessage.class, new UDPConnectBackHandler());
        this.setMessageHandler(TCPConnectBackRedirect.class, new TCPConnectBackRedirectHandler());
        this.setMessageHandler(UDPConnectBackRedirect.class, new UDPConnectBackRedirectHandler());
        this.setMessageHandler(PushProxyRequest.class, new PushProxyRequestHandler());
        this.setMessageHandler(QueryStatusResponse.class, new QueryStatusResponseHandler());
        this.setMessageHandler(HeadPing.class, new HeadPingHandler());
        this.setMessageHandler(SimppVM.class, new SimppVMHandler());
        this.setMessageHandler(UpdateRequest.class, new UpdateRequestHandler());
        this.setMessageHandler(UpdateResponse.class, new UpdateResponseHandler());
        this.setMessageHandler(HeadPong.class, new HeadPongHandler());
        this.setMessageHandler(DHTContactsMessage.class, new DHTContactsMessageHandler());
        VendorMessageHandler vendorMessageHandler = new VendorMessageHandler();
        this.addMessageHandler(VendorMessage.class, vendorMessageHandler);
        this.addMessageHandler(CapabilitiesVM.class, vendorMessageHandler);
        this.setMessageHandler(InspectionRequest.class, inspectionHandler);
        this.setUDPMessageHandler(QueryRequest.class, new UDPQueryRequestHandler());
        this.setUDPMessageHandler(QueryReply.class, new UDPQueryReplyHandler(oobHandler));
        this.setUDPMessageHandler(PingRequest.class, new UDPPingRequestHandler());
        this.setUDPMessageHandler(PingReply.class, new UDPPingReplyHandler());
        LimeACKHandler ackHandler = this.limeAckHandler.get();
        ackHandler.start();
        this.setUDPMessageHandler(LimeACKVendorMessage.class, ackHandler);
        this.setUDPMessageHandler(ReplyNumberVendorMessage.class, oobHandler);
        this.setUDPMessageHandler(UDPCrawlerPing.class, this.udpCrawlerPingHandlerFactory.get());
        this.setUDPMessageHandler(HeadPing.class, new UDPHeadPingHandler());
        this.setUDPMessageHandler(UpdateRequest.class, new UDPUpdateRequestHandler());
        this.setUDPMessageHandler(ContentResponse.class, new UDPContentResponseHandler());
        this.setUDPMessageHandler(InspectionRequest.class, inspectionHandler);
        this.setMulticastMessageHandler(QueryRequest.class, new MulticastQueryRequestHandler());
        this.setMulticastMessageHandler(PingRequest.class, new MulticastPingRequestHandler());
    }

    @Override
    public void stop() {
        this.connectionManager.removeEventListener(this.connectionListener);
    }

    @Override
    public void originateQueryGUID(byte[] guid) {
        this._queryRouteTable.routeReply(guid, this.forMeReplyHandler);
    }

    @Override
    public void queryKilled(GUID guid) throws IllegalArgumentException {
        if (guid == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        this._bypassedResultsCache.queryKilled(guid);
    }

    @Override
    public void downloadFinished(GUID guid) throws IllegalArgumentException {
        if (guid == null) {
            throw new IllegalArgumentException("Input GUID is null!");
        }
        this._bypassedResultsCache.downloadFinished(guid);
    }

    @Override
    public Set<GUESSEndpoint> getQueryLocs(GUID guid) {
        return this._bypassedResultsCache.getQueryLocs(guid);
    }

    @Override
    public String getPingRouteTableDump() {
        return this._pingRouteTable.toString();
    }

    @Override
    public String getQueryRouteTableDump() {
        return this._queryRouteTable.toString();
    }

    @Override
    public String getPushRouteTableDump() {
        return this._pushRouteTable.toString();
    }

    private void removeConnection(ReplyHandler rh) {
        this.queryDispatcher.removeReplyHandler(rh);
        this._pingRouteTable.removeReplyHandler(rh);
        this._queryRouteTable.removeReplyHandler(rh);
        this._pushRouteTable.removeReplyHandler(rh);
        this._headPongRouteTable.removeReplyHandler(rh);
    }

    @Override
    public void handleMessage(Message msg, ReplyHandler receivingConnection) {
        msg.hop();
        MessageHandler msgHandler = this.getMessageHandler(msg.getHandlerClass());
        if (msgHandler != null) {
            msgHandler.handleMessage(msg, null, receivingConnection);
        } else if (msg instanceof VendorMessage && (msgHandler = this.getMessageHandler(VendorMessage.class)) != null) {
            msgHandler.handleMessage(msg, null, receivingConnection);
        }
        this.notifyMessageListener(msg, receivingConnection);
    }

    private final void notifyMessageListener(Message msg, ReplyHandler handler) {
        List<MessageListener> all = this._messageListeners.get(msg.getGUID());
        if (all != null) {
            for (MessageListener next : all) {
                next.processMessage(msg, handler);
            }
        }
    }

    @Override
    public void handleUDPMessage(Message msg, InetSocketAddress addr) {
        byte[] origGUID;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Handling UDP message " + msg + " from " + addr);
        }
        msg.hop();
        if (msg instanceof QueryReply && (origGUID = this.multicastGuidMap.getOriginalGUID(msg.getGUID())) != null) {
            msg = this.queryReplyFactory.createQueryReply(origGUID, (QueryReply)msg);
            ((QueryReply)msg).setMulticastAllowed(true);
        }
        ReplyHandler replyHandler = this.udpReplyHandlerCache.getUDPReplyHandler(addr);
        MessageHandler msgHandler = this.getUDPMessageHandler(msg.getHandlerClass());
        if (msgHandler != null) {
            msgHandler.handleMessage(msg, addr, replyHandler);
        } else if (msg instanceof VendorMessage && (msgHandler = this.getUDPMessageHandler(VendorMessage.class)) != null) {
            msgHandler.handleMessage(msg, addr, replyHandler);
        }
        this.notifyMessageListener(msg, replyHandler);
    }

    @Override
    public void handleMulticastMessage(Message msg, InetSocketAddress addr) {
        if (msg.getTTL() > 1) {
            return;
        }
        msg.hop();
        if (NetworkUtils.isLocalAddress(addr.getAddress()) && !ConnectionSettings.ALLOW_MULTICAST_LOOPBACK.getValue()) {
            return;
        }
        ReplyHandler replyHandler = this.udpReplyHandlerCache.getUDPReplyHandler(addr);
        MessageHandler msgHandler = this.getMulticastMessageHandler(msg.getHandlerClass());
        if (msgHandler != null) {
            msgHandler.handleMessage(msg, addr, replyHandler);
        } else if (msg instanceof VendorMessage && (msgHandler = this.getMulticastMessageHandler(VendorMessage.class)) != null) {
            msgHandler.handleMessage(msg, addr, replyHandler);
        }
        this.notifyMessageListener(msg, replyHandler);
    }

    protected boolean hasValidQueryKey(InetAddress ip, int port, QueryRequest qr) {
        AddressSecurityToken qk = qr.getQueryKey();
        if (qk == null) {
            return false;
        }
        return qk.isFor(ip, port);
    }

    protected void sendAcknowledgement(InetSocketAddress addr, byte[] guid) {
        PingReply reply;
        Endpoint host = this.connectionManager.getConnectedGUESSUltrapeer();
        if (host != null) {
            try {
                reply = this.pingReplyFactory.createGUESSReply(guid, (byte)1, host);
            }
            catch (UnknownHostException e) {
                reply = this.createPingReply(guid);
            }
        } else {
            reply = this.createPingReply(guid);
        }
        if (reply == null) {
            return;
        }
        this.udpService.send(reply, addr.getAddress(), addr.getPort());
    }

    private PingReply createPingReply(byte[] guid) {
        GUESSEndpoint endpoint = this.queryUnicaster.getUnicastEndpoint();
        if (endpoint == null) {
            if (this.networkManager.isIpPortValid()) {
                return this.pingReplyFactory.create(guid, (byte)1);
            }
            return null;
        }
        return this.pingReplyFactory.createGUESSReply(guid, (byte)1, endpoint.getPort(), endpoint.getInetAddress().getAddress());
    }

    final void handlePingRequestPossibleDuplicate(PingRequest request, ReplyHandler handler) {
        if (this._pingRouteTable.tryToRouteReply(request.getGUID(), handler) != null) {
            this.handlePingRequest(request, handler);
        }
    }

    final void handleUDPPingRequestPossibleDuplicate(PingRequest request, ReplyHandler handler, InetSocketAddress addr) {
        if (this._pingRouteTable.tryToRouteReply(request.getGUID(), handler) != null) {
            this.handleUDPPingRequest(request, handler, addr);
        }
    }

    final void handleQueryRequestPossibleDuplicate(QueryRequest request, ReplyHandler receivingConnection) {
        boolean isProbeQuery = request.getTTL() == 0 && (request.getHops() == 1 || request.getHops() == 2);
        ResultCounter counter = this._queryRouteTable.tryToRouteReply(request.getGUID(), receivingConnection);
        if (counter != null) {
            if (isProbeQuery) {
                this._queryRouteTable.setTTL(counter, (byte)1);
            }
            this.handleQueryRequest(request, receivingConnection, counter, true);
        } else if (!isProbeQuery) {
            if (this.wasProbeQuery(request)) {
                this.handleQueryRequest(request, receivingConnection, counter, false);
            } else {
                this.tallyDupQuery(request);
            }
        } else if (isProbeQuery) {
            this.tallyDupQuery(request);
        }
    }

    private boolean wasProbeQuery(QueryRequest request) {
        return request.getTTL() > 0 && this._queryRouteTable.getAndSetTTL(request.getGUID(), (byte)1, (byte)(request.getTTL() + 1));
    }

    private void tallyDupQuery(QueryRequest request) {
        this.duplicateQueryCounter.duplicateQuery(request);
    }

    final boolean handleUDPQueryRequestPossibleDuplicate(QueryRequest request, ReplyHandler handler) {
        ResultCounter counter = this._queryRouteTable.tryToRouteReply(request.getGUID(), handler);
        if (counter != null) {
            this.handleQueryRequest(request, handler, counter, true);
            return true;
        }
        return false;
    }

    private final void handlePingRequest(PingRequest ping, ReplyHandler handler) {
        if (ping.isHeartbeat() || handler.allowNewPings()) {
            this.respondToPingRequest(ping, handler);
        }
    }

    protected void handleUDPPingRequest(PingRequest pingRequest, ReplyHandler handler, InetSocketAddress addr) {
        if (pingRequest.isQueryKeyRequest()) {
            this.sendQueryKeyPong(pingRequest, addr);
        } else {
            this.respondToUDPPingRequest(pingRequest, addr, handler);
        }
    }

    protected void sendQueryKeyPong(PingRequest pr, InetSocketAddress addr) {
        long now = System.currentTimeMillis();
        if (now - this._lastQueryKeyTime < (long)SearchSettings.QUERY_KEY_DELAY.getValue()) {
            return;
        }
        this._lastQueryKeyTime = now;
        InetAddress address = addr.getAddress();
        int port = addr.getPort();
        AddressSecurityToken key = new AddressSecurityToken(address, port, this.MACCalculatorRepositoryManager.get());
        if (this.networkManager.isIpPortValid()) {
            PingReply reply = this.pingReplyFactory.createQueryKeyReply(pr.getGUID(), (byte)1, key);
            this.udpService.send(reply, addr.getAddress(), addr.getPort());
        }
    }

    protected void handleUDPPingReply(PingReply reply, ReplyHandler handler, InetAddress address, int port) {
        if (reply.getQueryKey() != null) {
            this.onDemandUnicaster.handleQueryKeyPong(reply);
            return;
        }
        if (reply.getPort() == port && reply.getInetAddress().equals(address)) {
            this.handlePingReply(reply, handler);
        }
    }

    public void handleQueryRequest(QueryRequest request, ReplyHandler handler, ResultCounter counter, boolean locallyEvaluate) {
        if (!this.spamServices.isPersonalSpam(request)) {
            this.activityCallback.get().handleQuery(request, handler.getAddress(), handler.getPort());
        }
        this.updateMessage(request, handler);
        if (handler.isSupernodeClientConnection() && counter != null) {
            LOG.trace("Query request from leaf");
            if (request.desiresOutOfBandReplies()) {
                LOG.trace("Leaf wants OOB replies");
                String remoteAddr = handler.getInetAddress().getHostAddress();
                String myAddress = NetworkUtils.ip2string(this.networkManager.getAddress());
                if (request.getReplyAddress().equals(remoteAddr)) {
                    LOG.trace("OOB address is leaf's address");
                } else if (request.getReplyAddress().equals(myAddress) && this.networkManager.isOOBCapable()) {
                    LOG.trace("OOB address is my address");
                } else {
                    LOG.trace("OOB address is wrong, dropping query");
                    return;
                }
            }
            locallyEvaluate = false;
            this.respondToQueryRequest(request, this._clientGUID, handler);
            this.multicastQueryRequest(request);
            if (handler.isGoodLeaf()) {
                this.sendDynamicQuery(this.queryHandlerFactory.createHandlerForNewLeaf(request, handler, counter));
            } else {
                this.sendDynamicQuery(this.queryHandlerFactory.createHandlerForOldLeaf(request, handler, counter));
            }
        } else if (request.getTTL() > 0 && this.connectionServices.isSupernode()) {
            if (handler.isGoodUltrapeer()) {
                this.forwardQueryToUltrapeers(request, handler);
            } else {
                this.forwardLimitedQueryToUltrapeers(request, handler);
            }
        }
        if (locallyEvaluate) {
            this.forwardQueryRequestToLeaves(request, handler);
            if (!(!request.isFirewalledSource() || this.networkManager.acceptedIncomingConnection() || request.canDoFirewalledTransfer() && this.networkManager.canDoFWT())) {
                return;
            }
            this.respondToQueryRequest(request, this._clientGUID, handler);
        }
    }

    @Override
    public boolean addBypassedSource(ReplyNumberVendorMessage reply, ReplyHandler handler) {
        if (!reply.canReceiveUnsolicited()) {
            return false;
        }
        GUESSEndpoint ep = new GUESSEndpoint(handler.getInetAddress(), handler.getPort());
        return this._bypassedResultsCache.addBypassedSource(new GUID(reply.getGUID()), ep);
    }

    @Override
    public boolean addBypassedSource(QueryReply reply, ReplyHandler handler) {
        if (reply.isFirewalled()) {
            return false;
        }
        GUESSEndpoint ep = new GUESSEndpoint(handler.getInetAddress(), handler.getPort());
        return this._bypassedResultsCache.addBypassedSource(new GUID(reply.getGUID()), ep);
    }

    @Override
    public int getNumOOBToRequest(ReplyNumberVendorMessage reply) {
        GUID qGUID = new GUID(reply.getGUID());
        int numResults = this.searchResultHandler.get().getNumResultsForQuery(qGUID);
        if (numResults < 0) {
            numResults = this.queryDispatcher.getLeafResultsForQuery(qGUID);
        }
        if (numResults < 0 || numResults > 150) {
            return -1;
        }
        return reply.getNumResults();
    }

    @Override
    public boolean isQueryAlive(GUID guid) {
        return this._queryRouteTable.getReplyHandler(guid.bytes()) != null;
    }

    @Override
    public boolean isHostUnicastQueried(GUID guid, IpPort host) {
        return this.onDemandUnicaster.isHostQueriedForGUID(guid, host);
    }

    protected void handleUDPConnectBackRequest(UDPConnectBackVendorMessage udp, Connection source) {
        GUID guidToUse = udp.getConnectBackGUID();
        int portToContact = udp.getConnectBackPort();
        InetAddress sourceAddr = source.getInetAddress();
        UDPConnectBackRedirect msg = new UDPConnectBackRedirect(guidToUse, sourceAddr, portToContact);
        int sentTo = 0;
        ArrayList<RoutedConnection> peers = new ArrayList<RoutedConnection>(this.connectionManager.getInitializedConnections());
        Collections.shuffle(peers);
        for (RoutedConnection currMC : peers) {
            if (sentTo >= 5) break;
            if (currMC == source || currMC.getConnectionCapabilities().remoteHostSupportsUDPRedirect() < 0) continue;
            currMC.send(msg);
            ++sentTo;
        }
    }

    protected void handleUDPConnectBackRedirect(UDPConnectBackRedirect udp, Connection source) {
        if (!source.getConnectionCapabilities().isSupernodeSupernodeConnection()) {
            return;
        }
        GUID guidToUse = udp.getConnectBackGUID();
        int portToContact = udp.getConnectBackPort();
        InetAddress addrToContact = udp.getConnectBackAddress();
        Endpoint endPoint = new Endpoint(addrToContact.getAddress(), portToContact);
        if (this.connectionManager.isConnectedTo(endPoint.getAddress())) {
            return;
        }
        String addrString = addrToContact.getHostAddress();
        if (!this.shouldServiceRedirect(_udpConnectBacks, addrString)) {
            return;
        }
        UDPService.mutateGUID(guidToUse.bytes(), addrToContact, portToContact);
        PingRequest pr = this.pingRequestFactory.createPingRequest(guidToUse.bytes(), (byte)1, (byte)0);
        this.udpService.send(pr, addrToContact, portToContact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldServiceRedirect(FixedsizeHashMap<String, String> map, String key) {
        FixedsizeHashMap<String, String> fixedsizeHashMap = map;
        synchronized (fixedsizeHashMap) {
            String placeHolder = map.get(key);
            if (placeHolder == null) {
                try {
                    map.put(key, key);
                    return true;
                }
                catch (NoMoreStorageException nomo) {
                    return false;
                }
            }
            return false;
        }
    }

    protected void handleTCPConnectBackRequest(TCPConnectBackVendorMessage tcp, Connection source) {
        int portToContact = tcp.getConnectBackPort();
        InetAddress sourceAddr = source.getInetAddress();
        TCPConnectBackRedirect msg = new TCPConnectBackRedirect(sourceAddr, portToContact);
        int sentTo = 0;
        ArrayList<RoutedConnection> peers = new ArrayList<RoutedConnection>(this.connectionManager.getInitializedConnections());
        Collections.shuffle(peers);
        for (RoutedConnection currMC : peers) {
            if (sentTo >= 5) break;
            if (currMC == source || currMC.getConnectionCapabilities().remoteHostSupportsTCPRedirect() < 0) continue;
            currMC.send(msg);
            ++sentTo;
        }
    }

    protected void handleTCPConnectBackRedirect(TCPConnectBackRedirect tcp, Connection source) {
        if (!source.getConnectionCapabilities().isSupernodeSupernodeConnection()) {
            return;
        }
        final int portToContact = tcp.getConnectBackPort();
        final String addrToContact = tcp.getConnectBackAddress().getHostAddress();
        Endpoint endPoint = new Endpoint(addrToContact, portToContact);
        if (this.connectionManager.isConnectedTo(endPoint.getAddress())) {
            return;
        }
        if (!this.shouldServiceRedirect(_tcpConnectBacks, addrToContact)) {
            return;
        }
        TCP_CONNECT_BACKER.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Socket sock = null;
                try {
                    try {
                        sock = MessageRouterImpl.this.socketsManager.connect(new InetSocketAddress(addrToContact, portToContact), 6000, SocketsManager.ConnectType.TLS);
                        sock.setSoTimeout(6000);
                        OutputStream os = sock.getOutputStream();
                        os.write(StringUtils.toAsciiBytes("CONNECT BACK\r\n\r\n"));
                        os.flush();
                    }
                    catch (IOException noTls) {
                        IOUtils.close(sock);
                        sock = MessageRouterImpl.this.socketsManager.connect(new InetSocketAddress(addrToContact, portToContact), 12000, SocketsManager.ConnectType.PLAIN);
                        sock.setSoTimeout(12000);
                        OutputStream os = sock.getOutputStream();
                        os.write(StringUtils.toAsciiBytes("CONNECT BACK\r\n\r\n"));
                        os.flush();
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Succesful connectback to: " + addrToContact);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ignored) {
                        LOG.warn("Interrupted connectback", ignored);
                    }
                    IOUtils.close(sock);
                }
                catch (IOException ignored) {
                    LOG.warn("IOX during connectback", ignored);
                }
                finally {
                    IOUtils.close(sock);
                }
            }
        });
    }

    protected void handlePushProxyRequest(PushProxyRequest ppReq, RoutedConnection source) {
        if (source.isSupernodeClientConnection() && this.networkManager.isIpPortValid()) {
            String stringAddr = NetworkUtils.ip2string(this.networkManager.getAddress());
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(stringAddr);
            }
            catch (UnknownHostException uhe) {
                ErrorService.error(uhe);
            }
            if (this._pushRouteTable.routeReply(ppReq.getClientGUID().bytes(), source) != null) {
                source.setPushProxyFor(true);
                PushProxyAcknowledgement ack = new PushProxyAcknowledgement(addr, this.networkManager.getPort(), ppReq.getClientGUID());
                source.send(ack);
            }
        }
    }

    protected void handleQueryStatus(QueryStatusResponse resp, RoutedConnection leaf) {
        if (!leaf.isSupernodeClientConnection()) {
            return;
        }
        GUID queryGUID = resp.getQueryGUID();
        int numResults = resp.getNumResults();
        this.queryDispatcher.updateLeafResultsForQuery(queryGUID, numResults);
    }

    @Override
    public void sendPingRequest(PingRequest request, RoutedConnection connection) {
        Objects.nonNull(request, "ping");
        Objects.nonNull(connection, "connection");
        this._pingRouteTable.routeReply(request.getGUID(), this.forMeReplyHandler);
        connection.send(request);
    }

    @Override
    public void broadcastPingRequest(PingRequest ping) {
        Objects.nonNull(ping, "ping");
        this._pingRouteTable.routeReply(ping.getGUID(), this.forMeReplyHandler);
        this.broadcastPingRequest(ping, this.forMeReplyHandler, this.connectionManager);
    }

    @Override
    public void sendDynamicQuery(QueryRequest query) {
        Objects.nonNull(query, "query");
        ResultCounter counter = this._queryRouteTable.routeReply(query.getGUID(), this.forMeReplyHandler);
        if (this.connectionServices.isSupernode()) {
            QueryHandler qh = this.queryHandlerFactory.createHandlerForMe(query, counter);
            this.sendDynamicQuery(qh);
        } else {
            this.originateLeafQuery(query);
        }
        this.originateMulticastQuery(query);
    }

    protected void originateMulticastQuery(QueryRequest query) {
        byte[] newGUID = GUID.makeGuid();
        QueryRequest mquery = this.queryRequestFactory.createMulticastQuery(newGUID, query);
        this.multicastGuidMap.addMapping(query.getGUID(), newGUID, 60000L);
        this.multicastQueryRequest(mquery);
    }

    private void sendDynamicQuery(QueryHandler qh) {
        Objects.nonNull(qh, "query handler");
        this.queryDispatcher.addQuery(qh);
    }

    private void broadcastPingRequest(PingRequest request, ReplyHandler receivingConnection, ConnectionManager manager) {
        List<RoutedConnection> list = manager.getInitializedConnections();
        boolean randomlyForward = list.size() > 3;
        for (RoutedConnection mc : list) {
            double percentToIgnore;
            if (mc == receivingConnection || !mc.isStable() || receivingConnection != this.forMeReplyHandler && mc.getConnectionCapabilities().isClientSupernodeConnection()) continue;
            double d = percentToIgnore = mc.supportsPongCaching() ? 0.7 : 0.9;
            if (randomlyForward && !(Math.random() >= percentToIgnore)) continue;
            mc.send(request);
        }
    }

    @Override
    public final void forwardQueryRequestToLeaves(QueryRequest query, ReplyHandler handler) {
        if (!this.connectionServices.isSupernode()) {
            return;
        }
        List<RoutedConnection> list = this.connectionManager.getInitializedClientConnections();
        List<RoutedConnection> hitConnections = new ArrayList<RoutedConnection>();
        for (RoutedConnection mc : list) {
            if (mc == handler || !mc.shouldForwardQuery(query)) continue;
            hitConnections.add(mc);
        }
        if (list.size() > 8 && (double)hitConnections.size() / (double)list.size() > 0.8) {
            int startIndex = (int)Math.floor(Math.random() * (double)hitConnections.size() * 0.75);
            hitConnections = hitConnections.subList(startIndex, startIndex + hitConnections.size() / 4);
        }
        for (RoutedConnection mc : hitConnections) {
            mc.send(query);
        }
        this.leafQRPHits.count(hitConnections.size());
    }

    private boolean sendRoutedQueryToHost(QueryRequest query, RoutedConnection mc, ReplyHandler handler) {
        if (mc.shouldForwardQuery(query)) {
            mc.send(query);
            return true;
        }
        return false;
    }

    protected void unicastQueryRequest(QueryRequest query, ReplyHandler conn) {
        query.setTTL((byte)1);
        this.queryUnicaster.addQuery(query, conn);
    }

    protected void multicastQueryRequest(QueryRequest query) {
        query.setTTL((byte)1);
        this.multicastService.send(query);
    }

    void forwardQueryToUltrapeers(QueryRequest query, ReplyHandler handler) {
        List<RoutedConnection> list = this.connectionManager.getInitializedConnections();
        int forwarded = 0;
        for (RoutedConnection mc : list) {
            forwarded += this.forwardQueryToUltrapeer(query, handler, mc) ? 1 : 0;
        }
        if (query.getTTL() == 1) {
            this.lastHopCounter.countMessage(query.getHops(), forwarded);
        }
    }

    void forwardLimitedQueryToUltrapeers(QueryRequest query, ReplyHandler handler) {
        List<RoutedConnection> list = this.connectionManager.getInitializedConnections();
        int limit = list.size();
        int connectionsNeededForOld = 15;
        for (int i = 0; i < limit && connectionsNeededForOld != 0; ++i) {
            RoutedConnection mc = list.get(i);
            if (mc.isGoodUltrapeer() && limit - i > connectionsNeededForOld) continue;
            this.forwardQueryToUltrapeer(query, handler, mc);
            --connectionsNeededForOld;
        }
    }

    boolean forwardQueryToUltrapeer(QueryRequest query, ReplyHandler handler, RoutedConnection ultrapeer) {
        boolean lastHop;
        if (ultrapeer == handler) {
            return false;
        }
        if (ultrapeer.getConnectionCapabilities().isClientSupernodeConnection()) {
            return false;
        }
        if (query.isFeatureQuery() && !ultrapeer.getConnectionCapabilities().getRemoteHostSupportsFeatureQueries()) {
            return false;
        }
        boolean bl = lastHop = query.getTTL() == 1;
        if (lastHop && ultrapeer.isUltrapeerQueryRoutingConnection()) {
            return this.sendRoutedQueryToHost(query, ultrapeer, handler);
        }
        ultrapeer.send(query);
        return true;
    }

    void originateLeafQuery(QueryRequest qr) {
        List<RoutedConnection> list = this.connectionManager.getInitializedConnections();
        int max = qr.isWhatIsNewRequest() ? 2 : 3;
        int start = !qr.isWhatIsNewRequest() ? 0 : (int)Math.floor(Math.random() * (double)(list.size() - 1));
        int limit = Math.min(max, list.size());
        boolean wantsOOB = qr.desiresOutOfBandReplies();
        if (wantsOOB) {
            LOG.trace("Query asks for OOB replies");
        } else {
            LOG.trace("Query does not ask for OOB replies");
        }
        for (int i = start; i < start + limit; ++i) {
            RoutedConnection mc = list.get(i);
            QueryRequest qrToSend = qr;
            if (wantsOOB && mc.getConnectionCapabilities().remoteHostSupportsLeafGuidance() < 0) {
                LOG.trace("Unmarking OOB query");
                qrToSend = this.queryRequestFactory.unmarkOOBQuery(qr);
            }
            mc.originateQuery(qrToSend);
        }
    }

    @Override
    public boolean sendInitialQuery(QueryRequest query, RoutedConnection mc) {
        Objects.nonNull(query, "query");
        Objects.nonNull(mc, "connection");
        if (query.isFeatureQuery() && !mc.getConnectionCapabilities().getRemoteHostSupportsFeatureQueries()) {
            return false;
        }
        query.originate();
        mc.send(query);
        return true;
    }

    protected abstract void respondToPingRequest(PingRequest var1, ReplyHandler var2);

    protected abstract void respondToUDPPingRequest(PingRequest var1, InetSocketAddress var2, ReplyHandler var3);

    protected abstract boolean respondToQueryRequest(QueryRequest var1, byte[] var2, ReplyHandler var3);

    protected void handlePingReply(PingReply reply, ReplyHandler handler) {
        ReplyHandler replyHandler;
        boolean newAddress = this.hostCatcher.add(reply);
        if (newAddress && !reply.isUDPHostCache()) {
            this.pongCacher.get().addPong(reply);
        }
        if ((replyHandler = this._pingRouteTable.getReplyHandler(reply.getGUID())) != null) {
            replyHandler.handlePingReply(reply, handler);
        } else {
            handler.countDroppedMessage();
        }
        boolean supportsUnicast = reply.supportsUnicast();
        if (newAddress && (reply.isUltrapeer() || supportsUnicast)) {
            List<RoutedConnection> list = this.connectionManager.getInitializedClientConnections();
            for (RoutedConnection c : list) {
                assert (c != null) : "null c.";
                if (c == handler || c == replyHandler || !c.allowNewPongs()) continue;
                c.handlePingReply(reply, handler);
            }
        }
    }

    @Override
    public void handleQueryReply(QueryReply queryReply, ReplyHandler handler) {
        Objects.nonNull(queryReply, "query reply");
        Objects.nonNull(handler, "reply handler");
        if (!this.altCountOk(queryReply)) {
            return;
        }
        int classC = ByteUtils.beb2int(queryReply.getIPBytes(), 0);
        RouteTable.ReplyRoutePair rrp = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getUniqueResultCount(), queryReply.getPartialResultCount(), classC, !this.urnFilter.isBlacklisted(queryReply));
        if (rrp != null) {
            queryReply.setPriority(rrp.getBytesRouted());
            this._pushRouteTable.routeReply(queryReply.getClientGUID(), handler);
            ReplyHandler rh = rrp.getReplyHandler();
            this._queryRouteTable.countHopsTTLNet(queryReply);
            if (rh == this.forMeReplyHandler) {
                this._queryRouteTable.timeStampResults(queryReply);
            }
            if (!this.shouldDropReply(rrp, rh, queryReply)) {
                rh.handleQueryReply(queryReply, handler);
                this.queryUnicaster.handleQueryReply(queryReply);
            } else {
                LOG.trace("Dropping reply");
                handler.countDroppedMessage();
            }
        } else {
            LOG.trace("Dropping reply with no route table entry");
            handler.countDroppedMessage();
        }
    }

    private boolean altCountOk(QueryReply qr) {
        try {
            for (Response r : qr.getResultsAsList()) {
                if (r.getLocations().size() <= FilterSettings.MAX_ALTS_PER_RESPONSE.getValue()) continue;
                return false;
            }
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
        return true;
    }

    private boolean shouldDropReply(RouteTable.ReplyRoutePair rrp, ReplyHandler rh, QueryReply qr) {
        byte ttl = qr.getTTL();
        if (rh == this.forMeReplyHandler) {
            return false;
        }
        if (ttl == 0) {
            this.droppedReplyCounter.dropTTL0();
            return true;
        }
        int resultsRouted = rrp.getResultsRouted();
        if (resultsRouted > 100) {
            this.droppedReplyCounter.tooManyResults((short)resultsRouted);
            return true;
        }
        int bytesRouted = rrp.getBytesRouted();
        if (ttl > 2 && bytesRouted < 51200) {
            return false;
        }
        if (ttl == 1 && bytesRouted < 204800) {
            return false;
        }
        if (ttl == 2 && bytesRouted < 102400) {
            return false;
        }
        this.droppedReplyCounter.ttlByteDrop(ttl, bytesRouted);
        return true;
    }

    private void handleSimppVM(SimppVM simppVM, ReplyHandler handler) {
        if (simppVM.isNewVersion()) {
            this.simppManager.get().checkAndUpdate(handler, simppVM.getData());
        }
    }

    private void handleUpdateRequest(UpdateRequest req, ReplyHandler handler) {
        byte[] data;
        byte[] byArray = data = req.isOldRequest() ? this.updateHandler.get().getOldUpdateResponse() : this.updateHandler.get().getLatestBytes();
        if (data != null) {
            UpdateResponse msg = UpdateResponse.createUpdateResponse(data, req);
            handler.reply(msg);
        }
    }

    private void handleUpdateResponse(UpdateResponse resp, ReplyHandler handler) {
        if (resp.isNewVersion()) {
            this.updateHandler.get().handleNewData(resp.getUpdate(), handler);
        }
    }

    private void handleContentResponse(ContentResponse msg, ReplyHandler handler) {
        this.contentManager.handleContentResponse(msg);
    }

    @Override
    public ReplyHandler getPushHandler(byte[] guid) {
        ReplyHandler replyHandler = this._pushRouteTable.getReplyHandler(guid);
        if (replyHandler != null) {
            return replyHandler;
        }
        if (Arrays.equals(this._clientGUID, guid)) {
            return this.forMeReplyHandler;
        }
        if (!this.connectionServices.isSupernode()) {
            return null;
        }
        for (RoutedConnection leaf : this.connectionManager.getInitializedClientConnections()) {
            if (!leaf.isPushProxyFor() || !Arrays.equals(leaf.getClientGUID(), guid)) continue;
            return leaf;
        }
        return null;
    }

    protected void sendPingReply(PingReply pong, ReplyHandler handler) {
        Objects.nonNull(pong, "pong");
        Objects.nonNull(handler, "reply handler");
        handler.handlePingReply(pong, null);
    }

    protected void sendQueryReply(QueryReply queryReply) throws IOException {
        Objects.nonNull(queryReply, "query reply");
        RouteTable.ReplyRoutePair rrp = this._queryRouteTable.getReplyHandler(queryReply.getGUID(), queryReply.getTotalLength(), queryReply.getResultCount(), queryReply.getPartialResultCount());
        if (rrp == null) {
            throw new IOException("no route for reply");
        }
        queryReply.setPriority(rrp.getBytesRouted());
        rrp.getReplyHandler().handleQueryReply(queryReply, null);
    }

    @Override
    public void sendPushRequest(PushRequest push) throws IOException {
        Objects.nonNull(push, "push");
        ReplyHandler replyHandler = this.getPushHandler(push.getClientGUID());
        if (replyHandler == null) {
            throw new IOException("no route for push");
        }
        replyHandler.handlePushRequest(push, this.forMeReplyHandler);
    }

    @Override
    public void sendMulticastPushRequest(PushRequest push) {
        Objects.nonNull(push, "push");
        assert (push.getTTL() == 1) : "multicast push ttl not 1";
        this.multicastService.send(push);
    }

    @Override
    public Iterable<QueryReply> responsesToQueryReplies(Response[] responses, QueryRequest queryRequest) {
        return this.responsesToQueryReplies(responses, queryRequest, 10, null);
    }

    @Override
    public Iterable<QueryReply> responsesToQueryReplies(Response[] responses, QueryRequest queryRequest, int REPLY_LIMIT, SecurityToken securityToken) {
        int numResponses = responses.length;
        byte numHops = queryRequest.getHops();
        if (REPLY_LIMIT > 1 && numHops > 2 && numResponses > 10) {
            int j = (int)(Math.random() * (double)numResponses) % (numResponses - 10);
            Response[] newResponses = new Response[10];
            int i = 0;
            while (i < 10) {
                newResponses[i] = responses[j];
                ++i;
                ++j;
            }
            responses = newResponses;
            numResponses = responses.length;
        }
        return this.outgoingQueryReplyFactory.createReplies(responses, queryRequest, securityToken, REPLY_LIMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResetTableMessage(ResetTableMessage rtm, RoutedConnection mc) {
        if (!MessageRouterImpl.isQRPConnection(mc)) {
            return;
        }
        Object object = mc.getQRPLock();
        synchronized (object) {
            mc.resetQueryRouteTable(rtm);
        }
        if (mc.isLeafConnection()) {
            this._lastQueryRouteTable = this.createRouteTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePatchTableMessage(PatchTableMessage ptm, RoutedConnection mc) {
        if (!MessageRouterImpl.isQRPConnection(mc)) {
            return;
        }
        Object object = mc.getQRPLock();
        synchronized (object) {
            mc.patchQueryRouteTable(ptm);
        }
        if (mc.isLeafConnection()) {
            if (mc.getRoutedConnectionStatistics().getQueryRouteTablePercentFull() == 100.0) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Leaf " + mc + " sent full query routing table");
                }
                mc.close();
            }
            this._lastQueryRouteTable = this.createRouteTable();
        }
    }

    private void updateMessage(QueryRequest request, ReplyHandler handler) {
        if (SearchSettings.SEND_LIME_RESPONSES.getBoolean() && request.isQueryForLW() && this.staticMessages.getLimeReply() != null) {
            QueryReply qr = this.queryReplyFactory.createQueryReply(request.getGUID(), this.staticMessages.getLimeReply());
            qr.setHops((byte)0);
            qr.setTTL((byte)(request.getHops() + 1));
            try {
                this.sendQueryReply(qr);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        if (!(handler instanceof Connection)) {
            return;
        }
    }

    private static boolean isQRPConnection(Connection c) {
        if (c.getConnectionCapabilities().isSupernodeClientConnection()) {
            return true;
        }
        return c.getConnectionCapabilities().isUltrapeerQueryRoutingConnection();
    }

    void forwardQueryRouteTables() {
        long time = System.currentTimeMillis();
        List<RoutedConnection> list = this.connectionManager.getInitializedConnections();
        QueryRouteTable table = null;
        List<RouteTableMessage> patches = null;
        QueryRouteTable lastSent = null;
        for (RoutedConnection c : list) {
            if (!this.connectionServices.isSupernode() ? !c.getConnectionCapabilities().isClientSupernodeConnection() || !c.getConnectionCapabilities().isQueryRoutingEnabled() : !c.isUltrapeerQueryRoutingConnection()) continue;
            if (time < c.getRoutedConnectionStatistics().getNextQRPForwardTime()) continue;
            c.getRoutedConnectionStatistics().incrementNextQRPForwardTime(time);
            if (table == null) {
                this._lastQueryRouteTable = table = this.createRouteTable();
            }
            if (lastSent == c.getRoutedConnectionStatistics().getQueryRouteTableSent()) {
                if (patches == null) {
                    patches = table.encode(lastSent, true);
                }
            } else {
                lastSent = c.getRoutedConnectionStatistics().getQueryRouteTableSent();
                patches = table.encode(lastSent, true);
            }
            if (!ConnectionSettings.SEND_QRP.getValue()) {
                return;
            }
            for (RouteTableMessage next : patches) {
                c.send(next);
            }
            c.getRoutedConnectionStatistics().setQueryRouteTableSent(table);
        }
    }

    @Override
    public QueryRouteTable getQueryRouteTable() {
        return this._lastQueryRouteTable;
    }

    QueryRouteTable createRouteTable() {
        QueryRouteTable ret = this.qrpUpdater.getQRT();
        if (this.connectionServices.isSupernode()) {
            this.addQueryRoutingEntriesForLeaves(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQueryRoutingEntriesForLeaves(QueryRouteTable qrt) {
        List<RoutedConnection> leaves = this.connectionManager.getInitializedClientConnections();
        for (RoutedConnection mc : leaves) {
            Object object = mc.getQRPLock();
            synchronized (object) {
                QueryRouteTable qrtr;
                if (!mc.isBusyLeaf() && (qrtr = mc.getRoutedConnectionStatistics().getQueryRouteTableReceived()) != null) {
                    qrt.addAll(qrtr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMessageListener(byte[] guid, MessageListener ml) {
        ml.registered(guid);
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            TreeMap listeners = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
            listeners.putAll(this._messageListeners);
            ArrayList<MessageListener> all = (ArrayList<MessageListener>)listeners.get(guid);
            if (all == null) {
                all = new ArrayList<MessageListener>(1);
                all.add(ml);
            } else {
                ArrayList<MessageListener> temp = new ArrayList<MessageListener>(all.size() + 1);
                temp.addAll(all);
                all = temp;
                all.add(ml);
            }
            listeners.put(guid, Collections.unmodifiableList(all));
            this._messageListeners = Collections.unmodifiableMap(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMessageListener(byte[] guid, MessageListener ml) {
        boolean removed = false;
        Object object = this.MESSAGE_LISTENER_LOCK;
        synchronized (object) {
            List<MessageListener> all = this._messageListeners.get(guid);
            if (all != null && (all = new ArrayList<MessageListener>(all)).remove(ml)) {
                removed = true;
                TreeMap<byte[], List<MessageListener>> listeners = new TreeMap<byte[], List<MessageListener>>(GUID.GUID_BYTE_COMPARATOR);
                listeners.putAll(this._messageListeners);
                if (all.isEmpty()) {
                    listeners.remove(guid);
                } else {
                    listeners.put(guid, Collections.unmodifiableList(all));
                }
                this._messageListeners = Collections.unmodifiableMap(listeners);
            }
        }
        if (removed) {
            ml.unregistered(guid);
        }
    }

    private void handleHeadPing(HeadPing ping, ReplyHandler handler) {
        if (DownloadSettings.DROP_HEADPINGS.getValue()) {
            return;
        }
        GUID clientGUID = ping.getClientGuid();
        ReplyHandler pingee = clientGUID != null ? this.getPushHandler(clientGUID.bytes()) : this.forMeReplyHandler;
        if (pingee == null) {
            return;
        }
        if (pingee instanceof ForMeReplyHandler) {
            HeadPong pong = this.headPongFactory.create(ping);
            handler.reply(pong);
        } else {
            this._headPongRouteTable.routeReply(ping.getGUID(), handler);
            if (!(handler instanceof Connection) || ((Connection)((Object)handler)).getConnectionCapabilities().supportsVMRouting()) {
                pingee.reply(ping);
            } else {
                pingee.reply(new HeadPing(ping));
            }
        }
    }

    Map<byte[], List<MessageListener>> getMessageListenerMap() {
        return this._messageListeners;
    }

    private void handleHeadPong(HeadPong pong, ReplyHandler handler) {
        ReplyHandler forwardTo = this._headPongRouteTable.getReplyHandler(pong.getGUID());
        if (forwardTo != null && !(forwardTo instanceof ForMeReplyHandler)) {
            forwardTo.reply(pong);
            this._headPongRouteTable.removeReplyHandler(forwardTo);
        }
    }

    private void handleDHTContactsMessage(DHTContactsMessage msg, ReplyHandler handler) {
        this.dhtManager.handleDHTContactsMessage(msg);
    }

    @Override
    public void forwardInspectionRequestToLeaves(InspectionRequest ir) {
        if (!this.connectionManager.isSupernode()) {
            return;
        }
        if (ir.getReturnAddress() == null) {
            return;
        }
        for (RoutedConnection mc : this.connectionManager.getInitializedClientConnections()) {
            if (mc.getConnectionCapabilities().remoteHostSupportsInspections() < ir.getVersion()) continue;
            mc.send(ir);
        }
    }

    RouteTable getPushRouteTable() {
        return this._pushRouteTable;
    }

    RouteTable getHeadPongRouteTable() {
        return this._headPongRouteTable;
    }

    @Override
    public long getOOBExpireTime() {
        return 120000L;
    }

    private class ConnectionListener
    implements ConnectionLifecycleListener {
        private ConnectionListener() {
        }

        @Override
        public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
            if (evt.isConnectionClosedEvent()) {
                MessageRouterImpl.this.removeConnection(evt.getConnection());
            }
        }
    }

    private static class DuplicateQueryCounter
    implements Inspectable {
        private final Buffer<Long> duplicateTimes = new Buffer(100);
        private final Buffer<Byte> duplicateHops = new Buffer(100);
        private final Buffer<Byte> duplicateTTLs = new Buffer(100);
        private long totalDropped;
        private final Buffer<GUID> lastNGUIDs = new Buffer(100);
        private final Map<GUID, Integer> counts = new HashMap<GUID, Integer>();
        private int highestEver;

        private DuplicateQueryCounter() {
        }

        public synchronized void duplicateQuery(QueryRequest r) {
            ++this.totalDropped;
            if (!LimeWireUtils.isBetaRelease()) {
                return;
            }
            this.duplicateTimes.add(System.currentTimeMillis());
            this.duplicateHops.add(r.getHops());
            this.duplicateTTLs.add(r.getTTL());
            GUID g = new GUID(r.getGUID());
            Integer num = this.counts.get(g);
            if (num != null) {
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
                this.highestEver = Math.max(this.highestEver, num);
                this.counts.put(g, num);
                return;
            }
            num = 1;
            this.counts.put(g, num);
            GUID ejected = this.lastNGUIDs.add(g);
            if (ejected != null) {
                this.counts.remove(ejected);
            }
        }

        @Override
        public synchronized Object inspect() {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("total", this.totalDropped);
            ret.put("highest", this.highestEver);
            byte[] ttlsByte = new byte[this.duplicateTTLs.getSize()];
            for (int i = 0; i < this.duplicateTTLs.getSize(); ++i) {
                ttlsByte[i] = this.duplicateTTLs.get(i);
            }
            byte[] hopsByte = new byte[this.duplicateHops.getSize()];
            for (int i = 0; i < this.duplicateHops.getSize(); ++i) {
                hopsByte[i] = this.duplicateHops.get(i);
            }
            byte[] timesByte = new byte[this.duplicateTimes.getSize() * 8];
            for (int i = 0; i < this.duplicateTimes.getSize(); ++i) {
                ByteUtils.long2beb(this.duplicateTimes.get(i), timesByte, i * 8);
            }
            ret.put("ttls", ttlsByte);
            ret.put("hops", hopsByte);
            ret.put("times", timesByte);
            ret.put("hist", new HashMap<GUID, Integer>(this.counts));
            return ret;
        }
    }

    private static class LastHopCounter
    implements Inspectable {
        private final Map<Byte, InspectionHistogram<Integer>> lastHopRouted = new HashMap<Byte, InspectionHistogram<Integer>>();

        private LastHopCounter() {
        }

        @Override
        public synchronized Object inspect() {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            for (byte b : this.lastHopRouted.keySet()) {
                ret.put(String.valueOf(b), this.lastHopRouted.get(b).inspect());
            }
            return ret;
        }

        public synchronized void countMessage(byte hops, int connections) {
            InspectionHistogram<Integer> histogram = this.lastHopRouted.get(hops);
            if (histogram == null) {
                histogram = new InspectionHistogram();
                this.lastHopRouted.put(hops, histogram);
            }
            histogram.count(connections);
        }
    }

    private static class DroppedReplyCounter
    implements Inspectable {
        private final Buffer<Short> tooManyResults = new Buffer(50);
        private final Buffer<Byte> ttls = new Buffer(50);
        private final Buffer<Integer> bytesRouted = new Buffer(50);
        private long totalDropped;
        private long droppedTTL0;

        private DroppedReplyCounter() {
        }

        @Override
        public synchronized Object inspect() {
            byte[] tooManyResultsByte = new byte[this.tooManyResults.getSize() * 2];
            for (int i = 0; i < this.tooManyResults.getSize(); ++i) {
                ByteUtils.short2beb(this.tooManyResults.get(i), tooManyResultsByte, i * 2);
            }
            byte[] ttlsByte = new byte[this.ttls.getSize()];
            for (int i = 0; i < this.ttls.getSize(); ++i) {
                ttlsByte[i] = this.ttls.get(i);
            }
            byte[] bytesRoutedByte = new byte[this.bytesRouted.getSize() * 4];
            for (int i = 0; i < this.bytesRouted.getSize(); ++i) {
                ByteUtils.int2beb((int)this.bytesRouted.get(i), bytesRoutedByte, i * 4);
            }
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("tooMany", tooManyResultsByte);
            ret.put("ttls", ttlsByte);
            ret.put("bytes", bytesRoutedByte);
            ret.put("total", this.totalDropped);
            ret.put("ttl0", this.droppedTTL0);
            return ret;
        }

        public synchronized void tooManyResults(short numResults) {
            if (!LimeWireUtils.isBetaRelease()) {
                return;
            }
            ++this.totalDropped;
            this.tooManyResults.add(numResults);
        }

        public synchronized void ttlByteDrop(byte ttl, int bytes) {
            if (!LimeWireUtils.isBetaRelease()) {
                return;
            }
            ++this.totalDropped;
            this.ttls.add(ttl);
            this.bytesRouted.add(bytes);
        }

        public synchronized void dropTTL0() {
            ++this.totalDropped;
            ++this.droppedTTL0;
        }
    }

    private class GUIDTracker
    implements Inspectable,
    MessageListener,
    SettingListener {
        private final List<Map<String, Object>> l = Collections.synchronizedList(new ArrayList());
        private volatile long start;
        private volatile byte[] lastGuid;

        public GUIDTracker() {
            MessageSettings.TRACKING_GUID.addSettingListener(this);
        }

        @Override
        public Object inspect() {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("start", this.start);
            if (this.lastGuid != null) {
                ret.put("guid", Base32.encode(this.lastGuid));
            }
            ret.put("messages", this.l);
            return ret;
        }

        @Override
        public void processMessage(Message m, ReplyHandler handler) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("ver", 1);
            data.put("time", System.currentTimeMillis());
            data.put("source", handler.getInetAddress() + ":" + handler.getPort());
            data.put("type", m.getClass().getName());
            data.put("hops", m.getHops());
            data.put("ttl", m.getTTL());
            data.put("net", (Object)m.getNetwork());
            data.put("len", m.getLength());
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                m.writeQuickly(baos);
                data.put("pay", baos.toByteArray());
            }
            catch (IOException impossible) {
                // empty catch block
            }
            this.l.add(data);
        }

        @Override
        public void registered(final byte[] guid) {
            this.start = System.currentTimeMillis();
            this.lastGuid = guid;
            MessageRouterImpl.this.backgroundExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    byte[] last = GUIDTracker.this.lastGuid;
                    if (last != null && Arrays.equals(guid, last)) {
                        MessageRouterImpl.this.unregisterMessageListener(guid, GUIDTracker.this);
                    }
                }
            }, 600L, TimeUnit.SECONDS);
        }

        @Override
        public void unregistered(byte[] guid) {
            this.start = 0L;
            this.lastGuid = null;
            this.l.clear();
        }

        @Override
        public void settingChanged(SettingEvent evt) {
            String newGuid;
            if (evt.getEventType() != SettingEvent.EventType.VALUE_CHANGED || evt.getSetting() != MessageSettings.TRACKING_GUID) {
                return;
            }
            byte[] last = this.lastGuid;
            if (last != null) {
                MessageRouterImpl.this.unregisterMessageListener(last, this);
            }
            if ((newGuid = MessageSettings.TRACKING_GUID.get()).length() == 0) {
                return;
            }
            byte[] guid = Base32.decode(newGuid);
            MessageRouterImpl.this.registerMessageListener(guid, this);
        }
    }

    public class UDPQueryReplyHandler
    implements MessageHandler {
        private final OOBHandler oobHandler;

        public UDPQueryReplyHandler(OOBHandler oobHandler) {
            this.oobHandler = oobHandler;
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            QueryReply reply = (QueryReply)msg;
            if (reply.isReplyToMulticastQuery() || MessageRouterImpl.this.isHostUnicastQueried(new GUID(reply.getGUID()), handler)) {
                MessageRouterImpl.this.handleQueryReply(reply, handler);
            } else {
                this.oobHandler.handleMessage(msg, addr, handler);
            }
        }
    }

    public class MulticastPingReplyHandler
    implements MessageHandler {
        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUDPPingReply((PingReply)msg, handler, addr.getAddress(), addr.getPort());
        }
    }

    public class MulticastPingRequestHandler
    implements MessageHandler {
        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUDPPingRequestPossibleDuplicate((PingRequest)msg, handler, addr);
        }
    }

    public class MulticastQueryReplyHandler
    implements MessageHandler {
        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleQueryReply((QueryReply)msg, handler);
        }
    }

    public class MulticastQueryRequestHandler
    implements MessageHandler {
        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)msg, handler);
        }
    }

    private class UDPContentResponseHandler
    implements MessageHandler {
        private UDPContentResponseHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleContentResponse((ContentResponse)msg, handler);
        }
    }

    private class UDPUpdateRequestHandler
    implements MessageHandler {
        private UDPUpdateRequestHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUpdateRequest((UpdateRequest)msg, handler);
        }
    }

    private class UDPHeadPingHandler
    implements MessageHandler {
        private UDPHeadPingHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleHeadPing((HeadPing)msg, handler);
        }
    }

    private class UDPPingReplyHandler
    implements MessageHandler {
        private UDPPingReplyHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUDPPingReply((PingReply)msg, handler, addr.getAddress(), addr.getPort());
        }
    }

    private class UDPPingRequestHandler
    implements MessageHandler {
        private UDPPingRequestHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUDPPingRequestPossibleDuplicate((PingRequest)msg, handler, addr);
        }
    }

    private class UDPQueryRequestHandler
    implements MessageHandler {
        private UDPQueryRequestHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            int port;
            InetAddress address = addr.getAddress();
            if (MessageRouterImpl.this.hasValidQueryKey(address, port = addr.getPort(), (QueryRequest)msg)) {
                MessageRouterImpl.this.sendAcknowledgement(addr, msg.getGUID());
                MessageRouterImpl.this.handleUDPQueryRequestPossibleDuplicate((QueryRequest)msg, handler);
            }
        }
    }

    public static class VendorMessageHandler
    implements MessageHandler {
        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            Connection c = (Connection)((Object)handler);
            c.handleVendorMessage((VendorMessage)msg);
        }
    }

    private class DHTContactsMessageHandler
    implements MessageHandler {
        private DHTContactsMessageHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleDHTContactsMessage((DHTContactsMessage)msg, handler);
        }
    }

    private class HeadPongHandler
    implements MessageHandler {
        private HeadPongHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleHeadPong((HeadPong)msg, handler);
        }
    }

    private class UpdateResponseHandler
    implements MessageHandler {
        private UpdateResponseHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUpdateResponse((UpdateResponse)msg, handler);
        }
    }

    private class UpdateRequestHandler
    implements MessageHandler {
        private UpdateRequestHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUpdateRequest((UpdateRequest)msg, handler);
        }
    }

    private class SimppVMHandler
    implements MessageHandler {
        private SimppVMHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleSimppVM((SimppVM)msg, handler);
        }
    }

    private class HeadPingHandler
    implements MessageHandler {
        private HeadPingHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleHeadPing((HeadPing)msg, handler);
        }
    }

    private class QueryStatusResponseHandler
    implements MessageHandler {
        private QueryStatusResponseHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleQueryStatus((QueryStatusResponse)msg, (RoutedConnection)handler);
        }
    }

    private class PushProxyRequestHandler
    implements MessageHandler {
        private PushProxyRequestHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handlePushProxyRequest((PushProxyRequest)msg, (RoutedConnection)handler);
        }
    }

    private class UDPConnectBackRedirectHandler
    implements MessageHandler {
        private UDPConnectBackRedirectHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUDPConnectBackRedirect((UDPConnectBackRedirect)msg, (RoutedConnection)handler);
        }
    }

    private class TCPConnectBackRedirectHandler
    implements MessageHandler {
        private TCPConnectBackRedirectHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleTCPConnectBackRedirect((TCPConnectBackRedirect)msg, (RoutedConnection)handler);
        }
    }

    private class UDPConnectBackHandler
    implements MessageHandler {
        private UDPConnectBackHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleUDPConnectBackRequest((UDPConnectBackVendorMessage)msg, (RoutedConnection)handler);
        }
    }

    private class TCPConnectBackHandler
    implements MessageHandler {
        private TCPConnectBackHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleTCPConnectBackRequest((TCPConnectBackVendorMessage)msg, (RoutedConnection)handler);
        }
    }

    private class PatchTableHandler
    implements MessageHandler {
        private PatchTableHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handlePatchTableMessage((PatchTableMessage)msg, (RoutedConnection)handler);
        }
    }

    private class ResetTableHandler
    implements MessageHandler {
        private ResetTableHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleResetTableMessage((ResetTableMessage)msg, (RoutedConnection)handler);
        }
    }

    private class QueryReplyHandler
    implements MessageHandler {
        private QueryReplyHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            QueryReply qmsg = (QueryReply)msg;
            MessageRouterImpl.this.handleQueryReply(qmsg, handler);
        }
    }

    private class QueryRequestHandler
    implements MessageHandler {
        private QueryRequestHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handleQueryRequestPossibleDuplicate((QueryRequest)msg, (RoutedConnection)handler);
        }
    }

    private class PingReplyHandler
    implements MessageHandler {
        private PingReplyHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handlePingReply((PingReply)msg, handler);
        }
    }

    private class PingRequestHandler
    implements MessageHandler {
        private PingRequestHandler() {
        }

        @Override
        public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
            MessageRouterImpl.this.handlePingRequestPossibleDuplicate((PingRequest)msg, handler);
        }
    }

    private static class HopsFlowManager
    implements Runnable {
        private final UploadManager uploadManager;
        private final ConnectionManager connectionManager;
        private static final byte BUSY_HOPS_FLOW = 0;
        private static final byte FREE_HOPS_FLOW = 5;
        @InspectablePrimitive(value="last upload slot busy state")
        private static boolean _oldBusyState = false;

        public HopsFlowManager(UploadManager uploadManager, ConnectionManager connectionManager) {
            this.uploadManager = uploadManager;
            this.connectionManager = connectionManager;
        }

        @Override
        public void run() {
            if (this.connectionManager.isSupernode()) {
                return;
            }
            boolean isBusy = !this.uploadManager.mayBeServiceable();
            List<RoutedConnection> connections = this.connectionManager.getInitializedConnections();
            HopsFlowVendorMessage hops = new HopsFlowVendorMessage(isBusy ? (byte)0 : 5);
            if (isBusy == _oldBusyState) {
                for (RoutedConnection c : connections) {
                    if (c == null || !((double)c.getConnectionTime() + 18750.0 > (double)System.currentTimeMillis()) || !c.getConnectionCapabilities().isClientSupernodeConnection()) continue;
                    c.send(hops);
                }
            } else {
                _oldBusyState = isBusy;
                for (RoutedConnection c : connections) {
                    if (c == null || !c.getConnectionCapabilities().isClientSupernodeConnection()) continue;
                    c.send(hops);
                }
            }
        }
    }

    static class ConnectBackExpirer
    implements Runnable {
        ConnectBackExpirer() {
        }

        @Override
        public void run() {
            _tcpConnectBacks.clear();
            _udpConnectBacks.clear();
        }
    }

    private class UDPReplyCleaner
    implements Runnable {
        private UDPReplyCleaner() {
        }

        @Override
        public void run() {
            MessageRouterImpl.this.messageDispatcher.get().dispatch(new Runnable(){

                @Override
                public void run() {
                    MessageRouterImpl.this.udpReplyHandlerCache.clear();
                }
            });
        }
    }

    private class QRPPropagator
    extends ManagedThread {
        public QRPPropagator() {
            this.setName("QRPPropagator");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    MessageRouterImpl.this.forwardQueryRouteTables();
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
                return;
            }
        }
    }
}

