/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "layersetupbutton.h"
#include "general/layers.h"
#include <qpixmap.h>
#include <qpainter.h>
#include <qimage.h>
#include <qbitmap.h>

layersetupbutton::layersetupbutton(int style, QWidget *parrent)
 : QToolButton(parrent)
{
brushStyle=style;
QImage image(16,16,QImage::Format_RGB32);
pixmap=new QPixmap(16,16);
*pixmap=QPixmap::fromImage(image);
changesetup();
connect(this,SIGNAL(clicked()),this,SLOT(clicked2()));
}


layersetupbutton::~layersetupbutton()
{
}

void layersetupbutton::clicked2(){
emit pressed2(brushStyle);
}


void layersetupbutton::changesetup(){
 QBrush brush=layer::getBrush(brushStyle);
 QColor c=qRgb(22,28,120);
 if (brushStyle>=10) c=qRgb(140,40,36);
 if (brushStyle>=20) c=qRgb(23,122,29);
 if (brushStyle>=30) c=qRgb(214,168,0);
 pixmap->fill(qRgb(200,200,200));
 QPixmap alpha=QPixmap(16,16);
 alpha.fill(qRgb(0,0,0));
 pixmap->setAlphaChannel(alpha);
 QPainter paint(pixmap);
 QBrush b=layer::getBrush(brushStyle);
 b.setColor(c);
 //QBrush(qRgb(255,0,0),brush);
 QPen p=QPen(c);
 paint.setPen(p);
 paint.setBrush(b);
 paint.drawRect(2,2,13,13);
 paint.end();
/*pixmap->fill(qRgb(0,0,0));
QPainter paint(pixmap);
QBrush b=QBrush(qRgb(255,0,0),brush);
QPen p=QPen(qRgb(255,0,0));
paint.setPen(p);
paint.setBrush(b);
paint.drawRect(2,2,13,13);
QBitmap bit(16,16);
bit.fill(qRgb(0,0,0));
QPainter paint2(&bit);
QPen pen;
pen.setColor(qRgb(255,255,255));
paint2.setPen(pen);
b.setColor(qRgb(255,255,255));
paint2.setBrush(b);
paint2.drawRect(2,2,13,13);
pixmap->setMask(bit);*/
setIcon(QIcon(*pixmap));
repaint();
}

void layersetupbutton::enterEvent (QEvent *) 

{

   update();
}

void layersetupbutton::leaveEvent(QEvent *)
{

   update();
}
