/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "general/drawingfield.h"

#include "3d/view3dmodule.h"




void macro::view3dModuleHandler_registerKeywords(keywords **keyword_){
  *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="view3dModule";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::view3dModuleHandler_typeHandler;
}

void macro::view3dModuleHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrView3dModule,ptrView3dModule,single);
}

returnValue macro::view3dModuleHandler_classHandler(int *counter, keywords *keyword_,returnValue *r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrView3dModule){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else throw 1;
 view3dModule *d= r->getView3dModule();
 p=next(counter);
 if (((p.type==keyword)&&(p.value=="daghkjhta"))) {	
		/*returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&d->data;
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;*/}
 else if (((p.type==keyword)&&(p.value=="trigger3dRenderAll"))) { testParenOpen(counter);
	testParenClose(counter);
	d->trigger3dRenderAll();}
 else if (((p.type==keyword)&&(p.value=="trigger3dRenderSelect"))) { testParenOpen(counter);
	testParenClose(counter);
	d->trigger3dRenderSelect();}
 else if (((p.type==keyword)&&(p.value=="trigger3dRenderAuto"))) { testParenOpen(counter);
	testParenClose(counter);
	d->trigger3dRenderAuto();}
 else if (((p.type==keyword)&&(p.value=="trigger3dRenderModel"))) { testParenOpen(counter);
	testParenClose(counter);
	d->trigger3dRenderModel();}
 else if (((p.type==keyword)&&(p.value=="clearModel"))) { testParenOpen(counter);
	testParenClose(counter);
	d->clearModel();}
 else if (((p.type==keyword)&&(p.value=="blockToModel"))) { testParenOpen(counter);
	returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);testComma(counter);
	returnValue p4=calculate(counter,keyword_);
	testParenClose(counter);
	d->blockToModel(p1.getInt(),p2.getInt(),p3.getInt(),p4.getInt());}
 else if (((p.type==keyword)&&(p.value=="topRoundedBlockToModel"))) { testParenOpen(counter);
	returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);testComma(counter);
	returnValue p4=calculate(counter,keyword_);testComma(counter);
	returnValue p5=calculate(counter,keyword_);
	testParenClose(counter);
	d->topRoundedBlockToModel(p1.getInt(),p2.getInt(),p3.getInt(),p4.getInt(),p5.getInt());}
 else if (((p.type==keyword)&&(p.value=="bottomRoundedBlockToModel"))) { testParenOpen(counter);
	returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);testComma(counter);
	returnValue p4=calculate(counter,keyword_);testComma(counter);
	returnValue p5=calculate(counter,keyword_);
	testParenClose(counter);
	d->bottomRoundedBlockToModel(p1.getInt(),p2.getInt(),p3.getInt(),p4.getInt(),p5.getInt());}
 else if (((p.type==keyword)&&(p.value=="slantBlockToModel"))) { testParenOpen(counter);
	returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);testComma(counter);
	returnValue p4=calculate(counter,keyword_);testComma(counter);
	returnValue p5=calculate(counter,keyword_);testComma(counter);
	returnValue p6=calculate(counter,keyword_);
	testParenClose(counter);
	d->slantBlockToModel(p1.getInt(),p2.getInt(),p3.getInt(),p4.getInt(),p5.getInt(),p6.getInt());}
 else {
  	error->addItem(tr("Class view3dmodul has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}




