/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "lastopen.h"
#include <QSettings>
#include "widgets/mainwindow.h"
#include <QFileInfo>
#include "defines.h"
#include "guiworkthread.h"
#include "general/setup.h"

lastOpen::lastOpen(QMenu *menu,mainWindow *layout_,int offset)
{
  l=layout_;
  offSet=offset;
  fileMenu=menu;
   for (int i=1;i<10;i++){
	item[i]=new lastOpenItem(layout_);
	QString s;
	s.setNum(i);
	if (setup::showMenuIcons)
        	item[i]->action=fileMenu->addAction(QIcon(":/layoutIcon"),s,item[i], SLOT( open() ),0);
	else
		item[i]->action=fileMenu->addAction(s,item[i], SLOT( open() ),0);
	connect(item[i],SIGNAL(openFile(QString)),l,SLOT(open(QString)));
	}
   readSetting();
   setTitle();
}


lastOpen::~lastOpen()
{
   for (int i=1;i<10;i++){
	delete item[i];
	}
}

void lastOpen::update(){
   readSetting();
   setTitle();
}

void lastOpen::add(QString file){
   QString help=file;
   int i=1;
   bool end=true;
   while ((i<10) && (end)){
	if (item[i]->path==file) end=false;
	QString help2=item[i]->path;
	item[i]->path=help;
	help=help2;
	i++;
	}
   writeSetting();
   setTitle();
}

void lastOpen::setTitle(){
   for (int i=1;i<10;i++){
	QFileInfo f(item[i]->path);
	QString s=f.fileName();
	if (!s.isEmpty()) {
		#ifdef OPENACCESS
		if (s.right(3)==".oa"){
		      QString fileName=item[i]->path;
		      int i=fileName.lastIndexOf("/");
		      QString path,view,library,cell;   
		      if (i>0) {
			fileName=fileName.left(i);
		      }
		      i=fileName.lastIndexOf("/");
		      if (i>0) {
			view=fileName.mid(i+1);
			fileName=fileName.left(i);
		      }
		      i=fileName.lastIndexOf("/");
		      if (i>0) {
			cell=fileName.mid(i+1);
			path=fileName.left(i);
		      }   
		      i=path.lastIndexOf("/");
		      if (i>0) {
		      library=path.mid(i+1);
		      }   
		      s=cell+"("+library+"/"+view+")";
		}
		#endif
		QString s1;
		s1.setNum(i);
		s=s1+" "+s;
		item[i]->action->setVisible(true);
		item[i]->action->setText(s);
		}
	else {
	 item[i]->action->setVisible(false);
	}
	}
}

void lastOpen::readSetting(){
   QSettings se;
   if (!se.contains("lastOpen/1"))
		setup::setOldOrganization();
	
   QSettings s;
   for (int i=1;i<10;i++){
	QString s1;
	s1.setNum(i+offSet);
   	item[i]->path=s.value("lastOpen/"+s1,"").toString();
   }
   setup::setOrganization();
}

  

void lastOpen::writeSetting(){
   QSettings s;
   for (int i=1;i<10;i++){
	QString s1;
	s1.setNum(i+offSet);
	s.setValue("lastOpen/"+s1,item[i]->path);
   }
}


void lastOpenItem::open()
{
/*#ifndef multithread
  if (l->drawing->mutexChangeGuiTryLock()) {
  emit openFile(path);
  l->drawing->mutexChangeUnlock();
  l->cellsUpdate();
  l->drawing->paint();
  }
#else
  l->workThread->startOperation("open",path);
#endif*/
emit openFile(path);
}

