/***************************************************************************
 *   Copyright (C) 2009 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#ifndef ODB_H
#define ODB_H
#include "general/layers.h"
#include <qobject.h>
#include <QTextStream>
#include "general/errorreport.h"
#include "filegeneral.h"

/**
@author Juergen Thies
*/
class drawingField;
class QString;
class odb : public QObject
{
Q_OBJECT
public:
    odb(QObject *parent = 0, const char *name = 0);

    ~odb();
  static void open(QString filename,drawingField *);
 
  static void import(QString filename,drawingField *);
  static void update(QString filename,drawingField *);
  static void save(QString filename,drawingField *);
  errorreport report;
  errorreport *reportSave;
  void writePointArray(pointArray pa);
  void writePoint(QPoint);
  int saveLayer;
  int getSymbolCircle(int width);
  int getSymbolRect(int width);
  QTextStream *stream;
private:
  void save(QTextStream *streamPtr,drawingField *, errorreport *error,int layer);
  
  void load(QString filename,drawingField *,  fileOpenType type);

  QStringList symbols;
  int searchSymbol(QString s);
  static QString convert(QString s);
  double scale;
  int getPos(QString s,double scale);
};

#endif
