/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILEDIALOG_H
#define FILEDIALOG_H

#include <qobject.h>
#include <qstring.h>

/**
@author Juergen Thies
*/
class filedialog : public QObject
{
Q_OBJECT
public:
    filedialog(QObject *parent = 0, const char *name = 0);

    ~filedialog();
static QString getOpenFileName();
static QString getSaveFileName();
static QString getFileType(QString s);
static QString getLastPath();
static void setLastPath(QString s);
static QString extension(QString s);
private:
static QString gdsFilter;
static QString dxfFilter;
static QString oasisFilter;
static QString cifFilter;
static QString svgFilter;
static QString csvFilter;
static QString lefFilter;
static QString defFilter;
static QString odbFilter;
static QString psFilter;
static QString epsFilter;
static QString sourceFilter;
static QString gerberMacroFilter;
static QString layoutBundleFilter;
static QString oaFilter;
static QString electromaskFilter;
static QStringList pixelFilter;
static bool gdsExtension(QString s);
static bool dxfExtension(QString s);
static bool oasisExtension(QString s);
static bool cifExtension(QString s);
static bool svgExtension(QString s);
static bool apExtension(QString s);
static bool tldExtension(QString s);
static bool lefExtension(QString s);
static bool defExtension(QString s);
static bool csvExtension(QString s);
static bool sourceExtension(QString s);
static bool odbExtension(QString s);
static bool psExtension(QString s);
static bool epsExtension(QString s);
static bool gerberExtension(QString s);
static bool gerberMacroExtension(QString s);
static bool layoutBundleExtension(QString s);
static bool pixelExtension(QString s);
static bool oaExtension(QString s);
static bool electromaskExtension(QString s);
static bool macroExtension(QString s);
static QString lastPath;
static void setPixelFilter();
};

#endif
