/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef POINTARRAY_H
#define POINTARRAY_H

#include <qpolygon.h>
#include "strans.h"

/**
@author Juergen Thies
*/
//! pointarray
/*!
A array of points.
*/
class pointArray : public QPolygon
{
public:
//! pointArray
/*!
Creates a empty array of points
@nomacro
*/ 
    pointArray();
//! pointArray
/*!
Creates a array of points with a number of size points
@nomacro
*/ 
    pointArray(int size){resize(size);}
    ~pointArray();
//! set xy
/*!
Set the x and y coordinates on Index i.
*/
void set(int i, int x, int y){setPoint(i,x,y);}
//! set point
/*!
Set the point to index i.
@nomacro
*/
//-void setPoint(int i,point p);
//! get point
/*!
@return point point at index i.
*/
//-QPoint point(int i);
//! size
/*!
@return size size of pointArray
*/
//-int size();
//! resize
/*!
Resize the array of points.
*/
    void resize(int size);
    bool add(pointArray *array);
    pointArray cut(uint pos);
    void move(QPoint pos);
    void map(strans m);
    void clean();
    void cleanSimple();
	void cleanUnneeded();
    void deletePoint(uint pos);
    void addPoint(uint pos);
//! attachPoint
/*!
Add the point p to the end of the pointArray
*/
    void attachPoint(QPoint p);
//! flip
/*!
Turns around the order of points
*/
    void flip();
//! insert
/*!
Inserts the point p at the position p
*/
    void insert(uint i, QPoint p);
    QList<pointArray> seperate();
    double angle();
    double area();
    double length();
    void sizeAdjust(int value);
    void sizeAdjust(int valueX,int valueY);
    void modifyCorners(double value1,double value2);
    QList<pointArray> triangulate();
    pointArray cutPoints(QPoint p1,QPoint p2);
    int minSize();
    int maxX(){
	int i=1;
	int xmax;
	xmax=point(i).x();
	for (i=1;i<size();i++){
		if (point(i).x()>xmax) xmax=point(i).x();
	}
	return xmax;
	};
    QRect dimension();
    bool identical(const pointArray &pa);
    void lineDistance(QPoint p1,QPoint p2, int *left,int *right);
    inline pointArray &operator=(const pointArray &pa){
		resize(pa.size());
		putPoints(0,pa.size(),pa);
		return *this;}
   pointArray operator* ( double d ) const;
};

class triangulation
{
public:

  // triangulate a contour/polygon, places results in STL vector
  // as series of triangles.
  static bool process(pointArray contour,
                      QList<pointArray> *result);

  
  // decide if point p4 is inside triangle defined by
  // p1, p2, p3
  static bool insideTriangle(QPoint p1, QPoint p2,QPoint p3,QPoint p4);
  static bool insideOrOnTriangle(QPoint p1, QPoint p2,QPoint p3,QPoint p4);

private:
  static bool snip(pointArray contour,int u,int v,int w,int n,int *V);

};

#endif
