/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "cellrefproperties.h"
#include <qspinbox.h>
#include <qlineedit.h>
#include "general/userunitsvalidator.h"
#include "general/setup.h"
#include "general/drawingfield.h"
#include <qradiobutton.h>
#include <qstring.h>
#include "cellref.h"
#include <qcheckbox.h>
#include <qvalidator.h>
#include <qpushbutton.h>
#include <qstring.h>
#include "propertyedit.h"

cellrefproperties::cellrefproperties(drawingField *d)
: cellrefpropertiesdialog()
{setupUi(this);
drawing=d;
userunits=d->userunits;
userunitsValidator v(userunits,this);
decimals=v.decimals();
mag->setValidator(new QDoubleValidator(0.000001,1000000000,6,mag));
angle->setValidator(new QDoubleValidator(0,360,3,angle));
orginX->setValidator(new userunitsValidator(userunits,orginX));
orginY->setValidator(new userunitsValidator(userunits,orginY));
connect(mag,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(angle,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(orginX,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(orginY,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(flat,SIGNAL( clicked()),this,SLOT(DoneFlat()));
connect(makeArray,SIGNAL( clicked()),this,SLOT(DoneArray()));
connect(deleteCell,SIGNAL( clicked()),this,SLOT(DoneDeleteCell()));
connect(attributeButton,SIGNAL(clicked()),this,SLOT(showAttributes()));
connect(fullDisplay,SIGNAL( clicked()),this,SLOT(displayAll()));
setModal(true);
}

cellrefproperties::~cellrefproperties()
{
}

/*$SPECIALIZATION$*/
void cellrefproperties::reject()
{
  QDialog::reject();
}

void cellrefproperties::accept()
{
  updateElement();
  QDialog::accept();
}

void cellrefproperties:: updateElement(){
  if (cellname->currentText()!=element->cell_ref->cellName){
		cell *c=drawing->findCell(cellname->currentText());
		if (c!=NULL)element->cell_ref=c;
		}
  //element->cell_ref->cellName=cellname->text();
  strans t;
  t.reset();
  t.scale(mag->text().toDouble());
  t.rotate(-angle->text().toDouble());
  if (mirror_x->isChecked()){t.toggleMirror_x();}
  element->trans=t;
  element->point=QPoint(element::round(orginX->text().toDouble()/userunits),element::round(orginY->text().toDouble()/userunits));
}



void cellrefproperties::setElement(cellref *p){
   element=p;
   cellname->clear();
   QStringList sl=drawing->undependendCells();
   sl.sort();
   cellname->addItems(sl);
   int pos=cellname->findText(p->cell_ref->cellName);
   if (pos>=0) cellname->setCurrentIndex(pos);
   //cellname->setText(p->cell_ref->cellName);
   QString s;
   s.setNum(p->trans.mag,'g',6);
   mag->setText(s);
   s.setNum(p->trans.angle,'g',6);
   angle->setText(s);
   if (p->trans.mirror_x){mirror_x->setChecked(true);}
   else {mirror_x->setChecked(false);}
   s.setNum((double)(p->point.x())*userunits,'f',decimals);
   orginX->setText(s);
   s.setNum((double)(p->point.y())*userunits,'f',decimals);
   orginY->setText(s);
   OK->setFocus();
   if (element->property.size()==0) attributeButton->hide();
   else fullDisplay->hide();
}

 void cellrefproperties::displayAll(){
fullDisplay->hide();
attributeButton->show();
}


void cellrefproperties::checkInput(const QString &){
QString s;
s=mag->text();
bool b=true;
int i=0;
if (mag->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=angle->text();
if (angle->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=orginX->text();
if (orginX->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=orginY->text();
if (orginY->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
OK->setEnabled(b);
}


void cellrefproperties::showAttributes(){
propertyEdit pe(&element->property);
pe.exec();
}

