/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "celllist.h"

cellList::cellList()
{
nextCell=NULL;
thisCell=new cell();
}


cellList::~cellList()
{
if (thisCell!=NULL)delete thisCell;
 thisCell=NULL;
}

bool cellList::useLayer(int i){
 if (thisCell->useLayer(i)) return true;
 if (nextCell!=NULL) return nextCell->useLayer(i);
 return false;
}

void cellList::useLayer(QBitArray *b){
 thisCell->useLayer(b);
 if (nextCell!=NULL) nextCell->useLayer(b);
}

void cellList::useLayerMarked(QBitArray *b){
 if (thisCell->marker) thisCell->useLayer(b);
 if (nextCell!=NULL) nextCell->useLayerMarked(b);
}

bool cellList::hasText(bool *negText){
  bool b=thisCell->hasText(negText);
  if ((b)&&(negText==NULL)) return true;
  if ((b)&&(*negText=true)) return true;
  return nextCell->hasText(negText);
}
