/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BOXPROPERTIES_H
#define BOXPROPERTIES_H

#include "ui_boxpropertiesdialog.h"
#include <qrect.h>
#include <QDialog>
class box;
class userunitsValidator;
class boxproperties : public QDialog, private Ui::boxpropertiesdialog
{
  Q_OBJECT
public:
  box *element;
  
public:
  boxproperties(double userunits);
  ~boxproperties();
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
  void setElement(box *b);
  void setLayerName(int val);
  void updateElement();
  void checkInput(const QString&);
  void check();
  void checkInputWidth(const QString&);
  void checkInputHeight(const QString&);
  void DoneToPolygon(){updateElement();done(3);}
  void DoneDeleteBox(){done(2);}
  void showAttributes();
  void calcCenter();
  void displayAll();
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          reject();
  virtual void          accept();
private:
 bool calcOperation;
 QPoint center;
 userunitsValidator *valid;
 double userunits;
 int decimals;

};

#endif

