/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LAYERSETUPWIDGET2_H
#define LAYERSETUPWIDGET2_H


#include "general/layer.h"
#include "ui_layersetupwidget.h"
#include <QWidget>

class layerSetupWidget2 : public QWidget, private Ui::layerSetupWidget
{
  Q_OBJECT
public:
  layerSetupWidget2(QWidget* parent = 0,int layerNum=0);
  ~layerSetupWidget2();
  /*$PUBLIC_FUNCTIONS$*/

  void setup();
  void save();
public slots:
  void setEnabled();
  void setEnabled(bool);
  void trigEnter();
public:
  int layerNum;
  int brushStyle;
  int level;
  int thickness;
  QString shortKey;
  QColor color;
  QString getLayerName(){ return layerName->text();}; 
  bool isEnable(){ return layerEnable->isChecked();};
  void setMapping(int,int);
  void setName(QString);
  int getMapLayer();
  int getMapDatatype();
  QString getName();
  signals:
    void entered(int);
};

#endif

 
