/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlineedit.h>
#include <qvalidator.h>
#include "drcinside.h"
#include "general/userunitsvalidator.h"
#include "elements/element.h"

drcInside::drcInside(double ,QWidget*)
: drcInsideDialog()
{
setupUi(this);
layerNr1->setMaximum(layersMax-1);
layerNr2->setMaximum(layersMax-1);
layerNr3->setMaximum(layersMax-1);
insideLayer->setMaximum(layersMax-1);
connect(layerNr1,SIGNAL(valueChanged(int)),this,SLOT(setLayerName1(int)));
connect(layerNr2,SIGNAL(valueChanged(int)),this,SLOT(setLayerName2(int)));
connect(layerNr3,SIGNAL(valueChanged(int)),this,SLOT(setLayerName3(int)));
connect(insideLayer,SIGNAL(valueChanged(int)),this,SLOT(setLayerInside(int)));
layerNr1->setValue(1);
layerNr2->setValue(-1);
layerNr3->setValue(-1);
insideLayer->setValue(3);
setModal(true);
}

drcInside::~drcInside()
{
}

void drcInside::setLayerName1(int i){
if (i>=0) layerName1->setText(layers::num[i].name);
}
void drcInside::setLayerName2(int i){
if (i>=0) layerName2->setText(layers::num[i].name);
else layerName2->setText("not used");
}
void drcInside::setLayerName3(int i){
if (i>=0) layerName3->setText(layers::num[i].name);
else layerName3->setText("not used");
}
void drcInside::setLayerInside(int i){
if (i>=0) insideLayerName->setText(layers::num[i].name);
}

/*$SPECIALIZATION$*/
bool drcInside::dialog(double uunits, int *value, int *insideLayer,int *layer1,int *layer2,int *layer3){
   drcInside d(uunits);
   d.insideLayer->setValue(*insideLayer);
    d.show();
    int i=d.exec();
    d.hide();
    switch (i) {
    case QDialog::Rejected :
    	return false;
    case QDialog::Accepted :
	*value=element::runden(d.drcValue->value()/uunits);
	*insideLayer=d.insideLayer->value();
	*layer1=d.layerNr1->value();
	*layer2=d.layerNr2->value();
	*layer3=d.layerNr3->value();
	return true;
   }
  return false;
}


