#ifndef _PROBABILITY_H
#define _PROBABILITY_H

// Arandom number generating class and a class that stores a potentially mutable probability value

#include <iostream>

/* class which provides pseudo-random numbers, with 
  random number generating routine taken from *
* http://www.helsbreth.org/random/unbiased.html       */

using namespace std;

class MyRand {
private:
  static const unsigned long R_MOD=30903; // could also use 18000
public:
  unsigned long S;
  static const unsigned long MAX_RND=0xffff;
  MyRand(unsigned long myseed=1);
  void seed(unsigned long myseed);
  unsigned int integer();
  unsigned int integer(unsigned int i);
  float floatingpoint();
  float Normal(float stdev);
};

class Probability {
private:
	float stdev;
	float p;
	bool stdev_used;
public:
	static MyRand Rand;
	Probability();
	bool  has_stddev();
	float get();
	float get_stdev();
	void  set(float pr);
	void  set_stdev(float s);
	void  init(float pr);
	void  init(float pr, float s);
	void  jitter(float j);	
	void  jitter_stdev(float j_stdev);	
	bool mut(const float &multval=1.0f);
	bool mut(float *ret, const float &multval=1.0f);
	bool mut(int *ret, float multval=1.0f);
	friend ostream& operator<<(ostream &out, Probability &m){
		out << m.p/Probability::Rand.MAX_RND;
		if (m.has_stddev()) 
			out << '(' << m.stdev << ')';
		return out;
};

};

#endif

