#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "Lparse.h"


/* defaults */
#define TRUE  1
#define FALSE 0
#define SUB_RULE_LEN 25 /* max size of the string "+(180.0)&(180.0)>(180.0)" */

#ifdef WIN32
#define rint(X) floor((X)+0.5)
#endif

unsigned long       MEM_STEP=1048576;  /* size of chunks of memory
					  allocated: megabyte-sized 
					  blocks seems reasonable */
static char         MARK_CHAR='@';     /* used to mark partially grown 
					  sections of L string when
					  non-integer recursion levels */
static float        TINY_AMOUNT=0.0001;
static char         TILDE_ADD='#';     /* used to record the number 
					  of recursions undergone
					  by a ~ character */
static char         SUB_CHARS0[]="<&+";
static char         SUB_CHARS1[]=">^-";

unsigned long       MAX_RND=0xffff;


void seed_rand(unsigned long *rand_state, unsigned long seed) {
    *rand_state = seed | 1;   /* Can't seed with 0 */
}

#define R_MOD1 18000 
#define R_MOD2 30903 
/* simple random number generating routine, taken from *
 * http://www.helsbreth.org/random/unbiased.html       */

#define RND_16(S) ((int) (((S) = R_MOD1*((S)&0xffff)+((S)>>16))&0xffff))
#define URND_16(S) ((unsigned int) (((S) = R_MOD2*((S)&0xffff)+((S)>>16))&0xffff))

/* start L parser */
/* this is non-reentrant - i.e. the same memory space is returned each time */


const char *Lparse(float recursion,
	     const char *axiom,
	     const char *rules,
	     float def_tilde_rot, /* set this to a negative value if no tilde substitution required */
	     unsigned long max_length, /* set this to 0 is length unlimited */
	     unsigned long *rand_state)
{
  unsigned long          def_rot, *s, *s_end, *states=NULL, backup=1;
  unsigned long          l, mem_left, longest_rule=SUB_RULE_LEN;
  long                   max_rot, half_max_rnd, rnd_ang;
  register unsigned char ch; 
  register char			 special, *write_ptr; 
  register const char    *read_ptr;
  char                   *new_mem, rots[SUB_RULE_LEN];
  unsigned char          too_big, f1, f10, fractional_recursion=FALSE,
    r,*rule[129],mark[129],
    *is_user_rule = (unsigned char *) calloc(129, sizeof(unsigned char));
  static char            *mem_store[2]={NULL,NULL};
  static size_t          mem_store_size = 0;
  unsigned int           p, max_level, num_rules, fraction;
  size_t                 rule_len[129];
  register size_t        len;
  int                    i;

  if (rand_state==NULL) rand_state=&backup;
  /***********************get rules **********************/
  /* each rule is a single character followed by a sequence of characters ending in \n */
  num_rules=0;
  /* find number of rules */
  read_ptr = rules;
  while ((r = *read_ptr)) {
    if ((r != '\n') && (r != '\0')) {
      num_rules++;
      is_user_rule[r]=TRUE;
      rule[r] = (unsigned char *) ++read_ptr;
      switch (r) {
      case 'F':
      case 'f':
      case 'Z':
      case 'z':
      case 'g':
	mark[r]=FALSE;
	break;
      default:
	mark[r]=TRUE;
      };
      rule_len[r] = strcspn((char *) rule[r], "\n");
      if (rule_len[r] >= longest_rule)
	longest_rule = rule_len[r]+7; /*allow for \0 at end of string and extra @(99) @ characters when fractional recursion is allowed*/
    }
    if ((read_ptr = strchr(read_ptr, '\n'))) {
      read_ptr++;
    } else
      break;
  }

  /********* allocate enough memory for the axiom ********/
  max_length/=2;
  while (mem_store_size <= strlen(axiom)) {
    mem_store_size += MEM_STEP;
    
    if ((max_length != 0) && (mem_store_size > MEM_STEP + max_length)) {
      mem_store_size -= MEM_STEP;
      return NULL;
    };

    /* allocate the mem for mem_store[0] */
    new_mem = (char *) realloc(mem_store[0], mem_store_size);

    /* check that we got it */
    if (new_mem) 
      mem_store[0]=new_mem; 
    else {
      mem_store_size-=MEM_STEP; 
      return NULL;
    };
    
    /* allocate the mem for mem_store[1] */
    new_mem = (char *) realloc(mem_store[1], mem_store_size);

    /* check that we got it */
    if (new_mem) 
      mem_store[1]=new_mem; 
    else { /* this is more difficult, as we have 
	      an unbalanced memory allocation in the array */
      mem_store_size-=MEM_STEP; 
      new_mem = (char *) realloc(mem_store[0], mem_store_size);
      if (new_mem) {
	mem_store[0]=new_mem;
	return NULL;
      } else
	/* we are really buggered: we can't even decrease 
	   the size of the previously allocated memory */
	exit(1);
    };
  } /* end memory allocation */
  mem_left = mem_store_size;       /* Reset memory tracker */


  /************ set up some initial variables etc. *************/
  
  max_level = (int) floor(recursion);
  fraction = (unsigned int) (rint (recursion - max_level)*100);
  if (fraction) {     
    max_level++;
    if (fraction <100) {
      fractional_recursion = TRUE;
      f10=fraction/10;
      f1=fraction%10;
    };
  };

  l=max_level;
  strcpy(mem_store[l&1],axiom);
  too_big = FALSE;

  if (def_tilde_rot >= 0) 
    special = '~';  /*  ~ is special (will be replaced with ~#) */
  else
    special = '\0'; /* nothing is special */

  /************  START PARSING HERE *************/
  write_ptr  = mem_store[1]; // in case l is 0
  while (l--) {
    
    mem_left = mem_store_size;       /* Reset memory tracker */
    write_ptr  = mem_store[l&1];     /* Write to one memory store */
    read_ptr = mem_store[!(l&1)];    /* Read from the other store */

    while ((ch=(unsigned char) *read_ptr)) {   /* Go through each char in the string */
      
      if (mem_left < longest_rule) { /* Potential overflow */
	/****************************************
	 ********** allocate more memory ********
	 ****************************************/
	mem_store_size += MEM_STEP;
	mem_left += MEM_STEP;

	if ((max_length != 0) && (mem_store_size > MEM_STEP+max_length))
	  {
	    mem_store_size -= MEM_STEP;
	    mem_left -= MEM_STEP;
	    too_big = TRUE;
	    l = 0;
	    break;
	  };
	
	/* allocate the mem for mem_store[0] */
	new_mem = (char *) realloc(mem_store[0], mem_store_size);
	if (new_mem) { 	/* success in getting more mem */
	  if (l&1) read_ptr  = new_mem + (read_ptr -mem_store[0]);
	  else     write_ptr = new_mem + (write_ptr-mem_store[0]);
	  mem_store[0]=new_mem;
	} else {
	  mem_store_size-=MEM_STEP; 
	  mem_left -= MEM_STEP;
	  too_big = TRUE;
	  l = 0;
	  break;
	};
	
	/* allocate the mem for mem_store[1] */
	new_mem = (char *) realloc(mem_store[1], mem_store_size);
	if (new_mem) {   /* success */
 	  if (l&1) write_ptr = new_mem + (write_ptr-mem_store[1]);
	  else     read_ptr  = new_mem + (read_ptr -mem_store[1]);
	  mem_store[1]=new_mem; 
	} else { /* this is more difficult, as we have 
		    an unbalanced memory allocation in the array */
	  mem_store_size-=MEM_STEP; 
	  mem_left -= MEM_STEP;
	  new_mem = (char *) realloc(mem_store[0], mem_store_size);
	  if (new_mem) {
	    if (l&1) read_ptr  = new_mem + (read_ptr -mem_store[0]);
	    else     write_ptr = new_mem + (write_ptr-mem_store[0]);
	    mem_store[0]=new_mem;
	    too_big = TRUE;
	    l = 0;
	    break;
	  } else
	    /* we are really buggered: we can't even decrease 
	       the size of the previously allocated memory */
	    exit(1);
	};
      }; /* end memory allocation */
      
      /********* do the actual rule substitution **********/

      if (is_user_rule[ch]) {
	len = rule_len[ch];
	if (fractional_recursion && (l==0)  && mark[ch]) { /* Add mark char */ 
	  mem_left -= (len + 6);
	  *write_ptr = MARK_CHAR;
	  write_ptr++;
	  *write_ptr = '(';
	  write_ptr++;
	  *write_ptr = 48+f10; 	  /* 48 (decimal) is '0' in ascii */
	  write_ptr++;
	  *write_ptr = 48+f1; 	  /* 48 (decimal) is '0' in ascii */
	  write_ptr++;
	  *write_ptr = ')';
	  memcpy(++write_ptr,rule[ch],len);
	  write_ptr += len;
	  *write_ptr = MARK_CHAR;
	  write_ptr++;
	} else {
	  mem_left -= len;
	  memcpy(write_ptr,rule[ch], len);
	  write_ptr += len;
	};
      } else {
	if (ch == special) { 
	  /* add a # character after ~ to track each recursion level */
	  mem_left-=2;
	  *write_ptr = 126;
	  write_ptr++;
	  *write_ptr = TILDE_ADD;
	  write_ptr++;
	} else {
	  mem_left--;
	  *write_ptr = ch;
	  write_ptr++;
	}
      }
      read_ptr++;
    };
    *write_ptr = '\0';
  };

  /* make sure strings are teminated (e.g. for incomplete strings) */
  *write_ptr = '\0';  
  
  read_ptr = mem_store[0]; /* this is where the new string is */
  write_ptr = mem_store[1];

  if (def_tilde_rot>=0) {
  /* if tilde substitution requested, transfer the new string to the 
     other memory store, replacing groups of # signs with appropriate
     calls to <, &, and ^. Fire up new seed values for each recursion level */
    def_rot=(int) (10.0*rint(def_tilde_rot)); /* use integer arithmetic, and degrees to 1 d.p. */
    if (def_rot > 1800) def_rot=1800;
    
    half_max_rnd = MAX_RND/2;
    l=max_level;
    states = (unsigned long *) malloc(sizeof(unsigned long)*l);
    if (states) {
      s_end = states+l-1;
      while(l--)
	*(states+l) = URND_16(*rand_state) + (URND_16(*rand_state)<<16);

      rots[0]='#'; rots[1]='\0'; //******
      
      mem_left = mem_store_size;       /* Reset memory tracker */
      do {   /* Go through each char in the string */
	if (mem_left < SUB_RULE_LEN) { /* Potential overflow */
	  /****************************************
	   ********** allocate more memory ********
	   ****************************************/
	  mem_store_size += MEM_STEP;
	  mem_left += MEM_STEP;
	  
	  if ((max_length != 0) && (mem_store_size > max_length+MEM_STEP)) {
	    mem_store_size -= MEM_STEP;
	    mem_left -= MEM_STEP;
	    too_big = TRUE;
	    break;
	  };
	  
	  /* allocate the mem for mem_store[0] */
	  new_mem = (char *) realloc(mem_store[0], mem_store_size);
	  if (new_mem) { 	/* success in getting more mem */
	    read_ptr  = new_mem + (read_ptr-mem_store[0]);
	    mem_store[0]=new_mem;
	  } else {
	    mem_store_size-=MEM_STEP; 
	    mem_left -= MEM_STEP;
	    too_big = TRUE;
	    break;
	  };
	  
	  /* allocate the mem for mem_store[1] */
	  new_mem = (char *) realloc(mem_store[1], mem_store_size);
	  if (new_mem) {   /* success */
	    write_ptr = new_mem + (write_ptr-mem_store[1]);
	    mem_store[1]=new_mem; 
	  } else { /* this is more difficult, as we have 
		      an unbalanced memory allocation in the array */
	    mem_store_size-=MEM_STEP; 
	    mem_left -= MEM_STEP;
	    new_mem = (char *) realloc(mem_store[0], mem_store_size);
	    if (new_mem) {
	      read_ptr  = new_mem + (read_ptr-mem_store[0]);
	      mem_store[0]=new_mem;
	      too_big = TRUE;
	      break;
	    } else
	      /* we are really buggered: we can't even decrease 
		 the size of the previously allocated memory */
	      exit(1);
	  };
	}; /* end memory allocation */
	
	/* replace ~ with +&< */
	if (*read_ptr==126) {
	  s=s_end;
	  while(*(++read_ptr)==35) /* count the number of # */
	    s--;
	  if(*read_ptr==40) {/* ( */
	    max_rot=abs((int) (10.0 * rint(strtod(read_ptr+1, &new_mem))));
	    read_ptr=new_mem+1; /* skip closing bracket */
	    if (max_rot>1800) max_rot = 1800;
	  } else
	    max_rot=def_rot;
	  /* implement our own printf routine, since the builtin one is *slooow* */
	  i=3;len=0;
	  while(i--) {
	    rnd_ang = ((RND_16(*s) -half_max_rnd) * max_rot) / half_max_rnd; /* rnd_ang should be between -1800 and 1800 */
	    if (rnd_ang > 0) {
	      rots[len++] = SUB_CHARS0[i];
	    } else {
	      rots[len++] = SUB_CHARS1[i];
	      rnd_ang=-rnd_ang;
	    };
	    rots[len++] = 40; /* ( */ 
	    if ((p = rnd_ang/1000)) {   /* 1000s */
	      rots[len++] = 48+p; /* 48 (decimal) is '0' in ascii */
	      rnd_ang-=p*1000;
	    }
	    if ((p = rnd_ang/100)) {    /* 100s */
	      rots[len++] = 48+p;
	      rnd_ang-=p*100;
	    }
	    if ((p = rnd_ang/10)) {     /* 10s */
	      rots[len++] = 48+p; 
	      rnd_ang-=p*10;
	    }
	    rots[len++] = 46; /* . (the decimal point) */
	    rots[len++] = 48+rnd_ang;   /* 1s */
	    rots[len++] = 41; /* ) */
	  };
	  memcpy(write_ptr, rots, len);
	  write_ptr+=len;
	  mem_left-=len;
	} else {
	  *write_ptr=*read_ptr;
	  mem_left--;
	  read_ptr++;
	  write_ptr++;
	};
      } while (read_ptr!='\0');

      if (states) free(states);
      read_ptr = mem_store[1];
    } else
      too_big = TRUE;
  };
  
  
  return read_ptr;
}

