#ifndef _LLINE_H
#define _LLINE_H

#include <string>
#include <iostream>

using namespace std;
class Lline:public string {
 public:
  bool read(const string &main, const string &comm);
  bool read(const string &s);
  void clear();
  Lline() {};
  Lline(const string &main, const string &comm) {read(main, comm);};
  Lline(const string &s) {read(s);};
  ~Lline() {};
  size_t next_atom(size_t pos);
  size_t atom_size(size_t pos);
  size_t clip_to_string(const int position);
  size_t atom_start(const size_t &position);
  size_t bracket_width(const size_t position);
  size_t distance_to_closing(const size_t position, const char open, const char close);
  size_t number_length(size_t position);
  friend ostream& operator<<(ostream& out, Lline& l);
  string comment;

  //statics
  static void remove_surrounding_whitespace(string &in);
  static bool is_param_char(const char c);

  static const string l_chars;
  static const string special_chars;
  static const string param_chars;
 private:
  static bool *param_char_array();
};

class Lrule: public Lline {
 public:
  bool read(const char &N, const string &main, const string &comm);
  bool read(const char &N, const string &s);
  bool read(const string &s);
  void clear();
  Lrule() {};
  Lrule(const char &N, const string &main, const string &comm) {read(N, main, comm);};
  Lrule(const char &N, const string &s) {read(N, s);};
  Lrule(const string &s) {read(s);};
  ~Lrule() {};
  friend ostream& operator<<(ostream& out, Lrule& l);

  char name;
};

#endif
