import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.*;

/**
 * Title:        JAlbum simple image filter blurring images
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */
public class BlurFilter implements JAFilter {

		// Implements JAFilter
    public String getName() {
        return "Sharpen filter";
    }

		// Implements JAFilter
    public String getDescription() {
        return "Blur images";
    }

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
		Graphics2D g = bi.createGraphics();

		Kernel kernel = new Kernel(5, 5,
			new float[] {
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
				1f/25f, 1f/25f, 1f/25f,1f/25f, 1f/25f,
			});

		BufferedImageOp op = new ConvolveOp(kernel, ConvolveOp.EDGE_NO_OP, null);
		bi = op.filter(bi, null);
		return bi;
    }
}
