/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.component.JHeadingPanel;
import se.datadosen.component.JSiteButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.JEditPanel;
import se.datadosen.jalbum.FilterPluginList;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;

public class JFiltersPanel
extends JPanel {
    public static final String NAME = "filtersPanel";
    private static final int FILTERS_LIST_PADDING = 6;
    private static Dimension buttonSize = new Dimension(96, 34);
    private final JEditPanel context;
    private JButton undoButton;
    private JButton redoButton;
    private JFilterListPanel filters;
    private JPanel undoRedoPanel;
    private JHeadingPanel headingPanel;

    public JFiltersPanel(JEditPanel context) {
        super(new BorderLayout());
        this.context = context;
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.headingPanel = new JHeadingPanel(Msg.get("edit.filtersHeading"));
        this.add((Component)this.headingPanel, "North");
        this.filters = new JFilterListPanel();
        JScrollPane filtersScroll = new JScrollPane(this.filters, 20, 31);
        filtersScroll.setBorder(null);
        this.add((Component)filtersScroll, "Center");
        this.undoRedoPanel = new JPanel(new RiverLayout());
        this.undoButton = new JButton(Msg.get("edit.undo"), Icons.getIcon("small.undo"));
        this.undoButton.setToolTipText(Msg.get("edit.undoToolTip"));
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((JFiltersPanel)JFiltersPanel.this).context.filterManager.hasFiltersInList()) {
                    try {
                        JFiltersPanel.this.context.setImageInFilter();
                        ((JFiltersPanel)JFiltersPanel.this).context.filterManager.undo();
                        JFiltersPanel.this.context.saveFilters();
                        JFiltersPanel.this.context.updateImage(false);
                        JFiltersPanel.this.setUndoRedoEnabled(true);
                        JFiltersPanel.this.context.requestFocusInWindow();
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JFiltersPanel.this, ex);
                    }
                }
            }
        });
        this.redoButton = new JButton(Msg.get("edit.redo"), Icons.getIcon("small.redo"));
        this.redoButton.setToolTipText(Msg.get("edit.redoToolTip"));
        this.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((JFiltersPanel)JFiltersPanel.this).context.filterManager.hasFiltersInList()) {
                    try {
                        JFiltersPanel.this.context.setImageInFilter();
                        ((JFiltersPanel)JFiltersPanel.this).context.filterManager.redo();
                        JFiltersPanel.this.context.saveFilters();
                        JFiltersPanel.this.context.updateImage(false);
                        JFiltersPanel.this.setUndoRedoEnabled(true);
                        JFiltersPanel.this.context.requestFocusInWindow();
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JFiltersPanel.this, ex);
                    }
                }
            }
        });
        this.undoRedoPanel.add("br center", this.undoButton);
        this.undoRedoPanel.add(this.redoButton);
        this.add((Component)this.undoRedoPanel, "South");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setUndoRedoEnabled(enabled);
        for (Component component : this.filters.getComponents()) {
            component.setEnabled(enabled);
        }
    }

    void setUndoRedoEnabled(boolean isImage) {
        this.undoButton.setEnabled(isImage && this.context.filterManager.isUndoPossible());
        this.redoButton.setEnabled(isImage && this.context.filterManager.isRedoPossible());
    }

    private class FilterButton
    extends JSiteButton {
        private final String filterName;

        public FilterButton(JFilterListPanel filtersList, String filterName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            this.filterName = filterName;
            JAlbumImageFilter filter = this.getFilter();
            this.setText(filter.getProperties().getShortName());
            this.setIcon(filter.getProperties().getIcon());
            this.setBorderPainted(false);
            this.setBackground(JAlbumColor.darken(SystemColor.control, 18));
            this.setFocusable(false);
            if (filter.getProperties().getDescription() != null && !filter.getProperties().getDescription().equals("")) {
                this.setToolTipText(filter.getProperties().getDescription());
            } else {
                this.setToolTipText(filter.getProperties().getShortName());
            }
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JFiltersPanel.this.context.useFilter(FilterButton.this.getFilter());
                    }
                    catch (InstantiationException ex) {
                        Debug.showErrorDialog(FilterButton.this, ex);
                    }
                    catch (IllegalAccessException ex) {
                        Debug.showErrorDialog(FilterButton.this, ex);
                    }
                    catch (ClassNotFoundException ex) {
                        Debug.showErrorDialog(FilterButton.this, ex);
                    }
                }
            });
        }

        public JAlbumImageFilter getFilter() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            return (JAlbumImageFilter)Class.forName(this.filterName).newInstance();
        }
    }

    private class JFilterListPanel
    extends JPanel {
        public JFilterListPanel() {
            List<String> filters = FilterPluginList.getInstance().getFilterClasses();
            this.setLayout(new RiverLayout(0, 1));
            boolean leftmost = true;
            for (String filterName : filters) {
                try {
                    this.add(leftmost ? "br" : "tab", new FilterButton(this, filterName));
                }
                catch (InstantiationException ex) {
                    Debug.showErrorDialog(this, ex);
                }
                catch (IllegalAccessException ex) {
                    Debug.showErrorDialog(this, ex);
                }
                catch (ClassNotFoundException ex) {
                    Debug.showErrorDialog(this, ex);
                }
                leftmost = !leftmost;
            }
        }
    }
}

