/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JBackgroundPanel
extends JPanel {
    Image bg;
    Border imageBorder;
    private int bx;
    private int by;

    public int getImageTopCornerXCoordinate() {
        return this.bx;
    }

    public int getImageTopCornerYCoordinate() {
        return this.by;
    }

    public void setBackgroundImage(Image bg) {
        this.bg = bg;
    }

    public Image getBackgroundImage() {
        return this.bg;
    }

    public Dimension getPreferredSize() {
        if (this.bg == null) {
            return super.getPreferredSize();
        }
        Dimension sp = super.getPreferredSize();
        int width = this.bg.getWidth(null);
        int height = this.bg.getHeight(null);
        return new Dimension(Math.max(width, sp.width), Math.max(height, sp.height));
    }

    public Dimension getDisplayableImageSize() {
        Dimension size = (Dimension)this.getSize().clone();
        return size;
    }

    public void setImageBorder(Border border) {
        this.imageBorder = border;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bg != null) {
            int iw = this.bg.getWidth(null);
            int ih = this.bg.getHeight(null);
            int cw = this.getWidth();
            int ch = this.getHeight();
            if (this.imageBorder != null) {
                double scale;
                Insets insets = this.imageBorder.getBorderInsets(this);
                int tw = 4 + iw + insets.left + insets.right;
                int th = 4 + ih + insets.top + insets.bottom;
                if (tw > cw) {
                    scale = (double)cw / (double)tw;
                    iw = (int)Math.floor(scale * (double)iw);
                    ih = (int)Math.floor(scale * (double)ih);
                }
                if (th > ch) {
                    scale = (double)ch / (double)th;
                    iw = (int)Math.floor(scale * (double)iw);
                    ih = (int)Math.floor(scale * (double)ih);
                }
            }
            int ix = (cw - iw) / 2;
            int iy = (ch - ih) / 2;
            Insets border = this.getInsets();
            g.drawImage(this.bg, ix += border.left, iy += border.top, iw -= border.left + border.right, ih -= border.top + border.bottom, null);
            if (this.imageBorder != null) {
                Insets insets = this.imageBorder.getBorderInsets(this);
                this.bx = ix - insets.left;
                this.by = iy - insets.top;
                int bw = iw + insets.left + insets.right;
                int bh = ih + insets.top + insets.bottom;
                this.imageBorder.paintBorder(this, g, this.bx, this.by, bw, bh);
            }
        }
    }
}

