/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.sftp;

import com.jcraft.jsch.ChannelSftp;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.sftp.SftpAdapter;
import java.util.Date;
import java.util.StringTokenizer;

public class SftpFile
extends RemoteFile {
    private String line;
    private boolean parsed = false;
    private String permissions;
    private int count;
    private String owner;
    private String group;

    public SftpFile(ChannelSftp.LsEntry entry, SftpAdapter adapter) {
        this.name = adapter.fromUTF8(entry.getFilename());
        this.line = entry.getLongname();
        this.parseUnixLine(this.line);
    }

    private boolean isParsed() {
        return this.parsed;
    }

    private void parseUnixLine(String line) {
        Date d;
        StringTokenizer st = new StringTokenizer(line, " ");
        this.permissions = st.nextToken();
        this.count = Integer.parseInt(st.nextToken());
        this.owner = st.nextToken();
        this.group = st.nextToken();
        this.size = Long.parseLong(st.nextToken());
        StringBuffer date = new StringBuffer();
        date.append(st.nextToken());
        date.append(" ").append(st.nextToken());
        date.append(" ").append(st.nextToken());
        this.creationDate = d = this.parseDate(date.toString());
        this.modificationDate = d;
        this.parsed = true;
    }

    public boolean isFile() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return !this.permissions.startsWith("d");
    }

    public boolean isDirectory() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return this.permissions.startsWith("d");
    }

    public boolean isLink() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return this.permissions.startsWith("l");
    }

    public Date getCreationDate() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return super.getCreationDate();
    }

    public Date getModificationDate() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return super.getModificationDate();
    }

    public long size() {
        if (!this.isParsed()) {
            this.parseUnixLine(this.line);
        }
        return super.size();
    }
}

