/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.exif.CanonMakernoteDirectory;
import com.drew.metadata.exif.CasioType1MakernoteDirectory;
import com.drew.metadata.exif.CasioType2MakernoteDirectory;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.FujifilmMakernoteDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.KodakMakernoteDirectory;
import com.drew.metadata.exif.KyoceraMakernoteDirectory;
import com.drew.metadata.exif.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.OlympusMakernoteDirectory;
import com.drew.metadata.exif.PanasonicMakernoteDirectory;
import com.drew.metadata.exif.PentaxMakernoteDirectory;
import com.drew.metadata.exif.SonyMakernoteDirectory;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;

public class ExifReader
implements MetadataReader {
    private final byte[] _data;
    private boolean _isMotorollaByteOrder;
    private Metadata _metadata;
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_BYTE = 1;
    private static final int FMT_STRING = 2;
    private static final int FMT_USHORT = 3;
    private static final int FMT_ULONG = 4;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SBYTE = 6;
    private static final int FMT_UNDEFINED = 7;
    private static final int FMT_SSHORT = 8;
    private static final int FMT_SLONG = 9;
    private static final int FMT_SRATIONAL = 10;
    private static final int FMT_SINGLE = 11;
    private static final int FMT_DOUBLE = 12;
    public static final int TAG_EXIF_OFFSET = 34665;
    public static final int TAG_INTEROP_OFFSET = 40965;
    public static final int TAG_GPS_INFO_OFFSET = 34853;
    public static final int TAG_MAKER_NOTE = 37500;
    public static final int TIFF_HEADER_START_OFFSET = 6;

    public ExifReader(JpegSegmentData segmentData) {
        this(segmentData.getSegment((byte)-31, 0));
    }

    public ExifReader(File file) throws JpegProcessingException {
        this(new JpegSegmentReader(file).readSegment((byte)-31, 0));
    }

    public ExifReader(InputStream is) throws JpegProcessingException {
        this(new JpegSegmentReader(is).readSegment((byte)-31, 0));
    }

    public ExifReader(byte[] data) {
        this._data = data;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    public Metadata extract(Metadata metadata) {
        this._metadata = metadata;
        if (this._data == null) {
            return this._metadata;
        }
        ExifDirectory directory = (ExifDirectory)this._metadata.getDirectory(ExifDirectory.class);
        if (this._data.length <= 14) {
            directory.addError("Exif data segment must contain at least 14 bytes");
            return this._metadata;
        }
        if (!"Exif\u0000\u0000".equals(new String(this._data, 0, 6))) {
            directory.addError("Exif data segment doesn't begin with 'Exif'");
            return this._metadata;
        }
        String byteOrderIdentifier = new String(this._data, 6, 2);
        if (!this.setByteOrder(byteOrderIdentifier)) {
            directory.addError("Unclear distinction between Motorola/Intel byte ordering: " + byteOrderIdentifier);
            return this._metadata;
        }
        if (this.get16Bits(8) != 42) {
            directory.addError("Invalid Exif start - should have 0x2A at offset 8 in Exif header");
            return this._metadata;
        }
        int firstDirectoryOffset = this.get32Bits(10) + 6;
        if (firstDirectoryOffset >= this._data.length - 1) {
            directory.addError("First exif directory offset is beyond end of Exif data segment");
            firstDirectoryOffset = 14;
        }
        HashMap processedDirectoryOffsets = new HashMap();
        this.processDirectory(directory, processedDirectoryOffsets, firstDirectoryOffset, 6);
        this.storeThumbnailBytes(directory, 6);
        return this._metadata;
    }

    private void storeThumbnailBytes(ExifDirectory exifDirectory, int tiffHeaderOffset) {
        if (!exifDirectory.containsTag(259)) {
            return;
        }
        if (!exifDirectory.containsTag(514) || !exifDirectory.containsTag(513)) {
            return;
        }
        try {
            int offset = exifDirectory.getInt(513);
            int length = exifDirectory.getInt(514);
            byte[] result = new byte[length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this._data[tiffHeaderOffset + offset + i];
            }
            exifDirectory.setByteArray(61441, result);
        }
        catch (Throwable e) {
            exifDirectory.addError("Unable to extract thumbnail: " + e.getMessage());
        }
    }

    private boolean setByteOrder(String byteOrderIdentifier) {
        if ("MM".equals(byteOrderIdentifier)) {
            this._isMotorollaByteOrder = true;
        } else if ("II".equals(byteOrderIdentifier)) {
            this._isMotorollaByteOrder = false;
        } else {
            return false;
        }
        return true;
    }

    private void processDirectory(Directory directory, HashMap processedDirectoryOffsets, int dirStartOffset, int tiffHeaderOffset) {
        if (processedDirectoryOffsets.containsKey(new Integer(dirStartOffset))) {
            return;
        }
        processedDirectoryOffsets.put(new Integer(dirStartOffset), "processed");
        if (dirStartOffset >= this._data.length || dirStartOffset < 0) {
            directory.addError("Ignored directory marked to start outside data segement");
            return;
        }
        if (!this.isDirectoryLengthValid(dirStartOffset, tiffHeaderOffset)) {
            directory.addError("Illegally sized directory");
            return;
        }
        int dirTagCount = this.get16Bits(dirStartOffset);
        block6: for (int tagNumber = 0; tagNumber < dirTagCount; ++tagNumber) {
            int tagOffset = this.calculateTagOffset(dirStartOffset, tagNumber);
            int tagType = this.get16Bits(tagOffset);
            int formatCode = this.get16Bits(tagOffset + 2);
            if (formatCode < 1 || formatCode > 12) {
                directory.addError("Invalid format code: " + formatCode);
                continue;
            }
            int componentCount = this.get32Bits(tagOffset + 4);
            if (componentCount < 0) {
                directory.addError("Negative component count in EXIF");
                continue;
            }
            int byteCount = componentCount * BYTES_PER_FORMAT[formatCode];
            int tagValueOffset = this.calculateTagValueOffset(byteCount, tagOffset, tiffHeaderOffset);
            if (tagValueOffset < 0 || tagValueOffset > this._data.length) {
                directory.addError("Illegal pointer offset value in EXIF");
                continue;
            }
            if (byteCount < 0 || tagValueOffset + byteCount > this._data.length) {
                directory.addError("Illegal number of bytes: " + byteCount);
                continue;
            }
            int subdirOffset = tiffHeaderOffset + this.get32Bits(tagValueOffset);
            switch (tagType) {
                case 34665: {
                    this.processDirectory(this._metadata.getDirectory(ExifDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset);
                    continue block6;
                }
                case 40965: {
                    this.processDirectory(this._metadata.getDirectory(ExifInteropDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset);
                    continue block6;
                }
                case 34853: {
                    this.processDirectory(this._metadata.getDirectory(GpsDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset);
                    continue block6;
                }
                case 37500: {
                    this.processMakerNote(tagValueOffset, processedDirectoryOffsets, tiffHeaderOffset);
                    continue block6;
                }
                default: {
                    this.processTag(directory, tagType, tagValueOffset, componentCount, formatCode);
                }
            }
        }
        int finalTagOffset = this.calculateTagOffset(dirStartOffset, dirTagCount);
        int nextDirectoryOffset = this.get32Bits(finalTagOffset);
        if (nextDirectoryOffset != 0) {
            if ((nextDirectoryOffset += tiffHeaderOffset) >= this._data.length) {
                return;
            }
            if (nextDirectoryOffset < dirStartOffset) {
                return;
            }
            this.processDirectory(directory, processedDirectoryOffsets, nextDirectoryOffset, tiffHeaderOffset);
        }
    }

    private void processMakerNote(int subdirOffset, HashMap processedDirectoryOffsets, int tiffHeaderOffset) {
        Directory exifDirectory = this._metadata.getDirectory(ExifDirectory.class);
        if (exifDirectory == null) {
            return;
        }
        String cameraModel = exifDirectory.getString(271);
        String firstTwoChars = new String(this._data, subdirOffset, 2);
        String firstThreeChars = new String(this._data, subdirOffset, 3);
        String firstFourChars = new String(this._data, subdirOffset, 4);
        String firstFiveChars = new String(this._data, subdirOffset, 5);
        String firstSixChars = new String(this._data, subdirOffset, 6);
        String firstSevenChars = new String(this._data, subdirOffset, 7);
        String firstEightChars = new String(this._data, subdirOffset, 8);
        if ("OLYMP".equals(firstFiveChars) || "EPSON".equals(firstFiveChars) || "AGFA".equals(firstFourChars)) {
            this.processDirectory(this._metadata.getDirectory(OlympusMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 8, tiffHeaderOffset);
        } else if (cameraModel != null && cameraModel.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(firstFiveChars)) {
                if (this._data[subdirOffset + 6] == 1) {
                    this.processDirectory(this._metadata.getDirectory(NikonType1MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 8, tiffHeaderOffset);
                } else if (this._data[subdirOffset + 6] == 2) {
                    this.processDirectory(this._metadata.getDirectory(NikonType2MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 18, subdirOffset + 10);
                } else {
                    exifDirectory.addError("Unsupported makernote data ignored.");
                }
            } else {
                this.processDirectory(this._metadata.getDirectory(NikonType2MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset);
            }
        } else if ("SONY CAM".equals(firstEightChars) || "SONY DSC".equals(firstEightChars)) {
            this.processDirectory(this._metadata.getDirectory(SonyMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 12, tiffHeaderOffset);
        } else if ("KDK".equals(firstThreeChars)) {
            this.processDirectory(this._metadata.getDirectory(KodakMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 20, tiffHeaderOffset);
        } else if ("Canon".equalsIgnoreCase(cameraModel)) {
            this.processDirectory(this._metadata.getDirectory(CanonMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset);
        } else if (cameraModel != null && cameraModel.toUpperCase().startsWith("CASIO")) {
            if ("QVC\u0000\u0000\u0000".equals(firstSixChars)) {
                this.processDirectory(this._metadata.getDirectory(CasioType2MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 6, tiffHeaderOffset);
            } else {
                this.processDirectory(this._metadata.getDirectory(CasioType1MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset);
            }
        } else if ("FUJIFILM".equals(firstEightChars) || "Fujifilm".equalsIgnoreCase(cameraModel)) {
            boolean byteOrderBefore = this._isMotorollaByteOrder;
            this._isMotorollaByteOrder = false;
            int ifdStart = subdirOffset + this.get32Bits(subdirOffset + 8);
            this.processDirectory(this._metadata.getDirectory(FujifilmMakernoteDirectory.class), processedDirectoryOffsets, ifdStart, tiffHeaderOffset);
            this._isMotorollaByteOrder = byteOrderBefore;
        } else if (cameraModel != null && cameraModel.toUpperCase().startsWith("MINOLTA")) {
            this.processDirectory(this._metadata.getDirectory(OlympusMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, tiffHeaderOffset);
        } else if ("KC".equals(firstTwoChars) || "MINOL".equals(firstFiveChars) || "MLY".equals(firstThreeChars) || "+M+M+M+M".equals(firstEightChars)) {
            exifDirectory.addError("Unsupported Konica/Minolta data ignored.");
        } else if ("KYOCERA".equals(firstSevenChars)) {
            this.processDirectory(this._metadata.getDirectory(KyoceraMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 22, tiffHeaderOffset);
        } else if ("Panasonic\u0000\u0000\u0000".equals(new String(this._data, subdirOffset, 12))) {
            this.processDirectory(this._metadata.getDirectory(PanasonicMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 12, tiffHeaderOffset);
        } else if ("AOC\u0000".equals(firstFourChars)) {
            this.processDirectory(this._metadata.getDirectory(CasioType2MakernoteDirectory.class), processedDirectoryOffsets, subdirOffset + 6, subdirOffset);
        } else if (cameraModel != null && (cameraModel.toUpperCase().startsWith("PENTAX") || cameraModel.toUpperCase().startsWith("ASAHI"))) {
            this.processDirectory(this._metadata.getDirectory(PentaxMakernoteDirectory.class), processedDirectoryOffsets, subdirOffset, subdirOffset);
        } else {
            exifDirectory.addError("Unsupported makernote data ignored.");
        }
    }

    private boolean isDirectoryLengthValid(int dirStartOffset, int tiffHeaderOffset) {
        int dirTagCount = this.get16Bits(dirStartOffset);
        int dirLength = 2 + 12 * dirTagCount + 4;
        return dirLength + dirStartOffset + tiffHeaderOffset < this._data.length;
    }

    private void processTag(Directory directory, int tagType, int tagValueOffset, int componentCount, int formatCode) {
        switch (formatCode) {
            case 7: {
                byte[] tagBytes = new byte[componentCount];
                int byteCount = componentCount * BYTES_PER_FORMAT[formatCode];
                for (int i = 0; i < byteCount; ++i) {
                    tagBytes[i] = this._data[tagValueOffset + i];
                }
                directory.setByteArray(tagType, tagBytes);
                break;
            }
            case 2: {
                directory.setString(tagType, this.readString(tagValueOffset, componentCount));
                break;
            }
            case 5: 
            case 10: {
                if (componentCount == 1) {
                    Rational rational = new Rational((long)this.get32Bits(tagValueOffset), (long)this.get32Bits(tagValueOffset + 4));
                    directory.setRational(tagType, rational);
                    break;
                }
                Rational[] rationals = new Rational[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    rationals[i] = new Rational((long)this.get32Bits(tagValueOffset + 8 * i), (long)this.get32Bits(tagValueOffset + 4 + 8 * i));
                }
                directory.setRationalArray(tagType, rationals);
                break;
            }
            case 1: 
            case 6: {
                if (componentCount == 1) {
                    byte b = this._data[tagValueOffset];
                    directory.setInt(tagType, b);
                    break;
                }
                int[] bytes = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    bytes[i] = this._data[tagValueOffset + i];
                }
                directory.setIntArray(tagType, bytes);
                break;
            }
            case 11: 
            case 12: {
                if (componentCount == 1) {
                    byte i = this._data[tagValueOffset];
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = this._data[tagValueOffset + i];
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            case 3: 
            case 8: {
                if (componentCount == 1) {
                    int i = this.get16Bits(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = this.get16Bits(tagValueOffset + i * 2);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            case 4: 
            case 9: {
                if (componentCount == 1) {
                    int i = this.get32Bits(tagValueOffset);
                    directory.setInt(tagType, i);
                    break;
                }
                int[] ints = new int[componentCount];
                for (int i = 0; i < componentCount; ++i) {
                    ints[i] = this.get32Bits(tagValueOffset + i * 4);
                }
                directory.setIntArray(tagType, ints);
                break;
            }
            default: {
                directory.addError("Unknown format code " + formatCode + " for tag " + tagType);
            }
        }
    }

    private int calculateTagValueOffset(int byteCount, int dirEntryOffset, int tiffHeaderOffset) {
        if (byteCount > 4) {
            int offsetVal = this.get32Bits(dirEntryOffset + 8);
            if (offsetVal + byteCount > this._data.length) {
                return -1;
            }
            return tiffHeaderOffset + offsetVal;
        }
        return dirEntryOffset + 8;
    }

    private String readString(int offset, int maxLength) {
        int length;
        for (length = 0; offset + length < this._data.length && this._data[offset + length] != 0 && length < maxLength; ++length) {
        }
        return new String(this._data, offset, length);
    }

    private int calculateTagOffset(int dirStartOffset, int entryNumber) {
        return dirStartOffset + 2 + 12 * entryNumber;
    }

    private int get16Bits(int offset) {
        if (offset < 0 || offset + 2 > this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + offset + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorollaByteOrder) {
            return this._data[offset] << 8 & 0xFF00 | this._data[offset + 1] & 0xFF;
        }
        return this._data[offset + 1] << 8 & 0xFF00 | this._data[offset] & 0xFF;
    }

    private int get32Bits(int offset) {
        if (offset < 0 || offset + 4 > this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + offset + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorollaByteOrder) {
            return this._data[offset] << 24 & 0xFF000000 | this._data[offset + 1] << 16 & 0xFF0000 | this._data[offset + 2] << 8 & 0xFF00 | this._data[offset + 3] & 0xFF;
        }
        return this._data[offset + 3] << 24 & 0xFF000000 | this._data[offset + 2] << 16 & 0xFF0000 | this._data[offset + 1] << 8 & 0xFF00 | this._data[offset] & 0xFF;
    }
}

