/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import net.jalbum.filters.BasicFilter;
import net.jalbum.filters.ResizableObject;
import net.jalbum.filters.ResizableObjectControl;

public class ResizableObjectPanel
extends BasicFilter {
    private static final long serialVersionUID = -2109546799471864726L;
    protected ResizableObject resizableObject;
    protected ResizableObjectControl resizableObjectControl;
    protected double X1;
    protected double Y1;
    protected double X2;
    protected double Y2;
    protected boolean showOutline = true;

    public ResizableObjectPanel() {
        this.name = "ResizableObjectPanel";
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = "This is just for inheriting for other filters. This is not applicable.";
        this.prescale = false;
        this.postscale = false;
        this.resizableObjectControl = new ResizableObjectControl(this);
        this.resizableObject = new ResizableObject();
        this.resizableObject.setParentPanel(this);
    }

    public void setPreviewImage(BufferedImage bi) {
        this.width = bi.getWidth();
        this.height = bi.getHeight();
        this.resizableObject.setWidth(this.width);
        this.resizableObject.setHeight(this.height);
        this.resizableObjectControl.setObjectWidth(this.width);
        this.resizableObjectControl.setObjectHeight(this.height);
        super.setPreviewImage(bi);
    }

    public void paint(Graphics g) {
        g.drawImage(this.outputImage, 0, 0, null);
        if (this.showOutline) {
            this.resizableObject.paint(g);
        }
    }

    public void setCursor(Cursor cursor) {
        this.filterManager.setCursor(cursor);
    }

    public Cursor getCursor() {
        return this.filterManager.getCursor();
    }

    public void updateController(double x1, double y1, double x2, double y2) {
        this.X1 = x1;
        this.Y1 = y1;
        this.X2 = x2;
        this.Y2 = y2;
        this.resizableObjectControl.update(x1, y1, x2, y2);
        this.renderPreview();
    }

    public void updateObject(double x1, double y1, double x2, double y2) {
        this.X1 = x1;
        this.Y1 = y1;
        this.X2 = x2;
        this.Y2 = y2;
        this.resizableObject.update(x1, y1, x2, y2);
        this.resizableObject.setInitial(false);
        this.renderPreview();
    }

    public void keyPressed(KeyEvent arg0) {
        this.resizableObject.keyPressed(arg0);
    }

    public void keyReleased(KeyEvent arg0) {
        this.resizableObject.keyReleased(arg0);
    }

    public void keyTyped(KeyEvent arg0) {
        this.resizableObject.keyTyped(arg0);
    }

    public void mouseClicked(MouseEvent event) {
        this.resizableObject.mouseClicked(event);
    }

    public void mouseMoved(MouseEvent event) {
        this.resizableObject.mouseMoved(event);
    }

    public void mouseDragged(MouseEvent event) {
        this.resizableObject.mouseDragged(event);
    }

    public void mouseEntered(MouseEvent event) {
        this.resizableObject.mouseEntered(event);
    }

    public void mouseExited(MouseEvent event) {
        this.resizableObject.mouseExited(event);
    }

    public void mousePressed(MouseEvent event) {
        this.resizableObject.mousePressed(event);
    }

    public void mouseReleased(MouseEvent event) {
        this.resizableObject.mouseReleased(event);
    }

    public boolean isShowOutline() {
        return this.showOutline;
    }

    public void setShowOutline(boolean showOutline) {
        this.showOutline = showOutline;
    }

    public double getX1() {
        return this.X1;
    }

    public void setX1(double x1) {
        this.X1 = x1;
    }

    public double getY1() {
        return this.Y1;
    }

    public void setY1(double y1) {
        this.Y1 = y1;
    }

    public double getX2() {
        return this.X2;
    }

    public void setX2(double x2) {
        this.X2 = x2;
    }

    public double getY2() {
        return this.Y2;
    }

    public void setY2(double y2) {
        this.Y2 = y2;
    }

    public ResizableObject getResizableObject() {
        return this.resizableObject;
    }

    public void setResizableObject(ResizableObject resizableObject) {
        this.resizableObject = resizableObject;
    }
}

