/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import net.jalbum.filters.ResizableObject;
import net.jalbum.filters.ResizableObjectPanel;

public class ResizableBox
extends ResizableObject {
    private static final long serialVersionUID = 7200291618612187396L;
    protected boolean keepDimension = false;
    protected boolean keepRatio = false;
    protected boolean keepRatioKey = false;
    protected boolean keepSquare = false;
    protected double ratio;

    public ResizableBox() {
    }

    public ResizableBox(int width, int height) {
        super(width, height);
    }

    public ResizableBox(int width, int height, ResizableObjectPanel parentPanel) {
        this(width, height);
        this.setParentPanel(parentPanel);
    }

    protected void paintHandles(Graphics g) {
        if (this.position == 1 || this.position == 2 || this.position == 3 || this.position == 4 || this.position == 5 || this.position == 6 || this.position == 7 || this.position == 8 || this.position == 9) {
            if (!this.keepDimension) {
                super.paintHandles(g);
            }
            int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
            int intX2 = (int)(this.OutX2 * (double)(this.width - 1));
            int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
            int intY2 = (int)(this.OutY2 * (double)(this.height - 1));
            if (!(this.keepDimension || this.keepRatio || this.keepRatioKey)) {
                if (Math.abs(intX2 - intX1) > this.handlesize * 3) {
                    g.setColor(Color.WHITE);
                    g.fillRect(intX1 - this.handlesize / 2 + (intX2 - intX1) / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
                    g.fillRect(intX1 - this.handlesize / 2 + (intX2 - intX1) / 2, intY2 - this.handlesize / 2, this.handlesize, this.handlesize);
                    g.setColor(Color.BLACK);
                    g.drawRect(intX1 - this.handlesize / 2 + (intX2 - intX1) / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
                    g.drawRect(intX1 - this.handlesize / 2 + (intX2 - intX1) / 2, intY2 - this.handlesize / 2, this.handlesize, this.handlesize);
                }
                if (Math.abs(intX2 - intX1) > this.handlesize * 3) {
                    g.setColor(Color.WHITE);
                    g.fillRect(intX1 - this.handlesize / 2, intY1 - this.handlesize / 2 + (intY2 - intY1) / 2, this.handlesize, this.handlesize);
                    g.fillRect(intX2 - this.handlesize / 2, intY1 - this.handlesize / 2 + (intY2 - intY1) / 2, this.handlesize, this.handlesize);
                    g.setColor(Color.BLACK);
                    g.drawRect(intX1 - this.handlesize / 2, intY1 - this.handlesize / 2 + (intY2 - intY1) / 2, this.handlesize, this.handlesize);
                    g.drawRect(intX2 - this.handlesize / 2, intY1 - this.handlesize / 2 + (intY2 - intY1) / 2, this.handlesize, this.handlesize);
                }
            }
        }
    }

    protected int checkState(int x, int y) {
        int superState = super.checkState(x, y);
        if ((superState == 2 || superState == 3 || superState == 4 || superState == 5) && this.keepDimension) {
            return 1;
        }
        if ((superState == 6 || superState == 7 || superState == 8 || superState == 9) && (this.keepDimension || this.keepRatio || this.keepRatioKey)) {
            return 1;
        }
        if (superState == 0 && (this.keepDimension || this.keepRatio || this.keepRatioKey)) {
            return 10;
        }
        return superState;
    }

    protected void changeMousePosition(MouseEvent arg0) {
        int inputX = arg0.getX();
        int inputY = arg0.getY();
        if (this.state == 1) {
            if (!(this.X1 - this.OffsetX + (double)inputX / (double)(this.width - 1) < 0.0) && !(this.X2 - this.OffsetX + (double)inputX / (double)(this.width - 1) > 1.0) && (this.keepDimension || this.keepRatio || this.keepRatioKey) || !this.keepDimension && !this.keepRatio && !this.keepRatioKey) {
                this.X1 = this.X1 - this.OffsetX + (double)inputX / (double)(this.width - 1);
                this.X2 = this.X2 - this.OffsetX + (double)inputX / (double)(this.width - 1);
                this.OffsetX = (double)inputX / (double)(this.width - 1);
            } else {
                double correctionX = 0.0;
                if (this.X1 - this.OffsetX + (double)inputX / (double)(this.width - 1) < 0.0) {
                    correctionX = this.X1;
                    this.X1 = 0.0;
                    this.X2 -= correctionX;
                } else if (this.X2 - this.OffsetX + (double)inputX / (double)(this.width - 1) > 1.0) {
                    correctionX = 1.0 - this.X2;
                    this.X2 = 1.0;
                    this.X1 += correctionX;
                }
            }
            if (!(this.Y1 - this.OffsetY + (double)inputY / (double)(this.height - 1) < 0.0) && !(this.Y2 - this.OffsetY + (double)inputY / (double)(this.height - 1) > 1.0) && (this.keepDimension || this.keepRatio || this.keepRatioKey) || !this.keepDimension && !this.keepRatio && !this.keepRatioKey) {
                this.Y1 = this.Y1 - this.OffsetY + (double)inputY / (double)(this.height - 1);
                this.Y2 = this.Y2 - this.OffsetY + (double)inputY / (double)(this.height - 1);
                this.OffsetY = (double)inputY / (double)(this.height - 1);
            } else {
                double correctionY = 0.0;
                if (this.Y1 - this.OffsetY + (double)inputY / (double)(this.height - 1) < 0.0) {
                    correctionY = this.Y1;
                    this.Y1 = 0.0;
                    this.Y2 -= correctionY;
                } else if (this.Y2 - this.OffsetY + (double)inputY / (double)(this.height - 1) > 1.0) {
                    correctionY = 1.0 - this.Y2;
                    this.Y2 = 1.0;
                    this.Y1 += correctionY;
                }
            }
        } else if (this.state == 0) {
            double[] result = this.calculateResize(this.X1, this.Y1, inputX, inputY);
            this.X2 = result[0];
            this.Y2 = result[1];
        } else if (this.state == 2) {
            double[] result = this.calculateResize(this.X2, this.Y2, inputX, inputY);
            this.X1 = result[0];
            this.Y1 = result[1];
        } else if (this.state == 3) {
            double[] result = this.calculateResize(this.X1, this.Y2, inputX, inputY);
            this.X2 = result[0];
            this.Y1 = result[1];
        } else if (this.state == 4) {
            double[] result = this.calculateResize(this.X1, this.Y1, inputX, inputY);
            this.X2 = result[0];
            this.Y2 = result[1];
        } else if (this.state == 5) {
            double[] result = this.calculateResize(this.X2, this.Y1, inputX, inputY);
            this.X1 = result[0];
            this.Y2 = result[1];
        } else if (this.state == 6) {
            this.Y1 = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 7) {
            this.X2 = (double)inputX / (double)(this.width - 1);
        } else if (this.state == 8) {
            this.Y2 = (double)inputY / (double)(this.height - 1);
        } else if (this.state == 9) {
            this.X1 = (double)inputX / (double)(this.width - 1);
        }
    }

    private double[] calculateResize(double fixedX, double fixedY, int inputX, int inputY) {
        if (this.keepRatio || this.keepRatioKey) {
            double tempY;
            double tempX;
            if (this.ratio < Math.abs(fixedX - (double)inputX / (double)(this.width - 1)) / Math.abs(fixedY - (double)inputY / (double)(this.height - 1))) {
                tempX = (double)inputX / (double)(this.width - 1);
                if (tempX > 1.0) {
                    tempX = 1.0;
                } else if (tempX < 0.0) {
                    tempX = 0.0;
                }
                tempY = Math.abs(fixedX - tempX) / this.ratio * ((double)inputY / (double)(this.height - 1) - fixedY) / Math.abs((double)inputY / (double)(this.height - 1) - fixedY) + fixedY;
                if (tempY < 0.0) {
                    tempY = 0.0;
                    tempX = Math.abs(fixedY - tempY) * this.ratio * (tempX - fixedX) / Math.abs(tempX - fixedX) + fixedX;
                } else if (tempY > 1.0) {
                    tempY = 1.0;
                    tempX = Math.abs(fixedY - tempY) * this.ratio * (tempX - fixedX) / Math.abs(tempX - fixedX) + fixedX;
                }
            } else {
                tempY = (double)inputY / (double)(this.height - 1);
                if (tempY > 1.0) {
                    tempY = 1.0;
                } else if (tempY < 0.0) {
                    tempY = 0.0;
                }
                tempX = Math.abs(fixedY - tempY) * this.ratio * ((double)inputX / (double)(this.width - 1) - fixedX) / Math.abs((double)inputX / (double)(this.width - 1) - fixedX) + fixedX;
                if (tempX < 0.0) {
                    tempX = 0.0;
                    tempY = Math.abs(fixedX - tempX) / this.ratio * (tempY - fixedY) / Math.abs(tempY - fixedY) + fixedY;
                } else if (tempX > 1.0) {
                    tempX = 1.0;
                    tempY = Math.abs(fixedX - tempX) / this.ratio * (tempY - fixedY) / Math.abs(tempY - fixedY) + fixedY;
                }
            }
            return new double[]{tempX, tempY};
        }
        return new double[]{(double)inputX / (double)(this.width - 1), (double)inputY / (double)(this.height - 1)};
    }

    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 18) {
            if (!this.keepRatioKey) {
                this.ratio = (this.X2 - this.X1 + 1.0 / (double)(this.height - 1)) / (this.Y2 - this.Y1 + 1.0 / (double)(this.height - 1));
            }
            this.keepRatioKey = true;
        } else if (arg0.getKeyCode() == 17) {
            if (!this.keepRatio && !this.keepRatioKey) {
                this.keepSquare = true;
                this.ratio = 1.0;
            }
        } else {
            super.keyPressed(arg0);
        }
        this.updateParent();
    }

    public void keyReleased(KeyEvent arg0) {
        if (arg0.getKeyCode() == 18) {
            this.keepRatioKey = false;
        }
        if (arg0.getKeyCode() == 17) {
            this.keepSquare = false;
        }
        this.updateParent();
    }

    public void setKeepDimension(boolean keepDimension) {
        this.keepDimension = keepDimension;
    }

    public void adjustKeepRatio(boolean keepRatio) {
        this.keepRatio = keepRatio;
        if (keepRatio) {
            this.ratio = (this.X2 - this.X1 + 1.0 / (double)(this.height - 1)) / (this.Y2 - this.Y1 + 1.0 / (double)(this.height - 1));
        }
    }

    public boolean isKeepRatioKey() {
        return this.keepRatioKey;
    }

    public void setKeepRatioKey(boolean keepRatioKey) {
        this.keepRatioKey = keepRatioKey;
    }

    public boolean isKeepSquare() {
        return this.keepSquare;
    }

    public void setKeepSquare(boolean keepSquare) {
        this.keepSquare = keepSquare;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public boolean isKeepDimension() {
        return this.keepDimension;
    }

    public boolean isKeepRatio() {
        return this.keepRatio;
    }
}

