/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class StringCodec {
    private static final byte[] UTF8Signature = new byte[]{-17, -69, -65};
    private static final byte[] UTF16BESignature = new byte[]{-2, -1};
    private static final byte[] UTF16LESignature = new byte[]{-1, -2};
    protected static Map encMap = new HashMap();
    private boolean addSignature = false;
    private String detectedEncoding;

    public boolean isAddSignature() {
        return this.addSignature;
    }

    public void setAddSignature(boolean addIt) {
        this.addSignature = addIt;
    }

    public byte[] encode(String s, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        byte[] buf = s.getBytes(encoding);
        this.detectedEncoding = encoding;
        if (!this.addSignature) {
            return buf;
        }
        byte[] prefix = (byte[])encMap.get(encoding);
        if (prefix == null) {
            return buf;
        }
        byte[] finalBuf = new byte[prefix.length + buf.length];
        System.arraycopy(prefix, 0, finalBuf, 0, prefix.length);
        System.arraycopy(buf, 0, finalBuf, prefix.length, buf.length);
        return finalBuf;
    }

    public byte[] encode(String s) throws UnsupportedEncodingException {
        return this.encode(s, null);
    }

    public String decode(byte[] buf) throws UnsupportedEncodingException {
        return this.decode(buf, 0, buf.length, null);
    }

    public String decode(byte[] buf, String defaultEncoding) throws UnsupportedEncodingException {
        return this.decode(buf, 0, buf.length, defaultEncoding);
    }

    public String decode(byte[] buf, int offset, int length) throws UnsupportedEncodingException {
        return this.decode(buf, offset, length, null);
    }

    public String decode(byte[] buf, int offset, int length, String defaultEncoding) throws UnsupportedEncodingException {
        if (defaultEncoding == null) {
            defaultEncoding = System.getProperty("file.encoding");
        }
        this.detectedEncoding = null;
        for (Map.Entry e : encMap.entrySet()) {
            byte[] signature = (byte[])e.getValue();
            if (!StringCodec.startsWith(buf, offset, signature)) continue;
            this.detectedEncoding = (String)e.getKey();
            return new String(buf, signature.length + offset, length - signature.length, this.detectedEncoding);
        }
        if (StringCodec.isUTF8(buf, offset, length)) {
            this.detectedEncoding = "UTF-8";
            return new String(buf, offset, length, this.detectedEncoding);
        }
        return new String(buf, 0, length, defaultEncoding);
    }

    public static boolean isUTF8(byte[] buf) {
        return StringCodec.isUTF8(buf, 0, buf.length);
    }

    public static boolean isUTF8(byte[] buf, int offset, int length) {
        if (StringCodec.startsWith(buf, offset, UTF8Signature)) {
            return true;
        }
        boolean yesItIs = false;
        for (int i = offset; i < offset + length; ++i) {
            int mask;
            int nBytes;
            if ((buf[i] & 0xC0) != 192) continue;
            for (nBytes = 2; nBytes < 8 && (buf[i] & (mask = 1 << 7 - nBytes)) != 0; ++nBytes) {
            }
            for (int j = 1; j < nBytes; ++j) {
                if (i + j < length && (buf[i + j] & 0xC0) == 128) continue;
                return false;
            }
            yesItIs = true;
        }
        return yesItIs;
    }

    public String getDetectedEncoding() {
        return this.detectedEncoding;
    }

    public static boolean isEncodable(String s, String encoding) throws UnsupportedEncodingException {
        StringCodec codec = new StringCodec();
        byte[] buf = codec.encode(s, encoding);
        String s2 = codec.decode(buf, encoding);
        return s2.equals(s);
    }

    private static boolean startsWith(byte[] buf, int offset, byte[] prefix) {
        for (int i = 0; i < prefix.length; ++i) {
            if (i + offset != buf.length && buf[i + offset] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private static void testEncode(String s, String encoding) throws UnsupportedEncodingException {
        if (StringCodec.isEncodable(s, encoding)) {
            System.out.println(s + " can be encoded to " + encoding);
        } else {
            System.out.println(s + " can not be encoded to " + encoding);
        }
    }

    static {
        encMap.put("UTF-8", UTF8Signature);
        encMap.put("UTF8", UTF8Signature);
        encMap.put("UTF-16BE", UTF16BESignature);
        encMap.put("UTF-16LE", UTF16LESignature);
    }
}

