/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFile;
import java.awt.Cursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.datadosen.jalbum.RemoteFSContext;
import se.datadosen.util.IO;

public class RemoteFSNode
extends DefaultMutableTreeNode {
    private boolean childrenDefined = false;
    private boolean albumChecked = false;
    private String remoteName;
    private long remoteSize;
    private int plainFileCount = 0;
    private boolean link;
    private boolean leaf;
    private boolean album;
    private boolean passwordProtected;
    private RemoteFSContext context;
    private static boolean lateDiscovery = true;

    public RemoteFSNode(String name, String remoteName, RemoteFSContext context) {
        this(name, false, false, context);
        this.remoteName = remoteName;
        if (remoteName == null) {
            this.childrenDefined = true;
        }
    }

    public RemoteFSNode(String name, boolean link, boolean leaf, RemoteFSContext context) {
        this.remoteName = name;
        this.link = link;
        this.leaf = leaf;
        this.context = context;
        super.setUserObject(name);
    }

    public RemoteFSNode(RemoteFile remoteFile, boolean leaf, RemoteFSContext context) {
        this.remoteName = remoteFile.getName();
        this.remoteSize = remoteFile.size();
        this.link = remoteFile.isLink();
        this.leaf = leaf;
        this.context = context;
        super.setUserObject(this.remoteName);
    }

    public static boolean isLateDiscovery() {
        return lateDiscovery;
    }

    public static void setLateDiscovery(boolean lateDiscovery) {
        RemoteFSNode.lateDiscovery = lateDiscovery;
    }

    public void setUserObject(Object userObject) {
        super.setUserObject(userObject);
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isLink() {
        return this.link;
    }

    public long getSize() {
        return this.remoteSize;
    }

    public boolean isPasswordProtected() {
        if (!(this.leaf || lateDiscovery || this.albumChecked)) {
            this.albumChecked = true;
            try {
                this.discover();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                return false;
            }
        }
        return this.passwordProtected;
    }

    public boolean isAlbum() {
        if (this.context.isAdvancedMode()) {
            return false;
        }
        if (!lateDiscovery && !this.albumChecked) {
            this.albumChecked = true;
            try {
                this.discover();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                return false;
            }
        }
        return this.album;
    }

    private void discover() throws IOException, RemoteFSException {
        String path = RemoteFSNode.remotePath(new TreePath(this.getPath()), this.context);
        this.album = this.context.getRemoteFS().exists(IO.combinePaths(path, "thumbs"));
        this.passwordProtected = this.context.getProtectedPaths().contains(path);
    }

    public boolean areChildrenDefined() {
        return this.childrenDefined;
    }

    public int getChildCount() {
        if (!this.childrenDefined) {
            this.defineChildNodes();
        }
        return super.getChildCount();
    }

    public int getPlainFileCount() {
        if (!this.childrenDefined) {
            this.defineChildNodes();
        }
        return this.plainFileCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineChildNodes() {
        this.childrenDefined = true;
        this.plainFileCount = 0;
        String path = RemoteFSNode.remotePath(new TreePath(this.getPath()), this.context);
        if (this.context.getOwningWindow() != null) {
            this.context.getOwningWindow().setCursor(new Cursor(3));
        }
        try {
            this.album = false;
            this.context.getRemoteFS().setDirectory(path);
            Object[] files = this.context.getRemoteFS().getFiles(RemoteFSBean.noDotDotDotFileFilter);
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                Object file = files[i];
                if (((RemoteFile)file).isDirectory() || ((RemoteFile)file).isLink()) {
                    String name = ((RemoteFile)file).getName();
                    if (!this.context.isAdvancedMode() && (name.equals("slides") || name.equals("thumbs") || name.equals("res"))) {
                        this.album = true;
                        continue;
                    }
                    this.add(new RemoteFSNode((RemoteFile)file, false, this.context));
                    continue;
                }
                if (!((RemoteFile)file).isDirectory() && this.context.isAdvancedMode()) {
                    this.add(new RemoteFSNode((RemoteFile)file, true, this.context));
                }
                ++this.plainFileCount;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (this.context.getOwningWindow() != null) {
                this.context.getOwningWindow().setCursor(new Cursor(0));
            }
        }
    }

    public boolean isRealDirectory() {
        return this.remoteName != null && this.remoteName.length() > 0;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public void invalidate() {
        this.removeAllChildren();
        this.childrenDefined = false;
    }

    public void invalidateNodeOnly() {
        this.albumChecked = false;
    }

    public String remotePath() {
        return RemoteFSNode.remotePath(new TreePath(this.getPath()), this.context);
    }

    public String oldRemotePath() {
        return RemoteFSNode.oldRemotePath(new TreePath(this.getPath()), this.context);
    }

    public static String remotePath(TreePath tp, RemoteFSContext context) {
        StringBuffer buf = new StringBuffer();
        Object[] path = tp.getPath();
        for (int i = 1; i < path.length; ++i) {
            if (i > 1) {
                buf.append('/');
            }
            buf.append(path[i]);
        }
        String p = IO.combinePaths("/", context.getBasePath());
        p = IO.combinePaths(p, buf.toString());
        RemoteFSNode node = (RemoteFSNode)tp.getLastPathComponent();
        return p;
    }

    public static String oldRemotePath(TreePath tp, RemoteFSContext context) {
        StringBuffer buf = new StringBuffer();
        Object[] nodes = tp.getPath();
        for (int i = 1; i < nodes.length; ++i) {
            if (i > 1) {
                buf.append('/');
            }
            buf.append(((RemoteFSNode)nodes[i]).getRemoteName());
        }
        String p = IO.combinePaths("/", context.getBasePath());
        p = IO.combinePaths(p, buf.toString());
        RemoteFSNode node = (RemoteFSNode)tp.getLastPathComponent();
        return p;
    }

    public static TreePath treePath(String remotePath, TreeModel model) {
        StringTokenizer pathComponents = new StringTokenizer(remotePath, "/");
        TreePath tp = new TreePath(model.getRoot());
        while (pathComponents.hasMoreTokens()) {
            String pathComponent = pathComponents.nextToken();
            TreeNode tn = (TreeNode)tp.getLastPathComponent();
            tn.getChildCount();
            Enumeration<? extends TreeNode> children = tn.children();
            TreeNode found = null;
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (!pathComponent.equals(child.toString())) continue;
                found = child;
                tp = tp.pathByAddingChild(child);
                break;
            }
            if (found != null) continue;
            return tp;
        }
        return tp;
    }
}

