/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedList;
import se.datadosen.jalbum.MiniConfig;

public final class Main {
    private static final MiniConfig config = MiniConfig.getMiniConfig();

    public static void main(String[] args) throws ClassNotFoundException {
        File libDir = new File(Main.config.progDir, "lib");
        URL[] libUrls = Main.buildURLList(libDir);
        File extLibDir = new File(Main.config.progDir, "ext");
        URL[] extLibUrls = Main.buildURLList(extLibDir);
        LinkedList<URL> all = new LinkedList<URL>();
        all.addAll(Arrays.asList(libUrls));
        all.addAll(Arrays.asList(extLibUrls));
        try {
            all.add(Main.config.pluginsDir.toURI().toURL());
            URL[] allURLs = all.toArray(new URL[0]);
            URLClassLoader classLoader = new URLClassLoader(allURLs);
            Class<?> clazz = classLoader.loadClass("se.datadosen.jalbum.JAlbum");
            Thread.currentThread().setContextClassLoader(classLoader);
            Method method = clazz.getMethod("main", args.getClass());
            method.invoke(null, new Object[]{args});
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            t.printStackTrace();
        }
    }

    public static final File[] buildFileList(File dir) {
        Object[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                String s = f.getName().toLowerCase();
                return s.endsWith(".jar") || s.endsWith(".zip");
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        Arrays.sort(files);
        return files;
    }

    private static final URL[] buildURLList(File dir) {
        File[] files = Main.buildFileList(dir);
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
            return urls;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

