/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JPopupButton;
import se.datadosen.component.JSmartComboBox;
import se.datadosen.component.JSmartSeparator;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DirectoryFilter;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.StyleFileFilter;
import se.datadosen.jalbum.event.AccountManagerListener;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;

public class JMainSettingsPanel
extends JPanel
implements JComponentHolder {
    private JAlbumFrame frame;
    JLabel skinLabel = new JLabel();
    JLabel styleLabel = new JLabel();
    JComboBox skin = new JSmartComboBox();
    JComboBox style = new JSmartComboBox();
    JLinkLabel moreSkinsLink = new JLinkLabel();
    JSmartSeparator settingsSeparator = JAlbumBorders.createSeparator();
    private JRadioButton makeChanges = new JRadioButton();
    private JRadioButton makeAll = new JRadioButton();
    public ButtonGroup appendImages = new ButtonGroup(){
        {
            this.add(JMainSettingsPanel.this.makeChanges);
            this.add(JMainSettingsPanel.this.makeAll);
            JMainSettingsPanel.this.makeAll.setSelected(true);
            JMainSettingsPanel.this.makeChanges.setActionCommand("true");
            JMainSettingsPanel.this.makeAll.setActionCommand("false");
        }
    };
    private JCollapsiblePanel collapsiblePanel = new JCollapsiblePanel();
    private JButton albumSettingsButton;
    private JPopupButton makeAlbumButton;
    private JButton viewAlbumButton;
    private JPopupButton publishButton;
    private MouseListener skinsScanner = new MouseAdapter(){

        public void mouseEntered(MouseEvent e) {
            JMainSettingsPanel.this.scanSkins();
        }
    };
    private PopupMenuListener skinPreviewer = new PopupMenuListener(){

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JMainSettingsPanel.this.frame.setPreviewImage();
            ((JMainSettingsPanel)JMainSettingsPanel.this).frame.skinPreview.setVisible(true);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            ((JMainSettingsPanel)JMainSettingsPanel.this).frame.skinPreview.setVisible(false);
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    };
    ActionListener skinSelectedActionListener = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            Object object = JAlbum.initializedOkMonitor;
            synchronized (object) {
                JMainSettingsPanel.this.frame.fireSkinChanged(new JAlbumEvent(this));
                JMainSettingsPanel.this.frame.setSkinUI(null);
                String selected = JMainSettingsPanel.this.getSelectedStyle();
                JMainSettingsPanel.this.style.removeAllItems();
                File skinDir = ((JMainSettingsPanel)JMainSettingsPanel.this).frame.cfg.chainedSkinsDir.getFile(JMainSettingsPanel.this.getSelectedSkin());
                JMainSettingsPanel.this.frame;
                JAlbumFrame.fillCombo(JMainSettingsPanel.this.style, new File(skinDir, "styles"), (FileFilter)new StyleFileFilter());
                if (JMainSettingsPanel.this.style.getItemCount() > 0) {
                    JMainSettingsPanel.this.style.setSelectedIndex(0);
                }
                JMainSettingsPanel.this.style.setSelectedItem(selected);
                if (((JMainSettingsPanel)JMainSettingsPanel.this).frame.loadHints) {
                    JMainSettingsPanel.this.frame.loadHints();
                }
                JMainSettingsPanel.this.frame.setPreviewImage();
                ((JMainSettingsPanel)JMainSettingsPanel.this).frame.engine.setSkin(JMainSettingsPanel.this.getSelectedSkin());
                ((JMainSettingsPanel)JMainSettingsPanel.this).frame.engine.initInterpreter();
                final File onLoadScript = new File(((JMainSettingsPanel)JMainSettingsPanel.this).frame.cfg.chainedSkinsDir.getFile(((JMainSettingsPanel)JMainSettingsPanel.this).frame.engine.getSkin()), "onload.bsh");
                if (onLoadScript.exists()) {
                    String skin = JMainSettingsPanel.this.getSelectedSkin();
                    new Thread(){
                        String skin;
                        String statusMessage;
                        Thread animator;
                        {
                            this.skin = JMainSettingsPanel.this.getSelectedSkin();
                            this.statusMessage = Msg.get("ui.loadingSkinInfo", this.skin) + "...";
                            this.setDaemon(true);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                ((JMainSettingsPanel)JMainSettingsPanel.this).frame.statusBar.pushText(this.statusMessage);
                                this.animator = new Thread("Animator thread"){
                                    boolean die;
                                    {
                                        this.die = false;
                                    }

                                    public void interrupt() {
                                        this.die = true;
                                        super.interrupt();
                                    }

                                    public void run() {
                                        Icon[] icons = new Icon[]{Icons.getIcon("big.settings1"), Icons.getIcon("big.settings2"), Icons.getIcon("big.settings3")};
                                        try {
                                            int lap = 1;
                                            while (lap < 300) {
                                                for (Icon icon : icons) {
                                                    if (this.die) {
                                                        return;
                                                    }
                                                    1.sleep(100L);
                                                    JMainSettingsPanel.this.albumSettingsButton.setIcon(icon);
                                                    if (lap == 3) {
                                                        ((JMainSettingsPanel)JMainSettingsPanel.this).frame.actions.makeAction.setEnabled(false);
                                                        ((JMainSettingsPanel)JMainSettingsPanel.this).frame.actions.makeAllAction.setEnabled(false);
                                                        ((JMainSettingsPanel)JMainSettingsPanel.this).frame.actions.makeChangesAction.setEnabled(false);
                                                    }
                                                    ++lap;
                                                }
                                            }
                                            System.err.println("Skin loading timeout. Quitting animator thread");
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                };
                                this.animator.setDaemon(true);
                                this.animator.start();
                                JMainSettingsPanel.this.frame.executeScript(onLoadScript);
                            }
                            finally {
                                this.animator.interrupt();
                                ((JMainSettingsPanel)JMainSettingsPanel.this).frame.statusBar.popText(this.statusMessage);
                                JMainSettingsPanel.this.frame.directorySelected();
                                JMainSettingsPanel.this.frame.markSkinAsClean();
                            }
                        }
                    }.start();
                }
            }
        }
    };

    public JMainSettingsPanel(JAlbumFrame frame) {
        this.frame = frame;
        this.init();
    }

    private boolean isValidDragDrop(int dropAction, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor dropFlavor = flavors[i];
            if (!dropFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.scanSkins();
        this.skin.getComponent(0).addMouseListener(this.skinsScanner);
        this.skin.addPopupMenuListener(this.skinPreviewer);
        this.style.addPopupMenuListener(this.skinPreviewer);
        DropTarget skinDropTarget = new DropTarget(){

            public void dragEnter(DropTargetDragEvent e) {
                if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.acceptDrag(1);
                } else {
                    e.rejectDrag();
                }
            }

            public void dragOver(DropTargetDragEvent e) {
                if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.acceptDrag(1);
                } else {
                    e.rejectDrag();
                }
            }

            public void dragExit(DropTargetEvent e) {
            }

            public void drop(DropTargetDropEvent e) {
                if (!e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.rejectDrop();
                    return;
                }
                e.acceptDrop(1);
                try {
                    List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    e.dropComplete(true);
                    final File f = (File)files.get(0);
                    String name = f.getName().toLowerCase();
                    if (name.endsWith(".zip") || name.endsWith(".jaskin")) {
                        new Thread(){
                            {
                                this.setDaemon(true);
                            }

                            public void run() {
                                SkinManager sm = new SkinManager();
                                sm.installSkin(f);
                            }
                        }.start();
                    }
                }
                catch (Exception ex) {
                    e.dropComplete(false);
                    Debug.showErrorDialog(JMainSettingsPanel.this, ex);
                }
            }
        };
        this.skin.setDropTarget(skinDropTarget);
        final ListCellRenderer defaultRenderer = this.skin.getRenderer();
        this.skin.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (isSelected && !cellHasFocus) {
                    JMainSettingsPanel.this.frame.setPreviewImage((String)value, JMainSettingsPanel.this.getDefaultStyleForSkin(value.toString()));
                }
                return comp;
            }
        });
        this.style.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected && !cellHasFocus) {
                    JMainSettingsPanel.this.frame.setPreviewImage(JMainSettingsPanel.this.getSelectedSkin(), value.toString());
                }
                return defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.style.setSelectedItem("Plain.css");
        this.style.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMainSettingsPanel.this.frame.setPreviewImage();
                JMainSettingsPanel.this.frame.fireStyleChanged(new JAlbumEvent(JMainSettingsPanel.this.frame));
            }
        });
        this.setupPanel();
    }

    private static void setSmallerFont(JComponent comp) {
        Font f = comp.getFont();
        comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
    }

    private void updatePublishPopupMenu() {
        JPopupMenu menu = this.publishButton.getPopup();
        menu.removeAll();
        AccountManager manager = AccountManager.getInstance();
        ButtonGroup bg = new ButtonGroup();
        try {
            menu.add(this.frame.actions.showPublishWindowAction);
            menu.addSeparator();
            DefaultListModel accounts = manager.getAccounts();
            Enumeration e = accounts.elements();
            while (e.hasMoreElements()) {
                AccountProfile a = (AccountProfile)e.nextElement();
                JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(a.getName());
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JAlbumContext.getInstance().getEngine().setAccountProfileName(e.getActionCommand());
                    }
                });
                bg.add(menuItem);
                menu.add(menuItem);
            }
            this.setSelectedAccountProfile();
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    private void setSelectedAccountProfile() {
        if (JAlbumContext.getInstance().getEngine() == null) {
            return;
        }
        JPopupMenu menu = this.publishButton.getPopup();
        String selectedAccountProfile = JAlbumContext.getInstance().getEngine().getAccountProfileName();
        for (Component comp : menu.getComponents()) {
            JRadioButtonMenuItem item;
            if (!(comp instanceof JRadioButtonMenuItem) || !(item = (JRadioButtonMenuItem)comp).getText().equals(selectedAccountProfile)) continue;
            item.setSelected(true);
            return;
        }
        if (menu.getComponent(0) instanceof JRadioButtonMenuItem) {
            ((JRadioButtonMenuItem)menu.getComponent(0)).setSelected(true);
        }
    }

    private void setupPanel() {
        if (JAlbum.isMac()) {
            JMainSettingsPanel.setSmallerFont(this.skinLabel);
            JMainSettingsPanel.setSmallerFont(this.styleLabel);
            JMainSettingsPanel.setSmallerFont(this.skin);
            JMainSettingsPanel.setSmallerFont(this.style);
            JMainSettingsPanel.setSmallerFont(this.moreSkinsLink);
            JMainSettingsPanel.setSmallerFont(this.makeAll);
            JMainSettingsPanel.setSmallerFont(this.makeChanges);
        }
        this.albumSettingsButton = new JButton(this.frame.actions.showAlbumSettingsWindow);
        this.makeAlbumButton = new JPopupButton(this.frame.actions.makeAction);
        this.makeAlbumButton.add(this.frame.actions.makeAllAction);
        this.makeAlbumButton.add(this.frame.actions.makeChangesAction);
        this.viewAlbumButton = new JButton(this.frame.actions.viewAlbumAction);
        this.publishButton = new JPopupButton(this.frame.actions.publishAction);
        ImageIcon albumSettingsIcon = Icons.getIcon("big.settings");
        ImageIcon makeAlbumIcon = Icons.getIcon("big.makeAlbum");
        ImageIcon viewAlbumIcon = Icons.getIcon("big.preview");
        ImageIcon publishIcon = Icons.getIcon("big.publish");
        this.updatePublishPopupMenu();
        AccountManager.getInstance().addAccountManagerListener(new AccountManagerListener(){

            public void accountListUpdated() {
                JMainSettingsPanel.this.updatePublishPopupMenu();
            }
        });
        JAlbumContext.getInstance().addPropertyChangeListener("engine", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JAlbumContext.getInstance().getEngine().addPropertyChangeListener("accountProfileName", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        JMainSettingsPanel.this.setSelectedAccountProfile();
                    }
                });
            }
        });
        this.albumSettingsButton.setIcon(albumSettingsIcon);
        this.makeAlbumButton.setIcon(makeAlbumIcon);
        this.viewAlbumButton.setIcon(viewAlbumIcon);
        this.publishButton.setIcon(publishIcon);
        JPanel content = JMainSettingsPanel.createRiverPanel();
        content.setBorder(BorderFactory.createEmptyBorder(6, JAlbum.isMac() ? 6 : 6, 2, 3));
        content.add("hfill", this.settingsSeparator);
        content.add("p", this.skinLabel);
        content.add(JMainSettingsPanel.emptyArea(3));
        content.add("tab hfill", this.skin);
        content.add("br left", this.styleLabel);
        content.add("tab left hfill", this.style);
        content.add("br right", this.moreSkinsLink);
        if (JAlbum.isMac()) {
            content.add(JMainSettingsPanel.emptyArea(3));
        }
        this.skin.setPreferredSize(this.skin.getPreferredSize());
        this.style.setPreferredSize(this.skin.getPreferredSize());
        this.collapsiblePanel.getContentPanel().setLayout(new BorderLayout());
        this.collapsiblePanel.getContentPanel().add((Component)this.albumSettingsButton, "Center");
        this.collapsiblePanel.getContentPanel().add(JMainSettingsPanel.emptyArea(3), "North");
        this.collapsiblePanel.setExpanded(this.frame.preferencesWindow.expandedMainSettings.isSelected());
        this.collapsiblePanel.addPropertyChangeListener("expanded", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JMainSettingsPanel.this.getParent().validate();
                ((JMainSettingsPanel)JMainSettingsPanel.this).frame.preferencesWindow.expandedMainSettings.setSelected((Boolean)evt.getNewValue());
                ((JMainSettingsPanel)JMainSettingsPanel.this).frame.preferencesWindow.savePreferences();
            }
        });
        content.add("br hfill", this.collapsiblePanel);
        content.add("p hfill", this.makeAlbumButton);
        content.add("br hfill", this.viewAlbumButton);
        content.add("br hfill", this.publishButton);
        this.setLayout(new BorderLayout());
        this.add((Component)content, "Center");
    }

    private static JPanel createRiverPanel() {
        RiverLayout layout = new RiverLayout(0, 3);
        JPanel panel = new JPanel(layout);
        panel.setBorder(null);
        return panel;
    }

    private static Component emptyArea(int size) {
        return Box.createRigidArea(new Dimension(size, size));
    }

    void setTexts() {
        this.skin.setToolTipText(Msg.get("ui.skinToolTip"));
        this.style.setToolTipText(Msg.get("ui.styleToolTip"));
        this.skinLabel.setLabelFor(this.skin);
        this.skinLabel.setText(Msg.get("ui.skin"));
        this.styleLabel.setLabelFor(this.style);
        this.styleLabel.setText(Msg.get("ui.style"));
        this.moreSkinsLink.setText(Msg.get("ui.downloadSkins"));
        this.moreSkinsLink.setToolTipText(Msg.get("ui.downloadSkinsToolTip"));
        this.moreSkinsLink.setURL("http://jalbum.net/skins");
        this.collapsiblePanel.setTitle(Msg.get("ui.more"));
        this.albumSettingsButton.setText(Msg.get("ui.settings") + "...");
        this.settingsSeparator.setText(Msg.get("ui.appearanceBorder"));
        this.makeChanges.setText(Msg.get("ui.changes"));
        this.makeChanges.setToolTipText(Msg.get("ui.makeAlbumToolTip"));
        this.makeAll.setText(Msg.get("ui.all"));
        this.makeAll.setToolTipText(Msg.get("ui.rebuildAllToolTip"));
        this.makeAlbumButton.setText(Msg.get("ui.makeAlbum"));
    }

    public void scanSkins() {
        this.skin.removeActionListener(this.skinSelectedActionListener);
        Object selected = this.skin.getSelectedItem();
        this.skin.removeAllItems();
        JAlbumFrame.fillCombo(this.skin, this.frame.cfg.chainedSkinsDir, (FileFilter)new DirectoryFilter());
        this.skin.setSelectedItem(selected);
        this.skin.addActionListener(this.skinSelectedActionListener);
        Object newSelected = this.skin.getSelectedItem();
        if (newSelected != null && !newSelected.equals(selected)) {
            this.skin.setSelectedItem(this.skin.getSelectedItem());
        }
    }

    private String getDefaultStyleForSkin(String skinName) {
        try {
            Config cfg = Config.getConfig();
            File skinDir = cfg.chainedSkinsDir.getFile(skinName);
            File stylesDir = new File(skinDir, "styles");
            Properties skinProps = IO.readPropertyFile(new File(skinDir, "hints.jap"));
            String style = skinProps.getProperty("style");
            if (style == null || !new File(stylesDir, style).exists()) {
                File[] styles = stylesDir.listFiles(new StyleFileFilter());
                if (styles != null && styles.length > 0) {
                    return styles[0].getName();
                }
                return "";
            }
            return style;
        }
        catch (IOException ex) {
            return "";
        }
    }

    String getSelectedSkin() {
        Object item = this.skin.getSelectedItem();
        if (item instanceof Item) {
            return (String)((Item)item).value;
        }
        return (String)item;
    }

    String getSelectedStyle() {
        Item item = (Item)this.style.getSelectedItem();
        if (item == null) {
            return null;
        }
        return (String)item.value;
    }

    boolean isMakeChanges() {
        return this.makeChanges.isSelected();
    }
}

