/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.Serializable;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumFileFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;

public class AlbumObjectFactory
implements Serializable {
    AlbumBean engine;
    AlbumFileFilter filter;
    private boolean cacheThumbnails = true;

    public AlbumObjectFactory(AlbumBean engine) {
        this.engine = engine;
        this.filter = new AlbumFileFilter(engine, engine.getInterpretedOutputDirectory(), engine.getIgnorePattern());
    }

    public AlbumObject createInstance(File file) {
        return new AlbumObjectImpl(file, null, this);
    }

    public AlbumObject createInstance(File file, AlbumObject parent) {
        return new AlbumObjectImpl(file, parent, this);
    }

    public boolean isCacheThumbnails() {
        return this.cacheThumbnails;
    }

    public void setCacheThumbnails(boolean cacheThumbnails) {
        this.cacheThumbnails = cacheThumbnails;
    }

    public AlbumFileFilter getFilter() {
        return this.filter;
    }
}

