/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.webdav;

import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.webdav.WebDavFile;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import se.datadosen.util.IO;

public class WebDavClient {
    HttpClient client;
    String rootDirectory;
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void connect(String homeUri, String username, String password) {
        try {
            URL url = new URL("http://" + homeUri);
            HostConfiguration hostConfig = WebDavClient.createHostConfiguration(url.getHost());
            this.rootDirectory = url.getPath();
            HttpConnectionManager connectionManager = WebDavClient.createConnectionManager(hostConfig);
            this.client = WebDavClient.createHttpClient(connectionManager, hostConfig, username, password);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return this.client != null;
    }

    public void createDirectory(String name) {
        String totalPath = IO.combinePaths(this.rootDirectory, name);
        MkColMethod m = new MkColMethod(WebDavClient.urlEncode(totalPath));
        try {
            int status = this.client.executeMethod((HttpMethod)m);
            if (status >= 500) {
                throw new RuntimeException(m.getResponseBodyAsString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            m.releaseConnection();
        }
    }

    public RemoteFile[] listFiles(String directory) {
        ArrayList<RemoteFile> files = new ArrayList<RemoteFile>();
        PropFindMethod m = null;
        try {
            String totalPath = IO.combinePaths(this.rootDirectory, directory);
            totalPath = IO.combinePaths(totalPath, "/");
            m = new PropFindMethod(WebDavClient.urlEncode(totalPath), WebDavClient.getPropsNameSet(), 1);
            int status = this.client.executeMethod((HttpMethod)m);
            if (status >= 300) {
                System.out.println("Failing listing " + totalPath);
                throw new RuntimeException(m.getResponseBodyAsString());
            }
            MultiStatusResponse[] responses = m.getResponseBodyAsMultiStatus().getResponses();
            files = new ArrayList(responses.length);
            for (int i = 0; i < responses.length - 1; ++i) {
                try {
                    RemoteFile f = this.convertResponseToRemoteFile(responses[i]);
                    if (f == null) continue;
                    files.add(f);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Failed on resource: " + responses[i] + "Exception: " + e);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (DavException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (m != null) {
                m.releaseConnection();
            }
        }
        return files.toArray(new RemoteFile[0]);
    }

    private static DavPropertyNameSet getPropsNameSet() {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.ISCOLLECTION);
        nameSet.add(DavPropertyName.GETCONTENTTYPE);
        nameSet.add(DavPropertyName.GETLASTMODIFIED);
        nameSet.add(DavPropertyName.GETCONTENTLENGTH);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        return nameSet;
    }

    void deleteFile(String name) {
        String totalPath = IO.combinePaths(this.rootDirectory, name);
        DeleteMethod m = new DeleteMethod(WebDavClient.urlEncode(totalPath));
        try {
            int status = this.client.executeMethod((HttpMethod)m);
            if (status >= 500) {
                throw new RuntimeException(m.getResponseBodyAsString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            m.releaseConnection();
        }
    }

    void deleteDirectory(String name) {
        String totalPath = IO.combinePaths(this.rootDirectory, name);
        totalPath = IO.combinePaths(totalPath, "/");
        System.out.println("deleting directory " + totalPath);
        DeleteMethod m = new DeleteMethod(WebDavClient.urlEncode(totalPath));
        try {
            int status = this.client.executeMethod((HttpMethod)m);
            if (status >= 300) {
                throw new RuntimeException(m.getResponseBodyAsString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            m.releaseConnection();
        }
    }

    void move(String from, String to) {
        String hosturl = this.client.getHostConfiguration().getHostURL();
        String totalFrom = IO.combinePaths(this.rootDirectory, from);
        String totalTo = IO.combinePaths(this.rootDirectory, to);
        totalFrom = IO.combinePaths(hosturl, totalFrom);
        totalTo = IO.combinePaths(hosturl, totalTo);
        System.out.println("Moving " + from + " to " + to);
        MoveMethod m = new MoveMethod(WebDavClient.urlEncode(totalFrom), WebDavClient.urlEncode(totalTo), false);
        try {
            int status = this.client.executeMethod((HttpMethod)m);
            if (status >= 300) {
                throw new RuntimeException(m.getResponseBodyAsString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            m.releaseConnection();
        }
    }

    void putFile(File file, String path) {
        String totalPath = IO.combinePaths(this.rootDirectory, path);
        PutMethod m = new PutMethod(WebDavClient.urlEncode(totalPath));
        String contentType = "text/plain";
        FileRequestEntity fileEntity = new FileRequestEntity(file, contentType);
        m.setRequestEntity((RequestEntity)fileEntity);
        try {
            int status = this.client.executeMethod((HttpMethod)m);
            if (status >= 500) {
                throw new RuntimeException(m.getResponseBodyAsString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            m.releaseConnection();
        }
    }

    private RemoteFile convertResponseToRemoteFile(MultiStatusResponse response) {
        DavPropertySet props = response.getProperties(200);
        String name = response.getHref();
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        if (this.isDavFolderName(name)) {
            int i = (name = name.substring(0, name.length() - 1)).lastIndexOf("/");
            if (i > 0) {
                name = name.substring(i + 1);
            }
            return new WebDavFile(name, 0L, null, true, false);
        }
        int i = name.lastIndexOf("/");
        if (i > 0) {
            name = name.substring(i + 1);
        }
        long size = Long.parseLong(props.get(DavPropertyName.GETCONTENTLENGTH).getValue().toString());
        Date date = new Date(props.get(DavPropertyName.GETLASTMODIFIED).getValue().toString());
        return new WebDavFile(name, size, date, false, false);
    }

    private static HostConfiguration createHostConfiguration(String hostUri) {
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(hostUri);
        return hostConfig;
    }

    private static HttpConnectionManager createConnectionManager(HostConfiguration hostConfig) {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        int maxHostConnections = 5;
        params.setMaxConnectionsPerHost(hostConfig, 5);
        connectionManager.setParams(params);
        return connectionManager;
    }

    private static HttpClient createHttpClient(HttpConnectionManager connectionManager, HostConfiguration hostConfig, String username, String password) {
        HttpClient client = new HttpClient(connectionManager);
        client.setHostConfiguration(hostConfig);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        return client;
    }

    private boolean isDavFolderName(String name) {
        return name.endsWith("/");
    }

    private static String urlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes = s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u007f' || chars[i] == ' ' || chars[i] == '#' || chars[i] == '%' || chars[i] == '\'') {
                sb.append('%');
                sb.append(hexDigits[(chars[i] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i] & 0xF]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }
}

